/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.text.ParseException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.OracleDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "oracle";

    @Override
    public void setConnection(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)conn, true);
        }
        catch (Exception e) {
            log.info("Could not set remarks reporting on OracleDatabase: " + e.getMessage());
        }
        super.setConnection(conn);
    }

    @Override
    public String getProductName() {
        return "Oracle";
    }

    @Override
    public String getTypeName() {
        return PRODUCT_NAME;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getBooleanType() {
        return "NUMBER(1)";
    }

    @Override
    public String getCurrencyType() {
        return "NUMBER(15, 2)";
    }

    @Override
    public String getUUIDType() {
        return "RAW(16)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    public String getDateType() {
        return "DATE";
    }

    @Override
    public String getTimeType() {
        return "DATE";
    }

    @Override
    public String getBigIntType() {
        return "NUMBER(19,0)";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "SYSDATE";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD')");
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'HH24:MI:SS')");
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            normalLiteral = normalLiteral.substring(0, normalLiteral.lastIndexOf(46)) + "'";
            StringBuffer val = new StringBuffer(26);
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return val.toString();
        }
        return "UNSUPPORTED:" + isoDate;
    }

    @Override
    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException {
        return new RawSqlStatement((super.getSelectChangeLogLockSQL().getSqlStatement(this) + " for update").toUpperCase());
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement("SELECT SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '" + this.convertRequestedSchemaToSchema(schema) + "'");
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if (super.isSystemTable(catalogName, schemaName, tableName)) {
            return true;
        }
        if (tableName.startsWith("BIN$")) {
            return true;
        }
        if (tableName.startsWith("AQ$")) {
            return true;
        }
        return tableName.startsWith("DR$");
    }

    @Override
    public boolean shouldQuoteValue(String value) {
        return super.shouldQuoteValue(value) && !value.startsWith("to_date(") && !value.equalsIgnoreCase(this.getCurrentDateTimeFunction());
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement("SELECT TEXT FROM ALL_VIEWS WHERE upper(VIEW_NAME)='" + name.toUpperCase() + "' AND OWNER='" + this.convertRequestedSchemaToSchema(schemaName) + "'");
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                defaultValue = ((String)defaultValue).indexOf("YYYY-MM-DD HH") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD HH24:MI:SS'\\)$", "") : (((String)defaultValue).indexOf("YYYY-MM-DD") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD'\\)$", "") : ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'HH24:MI:SS'\\)$", ""));
            }
            defaultValue = ((String)defaultValue).replaceFirst("'\\s*$", "'");
        }
        return super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new OracleDatabaseSnapshot(this, statusListeners, schema);
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }
}

