/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import liquibase.change.ColumnConfig;
import liquibase.change.CreateTableChange;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.sql.CopyRowsStatement;
import liquibase.database.sql.CreateIndexStatement;
import liquibase.database.sql.DropTableStatement;
import liquibase.database.sql.ReindexStatement;
import liquibase.database.sql.RenameTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.Index;
import liquibase.database.structure.SQLiteDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ISODateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends AbstractDatabase {
    private Set<String> systemTables = new HashSet<String>();
    public static final String PRODUCT_NAME = "SQLite";

    public SQLiteDatabase() {
        this.systemTables.add("sqlite_sequence");
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getBooleanType() {
        return "BOOLEAN";
    }

    @Override
    public String getClobType() {
        return "TEXT";
    }

    @Override
    public String getCurrencyType() {
        return "REAL";
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public String getDateTimeType() {
        return "TEXT";
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlite:")) {
            return "SQLite.JDBCDriver";
        }
        return null;
    }

    @Override
    public String getProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getTypeName() {
        return "sqlite";
    }

    @Override
    public String getUUIDType() {
        return "TEXT";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws JDBCException {
        return null;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    public String getTrigger(String table, String column) {
        return "CREATE TRIGGER insert_" + table + "_timeEnter AFTER  INSERT ON " + table + " BEGIN" + " UPDATE " + table + " SET " + column + " = DATETIME('NOW')" + " WHERE rowid = new.rowid END ";
    }

    @Override
    public String getAutoIncrementClause() {
        return "";
    }

    @Override
    public String getColumnType(String columnType, Boolean autoIncrement) {
        String type = columnType.equals("INTEGER") || columnType.toLowerCase(Locale.ENGLISH).contains("int") || columnType.toLowerCase(Locale.ENGLISH).contains("bit") ? "INTEGER" : (columnType.equals("TEXT") || columnType.toLowerCase(Locale.ENGLISH).contains("uuid") || columnType.toLowerCase(Locale.ENGLISH).contains("uniqueidentifier") || columnType.toLowerCase(Locale.ENGLISH).equals("uniqueidentifier") || columnType.toLowerCase(Locale.ENGLISH).equals("datetime") || columnType.toLowerCase(Locale.ENGLISH).contains("timestamp") || columnType.toLowerCase(Locale.ENGLISH).contains("char") || columnType.toLowerCase(Locale.ENGLISH).contains("clob") || columnType.toLowerCase(Locale.ENGLISH).contains("text") ? "TEXT" : (columnType.equals("REAL") || columnType.toLowerCase(Locale.ENGLISH).contains("float") ? "REAL" : (columnType.toLowerCase(Locale.ENGLISH).contains("blob") || columnType.toLowerCase(Locale.ENGLISH).contains("binary") ? "BLOB" : (columnType.toLowerCase(Locale.ENGLISH).contains("boolean") || columnType.toLowerCase(Locale.ENGLISH).contains("binary") ? "BOOLEAN" : super.getColumnType(columnType, autoIncrement)))));
        return type;
    }

    public static Collection<SqlStatement> getAlterTableStatements(AlterTableVisitor alterTableVisitor, Database database, String schemaName, String tableName) throws UnsupportedChangeException, JDBCException {
        Vector<SqlStatement> statements = new Vector<SqlStatement>();
        SQLiteDatabaseSnapshot snapshot = new SQLiteDatabaseSnapshot(database);
        Table table = snapshot.getTable(tableName);
        Vector<ColumnConfig> createColumns = new Vector<ColumnConfig>();
        Vector<ColumnConfig> copyColumns = new Vector<ColumnConfig>();
        if (table != null) {
            for (Column column : table.getColumns()) {
                ColumnConfig copy_column;
                ColumnConfig new_column = new ColumnConfig(column);
                if (alterTableVisitor.createThisColumn(new_column)) {
                    createColumns.add(new_column);
                }
                if (!alterTableVisitor.copyThisColumn(copy_column = new ColumnConfig(column))) continue;
                copyColumns.add(copy_column);
            }
        }
        for (ColumnConfig column : alterTableVisitor.getColumnsToAdd()) {
            ColumnConfig copy_column;
            ColumnConfig new_column = new ColumnConfig(column);
            if (alterTableVisitor.createThisColumn(new_column)) {
                createColumns.add(new_column);
            }
            if (!alterTableVisitor.copyThisColumn(copy_column = new ColumnConfig(column))) continue;
            copyColumns.add(copy_column);
        }
        Vector<Index> newIndices = new Vector<Index>();
        for (Index index : snapshot.getIndexes()) {
            if (!index.getTable().getName().equalsIgnoreCase(tableName) || !alterTableVisitor.createThisIndex(index)) continue;
            newIndices.add(index);
        }
        String temp_table_name = tableName + "_temporary";
        statements.add(new RenameTableStatement(schemaName, tableName, temp_table_name));
        CreateTableChange ct_change_tmp = new CreateTableChange();
        ct_change_tmp.setSchemaName(schemaName);
        ct_change_tmp.setTableName(tableName);
        for (ColumnConfig column : createColumns) {
            ct_change_tmp.addColumn(column);
        }
        statements.addAll(Arrays.asList(ct_change_tmp.generateStatements(database)));
        statements.add(new CopyRowsStatement(temp_table_name, tableName, copyColumns));
        statements.add(new DropTableStatement(schemaName, temp_table_name, false));
        statements.add(new ReindexStatement(schemaName, tableName));
        for (Index index_config : newIndices) {
            statements.add(new CreateIndexStatement(index_config.getName(), schemaName, tableName, index_config.isUnique(), index_config.getColumns().toArray(new String[index_config.getColumns().size()])));
        }
        return statements;
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        try {
            String username = this.getConnection().getMetaData().getUserName();
            if (username == null) {
                username = "liquibase";
            }
            return username;
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    protected Set<String> getSystemTablesAndViews() {
        return this.systemTables;
    }

    @Override
    public String getDateLiteral(Timestamp date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new SQLiteDatabaseSnapshot(this);
    }

    public static interface AlterTableVisitor {
        public ColumnConfig[] getColumnsToAdd();

        public boolean copyThisColumn(ColumnConfig var1);

        public boolean createThisColumn(ColumnConfig var1);

        public boolean createThisIndex(Index var1);
    }
}

