/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.UnsupportedDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedDatabase
extends AbstractDatabase {
    private String dateTimeType;

    @Override
    public void setConnection(Connection conn) {
        super.setConnection(conn);
        this.dateTimeType = this.findDateTypeType();
        if (this.currentDateTimeFunction == null) {
            this.currentDateTimeFunction = this.findCurrentDateTimeFunction();
        }
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return null;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public String getBooleanType() {
        return "INT";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getCurrencyType() {
        return "DECIMAL";
    }

    @Override
    public String getUUIDType() {
        return "CHAR(36)";
    }

    @Override
    public String getClobType() {
        return "CLOB";
    }

    @Override
    public String getBlobType() {
        return "BLOB";
    }

    @Override
    public String getDateTimeType() {
        return this.dateTimeType;
    }

    private String findDateTypeType() {
        ResultSet typeInfo = null;
        try {
            typeInfo = this.getConnection().getMetaData().getTypeInfo();
            while (typeInfo.next()) {
                if (typeInfo.getInt("DATA_TYPE") != 93) continue;
                String string = typeInfo.getString("TYPE_NAME");
                return string;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (typeInfo != null) {
                try {
                    typeInfo.close();
                }
                catch (SQLException e) {}
            }
        }
        return "DATETIME";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return false;
    }

    @Override
    public String getDefaultDriver(String url) {
        return null;
    }

    @Override
    public String getProductName() {
        return "Unsupported Database (" + this.getDatabaseProductName() + ")";
    }

    @Override
    public String getTypeName() {
        return this.getDatabaseProductName().toLowerCase().replaceAll("\\W", "");
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    private String findCurrentDateTimeFunction() {
        try {
            String[] timeDateFunctions;
            String nowFunction = null;
            String dateFunction = null;
            String dateTimeFunction = null;
            String timeStampFunction = null;
            for (String functionName : timeDateFunctions = this.getConnection().getMetaData().getTimeDateFunctions().split(",")) {
                String function = functionName.trim().toUpperCase();
                if (function.endsWith("TIMESTAMP")) {
                    timeStampFunction = functionName.trim();
                }
                if (function.endsWith("DATETIME")) {
                    dateTimeFunction = functionName.trim();
                }
                if (function.endsWith("DATE")) {
                    dateFunction = functionName.trim();
                }
                if (!"NOW".equals(function)) continue;
                nowFunction = functionName.trim();
            }
            if (nowFunction != null) {
                return "{fn " + nowFunction + "()" + "}";
            }
            if (timeStampFunction != null) {
                return "{fn " + timeStampFunction + "()" + "}";
            }
            if (dateTimeFunction != null) {
                return "{fn " + dateTimeFunction + "()" + "}";
            }
            if (dateFunction != null) {
                return "{fn " + dateFunction + "()" + "}";
            }
            return "CURRENT_TIMESTAMP";
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean canCreateChangeLogTable() throws JDBCException {
        try {
            int maxIndexLength = this.getConnection().getMetaData().getMaxIndexLength();
            return maxIndexLength == 0 || maxIndexLength >= 555 && super.canCreateChangeLogTable();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new UnsupportedDatabaseSnapshot(this, statusListeners, schema);
    }
}

