/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropIndexStatement
implements SqlStatement {
    private String indexName;
    private String tableSchemaName;
    private String tableName;

    public DropIndexStatement(String indexName, String tableSchemaName, String tableName) {
        this.tableSchemaName = tableSchemaName;
        this.indexName = indexName;
        this.tableName = tableName;
    }

    public String getTableSchemaName() {
        return this.tableSchemaName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        String schemaName = this.getTableSchemaName();
        if (schemaName != null && !database.supportsSchemas()) {
            throw new StatementNotSupportedOnDatabaseException("Database does not support schemas", this, database);
        }
        if (database instanceof MySQLDatabase) {
            if (this.getTableName() == null) {
                throw new StatementNotSupportedOnDatabaseException("tableName is required", this, database);
            }
            return "DROP INDEX " + database.escapeIndexName(null, this.getIndexName()) + " ON " + database.escapeTableName(schemaName, this.getTableName());
        }
        if (database instanceof MSSQLDatabase) {
            if (this.getTableName() == null) {
                throw new StatementNotSupportedOnDatabaseException("tableName is required", this, database);
            }
            return "DROP INDEX " + database.escapeTableName(schemaName, this.getTableName()) + "." + database.escapeIndexName(null, this.getIndexName());
        }
        return "DROP INDEX " + database.escapeIndexName(null, this.getIndexName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

