/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.PostgresDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropSequenceStatement
implements SqlStatement {
    private String schemaName;
    private String sequenceName;

    public DropSequenceStatement(String schemaName, String sequenceName) {
        this.schemaName = schemaName;
        this.sequenceName = sequenceName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        String sql = "DROP SEQUENCE " + database.escapeSequenceName(this.getSchemaName(), this.getSequenceName());
        if (database instanceof PostgresDatabase) {
            sql = sql + " CASCADE";
        }
        return sql;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return database.supportsSequences();
    }
}

