/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql.visitor;

import java.util.HashMap;
import java.util.Map;
import liquibase.database.sql.visitor.AppendSqlVisitor;
import liquibase.database.sql.visitor.PrependSqlVisitor;
import liquibase.database.sql.visitor.RegExpReplaceSqlVisitor;
import liquibase.database.sql.visitor.ReplaceSqlVisitor;
import liquibase.database.sql.visitor.SqlVisitor;

public class SqlVisitorFactory {
    private final Map<String, Class> tagToClassMap = new HashMap<String, Class>();
    private static final SqlVisitorFactory instance = new SqlVisitorFactory();

    private SqlVisitorFactory() {
        Class[] visitors = new Class[]{PrependSqlVisitor.class, AppendSqlVisitor.class, RegExpReplaceSqlVisitor.class, ReplaceSqlVisitor.class};
        try {
            for (Class visitorClass : visitors) {
                SqlVisitor visitor = (SqlVisitor)visitorClass.newInstance();
                this.tagToClassMap.put(visitor.getTagName(), visitorClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SqlVisitorFactory getInstance() {
        return instance;
    }

    public SqlVisitor create(String tagName) {
        Class aClass = this.tagToClassMap.get(tagName);
        if (aClass == null) {
            throw new RuntimeException("Unknown tag: " + tagName);
        }
        try {
            return (SqlVisitor)aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

