/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKey
implements DatabaseObject,
Comparable<ForeignKey> {
    private Table primaryKeyTable;
    private String primaryKeyColumns;
    private Table foreignKeyTable;
    private String foreignKeyColumns;
    private String name;
    private boolean deferrable;
    private boolean initiallyDeferred;
    private Integer updateRule;
    private Integer deleteRule;

    public Table getPrimaryKeyTable() {
        return this.primaryKeyTable;
    }

    public void setPrimaryKeyTable(Table primaryKeyTable) {
        this.primaryKeyTable = primaryKeyTable;
    }

    public String getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void addPrimaryKeyColumn(String primaryKeyColumn) {
        this.primaryKeyColumns = this.primaryKeyColumns == null || this.primaryKeyColumns.length() == 0 ? primaryKeyColumn : this.primaryKeyColumns + ", " + primaryKeyColumn;
    }

    public void setPrimaryKeyColumns(String primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public Table getForeignKeyTable() {
        return this.foreignKeyTable;
    }

    public void setForeignKeyTable(Table foreignKeyTable) {
        this.foreignKeyTable = foreignKeyTable;
    }

    public String getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public void addForeignKeyColumn(String foreignKeyColumn) {
        this.foreignKeyColumns = this.foreignKeyColumns == null || this.foreignKeyColumns.length() == 0 ? foreignKeyColumn : this.foreignKeyColumns + ", " + foreignKeyColumn;
    }

    public void setForeignKeyColumns(String foreignKeyColumns) {
        this.foreignKeyColumns = foreignKeyColumns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName() + "(" + this.getForeignKeyTable() + "." + this.getForeignKeyColumns() + " ->" + this.getPrimaryKeyTable() + "." + this.getPrimaryKeyColumns() + ")";
    }

    public boolean isDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    public void setUpdateRule(Integer rule) {
        this.updateRule = rule;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public void setDeleteRule(Integer rule) {
        this.deleteRule = rule;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKey that = (ForeignKey)o;
        return this.getForeignKeyColumns().equalsIgnoreCase(that.getForeignKeyColumns()) && this.foreignKeyTable.equals(that.foreignKeyTable) && this.getPrimaryKeyColumns().equalsIgnoreCase(that.getPrimaryKeyColumns()) && this.primaryKeyTable.equals(that.primaryKeyTable);
    }

    public int hashCode() {
        int result = 0;
        if (this.primaryKeyTable != null) {
            result = this.primaryKeyTable.hashCode();
        }
        if (this.primaryKeyColumns != null) {
            result = 31 * result + this.primaryKeyColumns.toUpperCase().hashCode();
        }
        if (this.foreignKeyTable != null) {
            result = 31 * result + this.foreignKeyTable.hashCode();
        }
        if (this.foreignKeyColumns != null) {
            result = 31 * result + this.foreignKeyColumns.toUpperCase().hashCode();
        }
        if (this.updateRule != null) {
            result = 31 * result + this.updateRule.hashCode();
        }
        if (this.deleteRule != null) {
            result = 31 * result + this.deleteRule.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(ForeignKey o) {
        int returnValue = 0;
        if (this.getForeignKeyTable() != null && o.getForeignKeyTable() != null) {
            returnValue = this.getForeignKeyTable().compareTo(o.getForeignKeyTable());
        }
        if (returnValue == 0 && this.getForeignKeyColumns() != null && o.getForeignKeyColumns() != null) {
            returnValue = this.getForeignKeyColumns().compareToIgnoreCase(o.getForeignKeyColumns());
        }
        if (returnValue == 0 && this.getName() != null && o.getName() != null) {
            returnValue = this.getName().compareToIgnoreCase(o.getName());
        }
        if (returnValue == 0 && this.getPrimaryKeyTable() != null && o.getPrimaryKeyTable() != null) {
            returnValue = this.getPrimaryKeyTable().compareTo(o.getPrimaryKeyTable());
        }
        if (returnValue == 0 && this.getPrimaryKeyColumns() != null && o.getPrimaryKeyColumns() != null) {
            returnValue = this.getPrimaryKeyColumns().compareToIgnoreCase(o.getPrimaryKeyColumns());
        }
        if (returnValue == 0 && this.updateRule != null && o.getUpdateRule() != null) {
            returnValue = this.updateRule.compareTo(o.getUpdateRule());
        }
        if (returnValue == 0 && this.deleteRule != null && o.getDeleteRule() != null) {
            returnValue = this.deleteRule.compareTo(o.getDeleteRule());
        }
        return returnValue;
    }

    private String toDisplayString(List<String> columnsNames) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String columnName : columnsNames) {
            sb.append(columnName);
            if (++i >= columnsNames.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

