/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.database.Database;
import liquibase.database.HibernateDatabase;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.HibernateGenericDialect;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.UniqueKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDatabaseSnapshot
implements DatabaseSnapshot {
    private HibernateDatabase database;
    private Set<Table> tables = new HashSet<Table>();
    private Set<Column> columns = new HashSet<Column>();
    private Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    private Set<Index> indexes = new HashSet<Index>();
    private Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    private Set<Sequence> sequences = new HashSet<Sequence>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    private Map<String, Table> tablesMap = new HashMap<String, Table>();
    private Map<String, Column> columnsMap = new HashMap<String, Column>();
    private static final Logger log = LogFactory.getLogger();

    public HibernateDatabaseSnapshot(HibernateDatabase database) throws JDBCException {
        try {
            org.hibernate.mapping.Table hibernateTable;
            Configuration cfg = database.createConfiguration();
            cfg.configure(database.getConfigFile());
            this.database = database;
            HibernateGenericDialect dialect = new HibernateGenericDialect(cfg.getProperty("dialect"));
            cfg.buildMappings();
            Mapping mapping = cfg.buildMapping();
            Iterator tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                hibernateTable = (org.hibernate.mapping.Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                Table table = new Table(hibernateTable.getName());
                System.out.println("seen table " + table.getName());
                this.tablesMap.put(table.getName(), table);
                Iterator columnIterator = hibernateTable.getColumnIterator();
                while (columnIterator.hasNext()) {
                    org.hibernate.mapping.Column hibernateColumn = (org.hibernate.mapping.Column)columnIterator.next();
                    Column column = new Column();
                    column.setName(hibernateColumn.getName());
                    column.setDataType(hibernateColumn.getSqlTypeCode(mapping));
                    if (column.isNumeric()) {
                        column.setColumnSize(hibernateColumn.getPrecision());
                    } else {
                        column.setColumnSize(hibernateColumn.getLength());
                    }
                    column.setDecimalDigits(hibernateColumn.getScale());
                    column.setDefaultValue(hibernateColumn.getDefaultValue());
                    column.setNullable(hibernateColumn.isNullable());
                    column.setPrimaryKey(this.isPrimaryKey(hibernateTable, hibernateColumn));
                    column.setTable(table);
                    column.setTypeName(hibernateColumn.getSqlType((Dialect)dialect, mapping).replaceFirst("\\(.*\\)", ""));
                    column.setUnique(hibernateColumn.isUnique());
                    column.setCertainDataType(false);
                    this.columnsMap.put(table.getName() + "." + column.getName(), column);
                    table.getColumns().add(column);
                }
                Iterator indexIterator = hibernateTable.getIndexIterator();
                while (indexIterator.hasNext()) {
                    org.hibernate.mapping.Index hibernateIndex = (org.hibernate.mapping.Index)indexIterator.next();
                    Index index = new Index();
                    index.setTable(table);
                    index.setName(hibernateIndex.getName());
                    columnIterator = hibernateIndex.getColumnIterator();
                    while (columnIterator.hasNext()) {
                        org.hibernate.mapping.Column hibernateColumn = (org.hibernate.mapping.Column)columnIterator.next();
                        index.getColumns().add(hibernateColumn.getName());
                    }
                    this.indexes.add(index);
                }
                Iterator uniqueIterator = hibernateTable.getUniqueKeyIterator();
                while (uniqueIterator.hasNext()) {
                    UniqueKey hiberateUnique = (UniqueKey)uniqueIterator.next();
                    Index index = new Index();
                    index.setTable(table);
                    index.setName(hiberateUnique.getName());
                    columnIterator = hiberateUnique.getColumnIterator();
                    while (columnIterator.hasNext()) {
                        org.hibernate.mapping.Column hibernateColumn = (org.hibernate.mapping.Column)columnIterator.next();
                        index.getColumns().add(hibernateColumn.getName());
                    }
                    this.indexes.add(index);
                }
                org.hibernate.mapping.PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
                if (hibernatePrimaryKey == null) continue;
                PrimaryKey pk = new PrimaryKey();
                pk.setName(hibernatePrimaryKey.getName());
                pk.setTable(table);
                for (Object hibernateColumn : hibernatePrimaryKey.getColumns()) {
                    pk.getColumnNamesAsList().add(((org.hibernate.mapping.Column)hibernateColumn).getName());
                }
                this.primaryKeys.add(pk);
            }
            this.tables = new HashSet<Table>(this.tablesMap.values());
            this.columns = new HashSet<Column>(this.columnsMap.values());
            tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                hibernateTable = (org.hibernate.mapping.Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                Iterator fkIterator = hibernateTable.getForeignKeyIterator();
                while (fkIterator.hasNext()) {
                    org.hibernate.mapping.ForeignKey hibernateForeignKey = (org.hibernate.mapping.ForeignKey)fkIterator.next();
                    if (hibernateForeignKey.getTable() == null || hibernateForeignKey.getReferencedTable() == null || !hibernateForeignKey.isPhysicalConstraint()) continue;
                    ForeignKey fk = new ForeignKey();
                    fk.setName(hibernateForeignKey.getName());
                    fk.setForeignKeyTable(this.getTable(hibernateForeignKey.getTable().getName()));
                    ArrayList<String> fkColumns = new ArrayList<String>();
                    for (Object column : hibernateForeignKey.getColumns()) {
                        fkColumns.add(((org.hibernate.mapping.Column)column).getName());
                    }
                    fk.setForeignKeyColumns(StringUtils.join(fkColumns, ", "));
                    fk.setPrimaryKeyTable(this.getTable(hibernateForeignKey.getReferencedTable().getName()));
                    fkColumns = new ArrayList();
                    for (Object column : hibernateForeignKey.getReferencedColumns()) {
                        fkColumns.add(((org.hibernate.mapping.Column)column).getName());
                    }
                    if (fkColumns.size() == 0) {
                        for (Object column : hibernateForeignKey.getReferencedTable().getPrimaryKey().getColumns()) {
                            fkColumns.add(((org.hibernate.mapping.Column)column).getName());
                        }
                    }
                    fk.setPrimaryKeyColumns(StringUtils.join(fkColumns, ", "));
                    this.foreignKeys.add(fk);
                }
            }
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
    }

    private boolean isPrimaryKey(org.hibernate.mapping.Table hibernateTable, org.hibernate.mapping.Column hibernateColumn) {
        org.hibernate.mapping.PrimaryKey key = hibernateTable.getPrimaryKey();
        if (key == null) {
            return false;
        }
        Iterator columnIterator = key.getColumnIterator();
        while (columnIterator.hasNext()) {
            if (!columnIterator.next().equals(hibernateColumn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public Set<View> getViews() {
        return new HashSet<View>();
    }

    @Override
    public Column getColumn(Column column) {
        if (column.getTable() == null) {
            return this.getColumn(column.getView().getName(), column.getName());
        }
        return this.getColumn(column.getTable().getName(), column.getName());
    }

    @Override
    public Column getColumn(String tableName, String columnName) {
        String tableAndColumn = tableName + "." + columnName;
        Column returnColumn = this.columnsMap.get(tableAndColumn);
        if (returnColumn == null) {
            for (String key : this.columnsMap.keySet()) {
                if (!key.equalsIgnoreCase(tableAndColumn)) continue;
                return this.columnsMap.get(key);
            }
        }
        return returnColumn;
    }

    @Override
    public Set<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Table getTable(String tableName) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    @Override
    public ForeignKey getForeignKey(String foreignKeyName) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (!fk.getName().equalsIgnoreCase(foreignKeyName)) continue;
            return fk;
        }
        return null;
    }

    @Override
    public Sequence getSequence(String sequenceName) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(sequenceName)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public Index getIndex(String indexName) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    @Override
    public View getView(String viewName) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(viewName)) continue;
            return view;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKey(String pkName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getName().equalsIgnoreCase(pkName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKeyForTable(String tableName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getTable().getName().equalsIgnoreCase(tableName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() {
        return false;
    }

    @Override
    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    @Override
    public UniqueConstraint getUniqueConstraint(String ucName) {
        for (UniqueConstraint uc : this.getUniqueConstraints()) {
            if (!uc.getName().equalsIgnoreCase(ucName)) continue;
            return uc;
        }
        return null;
    }
}

