/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.Column;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabaseSnapshot
extends SqlDatabaseSnapshot {
    public SQLiteDatabaseSnapshot() {
    }

    public SQLiteDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public SQLiteDatabaseSnapshot(Database database, String schema) throws JDBCException {
        this(database, null, schema);
    }

    public SQLiteDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        this(database, statusListeners, database.getDefaultSchemaName());
    }

    public SQLiteDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        super(database, statusListeners, requestedSchema);
    }

    @Override
    protected void readTablesAndViews(String schema) throws SQLException, JDBCException {
        this.updateListeners("Reading tables for " + this.database.toString() + " ...");
        ResultSet rs = this.databaseMetaData.getTables(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, new String[]{"TABLE", "VIEW"});
        while (rs.next()) {
            String type = rs.getString("TABLE_TYPE");
            String name = rs.getString("TABLE_NAME");
            String schemaName = rs.getString("TABLE_SCHEM");
            String catalogName = rs.getString("TABLE_CAT");
            String remarks = rs.getString("REMARKS");
            if (this.database.isSystemTable(catalogName, schemaName, name) || this.database.isLiquibaseTable(name) || this.database.isSystemView(catalogName, schemaName, name)) continue;
            if ("TABLE".equals(type)) {
                Table table = new Table(name);
                table.setRemarks(StringUtils.trimToNull(remarks));
                table.setDatabase(this.database);
                this.tablesMap.put(name, table);
                continue;
            }
            if (!"VIEW".equals(type)) continue;
            View view = new View();
            view.setName(name);
            try {
                view.setDefinition(this.database.getViewDefinition(schema, name));
            }
            catch (JDBCException e) {
                System.out.println("Error getting view with " + ((AbstractDatabase)this.database).getViewDefinitionSql(schema, name));
                throw e;
            }
            this.viewsMap.put(name, view);
        }
        rs.close();
    }

    @Override
    protected void readForeignKeyInformation(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading foreign keys for " + this.database.toString() + " ...");
    }

    @Override
    protected void readPrimaryKeys(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading primary keys for " + this.database.toString() + " ...");
        ArrayList<PrimaryKey> foundPKs = new ArrayList<PrimaryKey>();
        for (Table table : this.tablesMap.values()) {
            ResultSet rs = this.databaseMetaData.getPrimaryKeys(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), table.getName());
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                short position = rs.getShort("KEY_SEQ");
                if (!(this.database instanceof SQLiteDatabase)) {
                    position = (short)(position - 1);
                }
                boolean foundExistingPK = false;
                for (PrimaryKey pk : foundPKs) {
                    if (!pk.getTable().getName().equals(tableName)) continue;
                    pk.addColumnName(position, columnName);
                    foundExistingPK = true;
                }
                if (foundExistingPK) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setTable(table);
                primaryKey.addColumnName(position, columnName);
                primaryKey.setName(rs.getString("PK_NAME"));
                foundPKs.add(primaryKey);
            }
            rs.close();
        }
        this.primaryKeys.addAll(foundPKs);
    }

    @Override
    protected void readColumns(String schema) throws SQLException, JDBCException {
        this.updateListeners("Reading columns for " + this.database.toString() + " ...");
        if (this.database instanceof SQLiteDatabase) {
            for (Table cur_table : this.tablesMap.values()) {
                Statement selectStatement = this.database.getConnection().createStatement();
                ResultSet rs = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), cur_table.getName(), null);
                if (rs == null) {
                    rs = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), cur_table.getName(), null);
                }
                while (rs != null && rs.next()) {
                    Column columnInfo = this.readColumnInfo(schema, rs);
                    if (columnInfo == null) continue;
                    this.columnsMap.put(columnInfo.getTable().getName() + "." + columnInfo.getName(), columnInfo);
                }
                if (rs != null) {
                    rs.close();
                }
                selectStatement.close();
            }
        } else {
            Statement selectStatement = this.database.getConnection().createStatement();
            ResultSet rs = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, null);
            while (rs.next()) {
                Column columnInfo = this.readColumnInfo(schema, rs);
                if (columnInfo == null) continue;
                this.columnsMap.put(columnInfo.getTable().getName() + "." + columnInfo.getName(), columnInfo);
            }
            rs.close();
            selectStatement.close();
        }
    }

    private Column readColumnInfo(String schema, ResultSet rs) throws SQLException, JDBCException {
        String upperCaseTableName;
        Column columnInfo = new Column();
        String tableName = rs.getString("TABLE_NAME");
        String columnName = rs.getString("COLUMN_NAME");
        String schemaName = rs.getString("TABLE_SCHEM");
        String catalogName = rs.getString("TABLE_CAT");
        if (this.database.isSystemTable(catalogName, schemaName, upperCaseTableName = tableName.toUpperCase(Locale.ENGLISH)) || this.database.isLiquibaseTable(upperCaseTableName)) {
            return null;
        }
        Table table = (Table)this.tablesMap.get(tableName);
        if (table == null) {
            View view = (View)this.viewsMap.get(tableName);
            if (view == null) {
                log.info("Could not find table or view " + tableName + " for column " + columnName);
                return null;
            }
            columnInfo.setView(view);
            view.getColumns().add(columnInfo);
        } else {
            columnInfo.setTable(table);
            table.getColumns().add(columnInfo);
        }
        columnInfo.setName(columnName);
        columnInfo.setDataType(rs.getInt("DATA_TYPE"));
        columnInfo.setColumnSize(rs.getInt("COLUMN_SIZE"));
        columnInfo.setDecimalDigits(rs.getInt("DECIMAL_POINTS"));
        Object defaultValue = rs.getObject("COLUMN_DEF");
        try {
            columnInfo.setDefaultValue(this.database.convertDatabaseValueToJavaObject(defaultValue, columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits()));
        }
        catch (ParseException e) {
            throw new JDBCException(e);
        }
        int nullable = rs.getInt("NULLABLE");
        if (nullable == 0) {
            columnInfo.setNullable(false);
        } else if (nullable == 1) {
            columnInfo.setNullable(true);
        }
        columnInfo.setPrimaryKey(this.isPrimaryKey(columnInfo));
        columnInfo.setAutoIncrement(this.database.isColumnAutoIncrement(schema, tableName, columnName));
        columnInfo.setTypeName(this.database.getColumnType(rs.getString("TYPE_NAME"), columnInfo.isAutoIncrement()));
        return columnInfo;
    }

    @Override
    protected void readIndexes(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading indexes for " + this.database.toString() + " ...");
        for (Table table : this.tablesMap.values()) {
            String sql;
            HashMap<String, Index> indexMap;
            Statement statement;
            ResultSet rs;
            block14: {
                rs = null;
                statement = null;
                indexMap = new HashMap<String, Index>();
                statement = this.database.getConnection().createStatement();
                sql = "PRAGMA index_list(" + table.getName() + ");";
                try {
                    rs = statement.executeQuery(sql);
                }
                catch (SQLException e) {
                    if (e.getMessage().equals("query does not return ResultSet")) break block14;
                    System.err.println(e);
                }
            }
            while (rs != null && rs.next()) {
                String index_name = rs.getString("name");
                boolean index_unique = rs.getBoolean("unique");
                sql = "PRAGMA index_info(" + index_name + ");";
                Statement statement_2 = this.database.getConnection().createStatement();
                ResultSet rs_2 = statement_2.executeQuery(sql);
                while (rs_2 != null && rs_2.next()) {
                    Index indexInformation;
                    int index_column_seqno = rs_2.getInt("seqno");
                    String index_column_name = rs_2.getString("name");
                    if (index_unique) {
                        Column column = (Column)this.columnsMap.get(table.getName() + "." + index_column_name);
                        column.setUnique(true);
                        continue;
                    }
                    if (indexMap.containsKey(index_name)) {
                        indexInformation = (Index)indexMap.get(index_name);
                    } else {
                        indexInformation = new Index();
                        indexInformation.setTable(table);
                        indexInformation.setName(index_name);
                        indexInformation.setFilterCondition("");
                        indexMap.put(index_name, indexInformation);
                    }
                    indexInformation.getColumns().add(index_column_seqno, index_column_name);
                }
                if (rs_2 != null) {
                    rs_2.close();
                }
                if (statement_2 == null) continue;
                statement_2.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            for (Map.Entry entry : indexMap.entrySet()) {
                this.indexes.add(entry.getValue());
            }
        }
        HashSet<Index> indexesToRemove = new HashSet<Index>();
        for (Index index : this.indexes) {
            for (PrimaryKey pk : this.primaryKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(pk.getTable().getName()) || !index.getColumnNames().equals(pk.getColumnNames())) continue;
                indexesToRemove.add(index);
            }
        }
        this.indexes.removeAll(indexesToRemove);
    }

    @Override
    protected void readSequences(String schema) throws JDBCException {
        this.updateListeners("Reading sequences for " + this.database.toString() + " ...");
        if (this.database.supportsSequences()) {
            List sequenceNamess = this.database.getJdbcTemplate().queryForList(this.database.createFindSequencesSQL(schema), String.class, new ArrayList<SqlVisitor>());
            for (String sequenceName : sequenceNamess) {
                Sequence seq = new Sequence();
                seq.setName(sequenceName.trim());
                this.sequences.add(seq);
            }
        }
    }
}

