/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDatabaseSnapshot
implements DatabaseSnapshot {
    protected DatabaseMetaData databaseMetaData;
    protected Database database;
    protected Set<Table> tables = new HashSet<Table>();
    protected Set<View> views = new HashSet<View>();
    protected Set<Column> columns = new HashSet<Column>();
    protected Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    protected Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    protected Set<Index> indexes = new HashSet<Index>();
    protected Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    protected Set<Sequence> sequences = new HashSet<Sequence>();
    protected Map<String, Table> tablesMap = new HashMap<String, Table>();
    protected Map<String, View> viewsMap = new HashMap<String, View>();
    protected Map<String, Column> columnsMap = new HashMap<String, Column>();
    private Set<DiffStatusListener> statusListeners;
    protected static final Logger log = LogFactory.getLogger();
    private String schema;
    private boolean hasDatabaseChangeLogTable = false;

    public SqlDatabaseSnapshot() {
    }

    public SqlDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public SqlDatabaseSnapshot(Database database, String schema) throws JDBCException {
        this(database, null, schema);
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        this(database, statusListeners, database.getDefaultSchemaName());
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        try {
            this.schema = requestedSchema;
            this.database = database;
            this.databaseMetaData = database.getConnection().getMetaData();
            this.statusListeners = statusListeners;
            this.readTablesAndViews(requestedSchema);
            this.readForeignKeyInformation(requestedSchema);
            this.readPrimaryKeys(requestedSchema);
            this.readColumns(requestedSchema);
            this.readUniqueConstraints(requestedSchema);
            this.readIndexes(requestedSchema);
            this.readSequences(requestedSchema);
            this.tables = new HashSet<Table>(this.tablesMap.values());
            this.views = new HashSet<View>(this.viewsMap.values());
            this.columns = new HashSet<Column>(this.columnsMap.values());
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public Set<View> getViews() {
        return this.views;
    }

    @Override
    public Column getColumn(Column column) {
        if (column.getTable() == null) {
            return this.getColumn(column.getView().getName(), column.getName());
        }
        return this.getColumn(column.getTable().getName(), column.getName());
    }

    @Override
    public Column getColumn(String tableName, String columnName) {
        String tableAndColumn = tableName + "." + columnName;
        Column returnColumn = this.columnsMap.get(tableAndColumn);
        if (returnColumn == null) {
            for (String key : this.columnsMap.keySet()) {
                if (!key.equalsIgnoreCase(tableAndColumn)) continue;
                return this.columnsMap.get(key);
            }
        }
        return returnColumn;
    }

    @Override
    public Set<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected void readTablesAndViews(String schema) throws SQLException, JDBCException {
        this.updateListeners("Reading tables for " + this.database.toString() + " ...");
        ResultSet rs = this.databaseMetaData.getTables(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, new String[]{"TABLE", "VIEW"});
        while (rs.next()) {
            String type = rs.getString("TABLE_TYPE");
            String name = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
            String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
            String catalogName = this.convertFromDatabaseName(rs.getString("TABLE_CAT"));
            String remarks = rs.getString("REMARKS");
            if (this.database.isSystemTable(catalogName, schemaName, name) || this.database.isLiquibaseTable(name) || this.database.isSystemView(catalogName, schemaName, name)) {
                if (!name.equalsIgnoreCase(this.database.getDatabaseChangeLogTableName())) continue;
                this.hasDatabaseChangeLogTable = true;
                continue;
            }
            if ("TABLE".equals(type)) {
                Table table = new Table(name);
                table.setRemarks(StringUtils.trimToNull(remarks));
                table.setDatabase(this.database);
                this.tablesMap.put(name, table);
                continue;
            }
            if (!"VIEW".equals(type)) continue;
            View view = new View();
            view.setName(name);
            try {
                view.setDefinition(this.database.getViewDefinition(schema, name));
            }
            catch (JDBCException e) {
                System.out.println("Error getting " + this.database.getConnectionURL() + " view with " + ((AbstractDatabase)this.database).getViewDefinitionSql(schema, name));
                throw e;
            }
            this.viewsMap.put(name, view);
        }
        rs.close();
    }

    protected String convertFromDatabaseName(String objectName) {
        if (objectName == null) {
            return null;
        }
        return objectName;
    }

    protected void readColumns(String schema) throws SQLException, JDBCException {
        this.updateListeners("Reading columns for " + this.database.toString() + " ...");
        Statement selectStatement = this.database.getConnection().createStatement();
        ResultSet rs = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, null);
        while (rs.next()) {
            Column columnInfo = new Column();
            String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
            String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
            String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
            String catalogName = this.convertFromDatabaseName(rs.getString("TABLE_CAT"));
            String remarks = rs.getString("REMARKS");
            if (this.database.isSystemTable(catalogName, schemaName, tableName) || this.database.isLiquibaseTable(tableName)) continue;
            Table table = this.tablesMap.get(tableName);
            if (table == null) {
                View view = this.viewsMap.get(tableName);
                if (view == null) {
                    log.info("Could not find table or view " + tableName + " for column " + columnName);
                    continue;
                }
                columnInfo.setView(view);
                view.getColumns().add(columnInfo);
            } else {
                columnInfo.setTable(table);
                table.getColumns().add(columnInfo);
            }
            columnInfo.setName(columnName);
            columnInfo.setDataType(rs.getInt("DATA_TYPE"));
            columnInfo.setColumnSize(rs.getInt("COLUMN_SIZE"));
            columnInfo.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
            int nullable = rs.getInt("NULLABLE");
            if (nullable == 0) {
                columnInfo.setNullable(false);
            } else if (nullable == 1) {
                columnInfo.setNullable(true);
            }
            columnInfo.setPrimaryKey(this.isPrimaryKey(columnInfo));
            columnInfo.setAutoIncrement(this.database.isColumnAutoIncrement(schema, tableName, columnName));
            this.getColumnTypeAndDefValue(columnInfo, rs, this.database);
            columnInfo.setRemarks(remarks);
            this.columnsMap.put(tableName + "." + columnName, columnInfo);
        }
        rs.close();
        selectStatement.close();
    }

    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, JDBCException {
        Object defaultValue = rs.getObject("COLUMN_DEF");
        try {
            columnInfo.setDefaultValue(database.convertDatabaseValueToJavaObject(defaultValue, columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits()));
        }
        catch (ParseException e) {
            throw new JDBCException(e);
        }
        columnInfo.setTypeName(database.getColumnType(rs.getString("TYPE_NAME"), columnInfo.isAutoIncrement()));
    }

    protected boolean isPrimaryKey(Column columnInfo) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (columnInfo.getTable() == null || !pk.getTable().getName().equalsIgnoreCase(columnInfo.getTable().getName()) || !pk.getColumnNamesAsList().contains(columnInfo.getName())) continue;
            return true;
        }
        return false;
    }

    protected void readForeignKeyInformation(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading foreign keys for " + this.database.toString() + " ...");
        for (Table table : this.tablesMap.values()) {
            String dbCatalog = this.database.convertRequestedSchemaToCatalog(schema);
            String dbSchema = this.database.convertRequestedSchemaToSchema(schema);
            ResultSet rs = this.databaseMetaData.getExportedKeys(dbCatalog, dbSchema, table.getName());
            ForeignKey fkInfo = null;
            while (rs.next()) {
                String pkTableName = this.convertFromDatabaseName(rs.getString("PKTABLE_NAME"));
                String pkColumn = this.convertFromDatabaseName(rs.getString("PKCOLUMN_NAME"));
                Table pkTable = this.tablesMap.get(pkTableName);
                if (pkTable == null) {
                    throw new JDBCException("Could not find table " + pkTableName + " for column " + pkColumn);
                }
                int keySeq = rs.getInt("KEY_SEQ");
                if (keySeq == 1) {
                    fkInfo = new ForeignKey();
                }
                fkInfo.setPrimaryKeyTable(pkTable);
                fkInfo.addPrimaryKeyColumn(pkColumn);
                String fkTableName = this.convertFromDatabaseName(rs.getString("FKTABLE_NAME"));
                String fkColumn = this.convertFromDatabaseName(rs.getString("FKCOLUMN_NAME"));
                Table fkTable = this.tablesMap.get(fkTableName);
                if (fkTable == null) {
                    throw new JDBCException("Could not find table " + fkTableName + " for column " + fkColumn);
                }
                fkInfo.setForeignKeyTable(fkTable);
                fkInfo.addForeignKeyColumn(fkColumn);
                fkInfo.setName(this.convertFromDatabaseName(rs.getString("FK_NAME")));
                Integer updateRule = rs.getInt("UPDATE_RULE");
                if (rs.wasNull()) {
                    updateRule = null;
                }
                Integer deleteRule = rs.getInt("DELETE_RULE");
                if (rs.wasNull()) {
                    deleteRule = null;
                }
                fkInfo.setUpdateRule(updateRule);
                fkInfo.setDeleteRule(deleteRule);
                if (this.database.supportsInitiallyDeferrableColumns()) {
                    short deferrablility = rs.getShort("DEFERRABILITY");
                    if (deferrablility == 5) {
                        fkInfo.setDeferrable(Boolean.TRUE);
                        fkInfo.setInitiallyDeferred(Boolean.TRUE);
                    } else if (deferrablility == 6) {
                        fkInfo.setDeferrable(Boolean.TRUE);
                        fkInfo.setInitiallyDeferred(Boolean.FALSE);
                    } else if (deferrablility == 7) {
                        fkInfo.setDeferrable(Boolean.FALSE);
                        fkInfo.setInitiallyDeferred(Boolean.FALSE);
                    }
                }
                if (keySeq != 1) continue;
                this.foreignKeys.add(fkInfo);
            }
            rs.close();
        }
    }

    protected void readIndexes(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading indexes for " + this.database.toString() + " ...");
        for (Table table : this.tablesMap.values()) {
            ResultSet rs;
            Statement statement = null;
            if (this.database instanceof OracleDatabase) {
                statement = this.database.getConnection().createStatement();
                String sql = "SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + this.database.convertRequestedSchemaToSchema(schema) + "' AND TABLE_NAME='" + table.getName() + "' ORDER BY INDEX_NAME, ORDINAL_POSITION";
                rs = statement.executeQuery(sql);
            } else {
                rs = this.databaseMetaData.getIndexInfo(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), table.getName(), false, true);
            }
            HashMap<String, Index> indexMap = new HashMap<String, Index>();
            while (rs.next()) {
                Index indexInformation;
                String indexName = this.convertFromDatabaseName(rs.getString("INDEX_NAME"));
                short type = rs.getShort("TYPE");
                boolean nonUnique = true;
                try {
                    nonUnique = rs.getBoolean("NON_UNIQUE");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                short position = rs.getShort("ORDINAL_POSITION");
                String filterCondition = rs.getString("FILTER_CONDITION");
                if (type == 0 || columnName == null) continue;
                if (indexMap.containsKey(indexName)) {
                    indexInformation = (Index)indexMap.get(indexName);
                } else {
                    indexInformation = new Index();
                    indexInformation.setTable(table);
                    indexInformation.setName(indexName);
                    indexInformation.setUnique(!nonUnique);
                    indexInformation.setFilterCondition(filterCondition);
                    indexMap.put(indexName, indexInformation);
                }
                indexInformation.getColumns().add(position - 1, columnName);
            }
            for (Map.Entry entry : indexMap.entrySet()) {
                this.indexes.add((Index)entry.getValue());
            }
            rs.close();
            if (statement == null) continue;
            statement.close();
        }
        HashSet<Index> indexesToRemove = new HashSet<Index>();
        for (Index index : this.indexes) {
            for (PrimaryKey pk : this.primaryKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(pk.getTable().getName()) || !index.getColumnNames().equals(pk.getColumnNames())) continue;
                indexesToRemove.add(index);
            }
            for (ForeignKey fk : this.foreignKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(fk.getForeignKeyTable().getName()) || !index.getColumnNames().equals(fk.getForeignKeyColumns())) continue;
                indexesToRemove.add(index);
            }
            for (UniqueConstraint uc : this.uniqueConstraints) {
                if (!index.getTable().getName().equalsIgnoreCase(uc.getTable().getName()) || !index.getColumnNames().equals(uc.getColumnNames())) continue;
                indexesToRemove.add(index);
            }
        }
        this.indexes.removeAll(indexesToRemove);
    }

    protected void readPrimaryKeys(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading primary keys for " + this.database.toString() + " ...");
        ArrayList<PrimaryKey> foundPKs = new ArrayList<PrimaryKey>();
        for (Table table : this.tablesMap.values()) {
            ResultSet rs = this.databaseMetaData.getPrimaryKeys(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), table.getName());
            while (rs.next()) {
                String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
                String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                short position = rs.getShort("KEY_SEQ");
                boolean foundExistingPK = false;
                for (PrimaryKey pk : foundPKs) {
                    if (!pk.getTable().getName().equals(tableName)) continue;
                    pk.addColumnName(position - 1, columnName);
                    foundExistingPK = true;
                }
                if (foundExistingPK) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setTable(table);
                primaryKey.addColumnName(position - 1, columnName);
                primaryKey.setName(this.convertPrimaryKeyName(rs.getString("PK_NAME")));
                foundPKs.add(primaryKey);
            }
            rs.close();
        }
        this.primaryKeys.addAll(foundPKs);
    }

    protected String convertPrimaryKeyName(String pkName) throws SQLException {
        return pkName;
    }

    protected void readUniqueConstraints(String schema) throws JDBCException, SQLException {
        this.updateListeners("Reading unique constraints for " + this.database.toString() + " ...");
    }

    protected void readSequences(String schema) throws JDBCException {
        List sequenceNames;
        this.updateListeners("Reading sequences for " + this.database.toString() + " ...");
        if (this.database.supportsSequences() && (sequenceNames = this.database.getJdbcTemplate().queryForList(this.database.createFindSequencesSQL(schema), String.class, new ArrayList<SqlVisitor>())) != null) {
            for (String sequenceName : sequenceNames) {
                Sequence seq = new Sequence();
                seq.setName(sequenceName.trim());
                this.sequences.add(seq);
            }
        }
    }

    protected void updateListeners(String message) {
        if (this.statusListeners == null) {
            return;
        }
        log.finest(message);
        for (DiffStatusListener listener : this.statusListeners) {
            listener.statusUpdate(message);
        }
    }

    @Override
    public Table getTable(String tableName) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    @Override
    public ForeignKey getForeignKey(String foreignKeyName) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (!fk.getName().equalsIgnoreCase(foreignKeyName)) continue;
            return fk;
        }
        return null;
    }

    @Override
    public Sequence getSequence(String sequenceName) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(sequenceName)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public Index getIndex(String indexName) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    @Override
    public View getView(String viewName) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(viewName)) continue;
            return view;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKey(String pkName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getName().equalsIgnoreCase(pkName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKeyForTable(String tableName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getTable().getName().equalsIgnoreCase(tableName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public UniqueConstraint getUniqueConstraint(String ucName) {
        for (UniqueConstraint uc : this.getUniqueConstraints()) {
            if (!uc.getName().equalsIgnoreCase(ucName)) continue;
            return uc;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() {
        return this.hasDatabaseChangeLogTable;
    }
}

