/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.SetupException;
import liquibase.parser.visitor.ValidatingVisitor;
import liquibase.preconditions.FailedPrecondition;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationFailedException
extends MigrationFailedException {
    private static final long serialVersionUID = 1L;
    private List<ChangeSet> invalidMD5Sums;
    private List<FailedPrecondition> failedPreconditions;
    private Set<ChangeSet> duplicateChangeSets;
    private List<SetupException> setupExceptions;
    private List<InvalidChangeDefinitionException> changeValidationExceptions;

    public ValidationFailedException(ValidatingVisitor changeLogHandler) {
        this.invalidMD5Sums = changeLogHandler.getInvalidMD5Sums();
        this.failedPreconditions = changeLogHandler.getFailedPreconditions();
        this.duplicateChangeSets = changeLogHandler.getDuplicateChangeSets();
        this.setupExceptions = changeLogHandler.getSetupExceptions();
        this.changeValidationExceptions = changeLogHandler.getChangeValidationExceptions();
    }

    @Override
    public String getMessage() {
        StringBuffer message = new StringBuffer();
        message.append("Validation Failed:").append(StreamUtil.getLineSeparator());
        if (this.invalidMD5Sums.size() > 0) {
            message.append("     ").append(this.invalidMD5Sums.size()).append(" change sets check sum").append(StreamUtil.getLineSeparator());
            for (int i = 0; i < this.invalidMD5Sums.size() && i <= 25; ++i) {
                ChangeSet changeSet = this.invalidMD5Sums.get(i);
                message.append("          ").append(changeSet.toString(true));
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.failedPreconditions.size() > 0) {
            message.append("     ").append(this.failedPreconditions.size()).append(" preconditions failed").append(StreamUtil.getLineSeparator());
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                message.append("     ").append(failedPrecondition.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            message.append("     ").append(this.duplicateChangeSets.size()).append(" change sets had duplicate identifiers").append(StreamUtil.getLineSeparator());
            for (ChangeSet changeSet : this.duplicateChangeSets) {
                message.append("          ").append(changeSet.toString(false));
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.setupExceptions.size() > 0) {
            message.append("     ").append(this.setupExceptions.size()).append(" changes have failures").append(StreamUtil.getLineSeparator());
            for (SetupException setupException : this.setupExceptions) {
                message.append("          ").append(setupException.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        if (this.changeValidationExceptions.size() > 0) {
            message.append("     ").append(this.changeValidationExceptions.size()).append(" changes have validation failures").append(StreamUtil.getLineSeparator());
            for (InvalidChangeDefinitionException invalidChangeDefinitionException : this.changeValidationExceptions) {
                message.append("          ").append(invalidChangeDefinitionException.toString());
                message.append(StreamUtil.getLineSeparator());
            }
        }
        return message.toString();
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public void printDescriptiveError(PrintStream out) {
        out.println("Validation Error: ");
        if (this.invalidMD5Sums.size() > 0) {
            out.println("     " + this.invalidMD5Sums.size() + " change sets have changed since they were ran against the database");
            for (ChangeSet changeSet : this.invalidMD5Sums) {
                out.println("          " + changeSet.toString(false));
            }
        }
        if (this.failedPreconditions.size() > 0) {
            out.println("     " + this.failedPreconditions.size() + " preconditions failed");
            for (FailedPrecondition failedPrecondition : this.failedPreconditions) {
                out.println("          " + failedPrecondition.toString());
            }
        }
        if (this.duplicateChangeSets.size() > 0) {
            out.println("     " + this.duplicateChangeSets.size() + " change sets had duplicate identifiers");
            for (ChangeSet duplicate : this.duplicateChangeSets) {
                out.println("          " + duplicate.toString(false));
            }
        }
        if (this.setupExceptions.size() > 0) {
            out.println("     " + this.setupExceptions.size() + " changes had errors");
            for (SetupException setupEx : this.setupExceptions) {
                out.println("          " + setupEx.getMessage());
            }
        }
    }
}

