/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LiquibaseSchemaResolver
implements EntityResolver {
    private static final String SEARCH_PACKAGE = "liquibase/";

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        int iSlash;
        if (systemId != null && (iSlash = systemId.lastIndexOf(47)) >= 0) {
            String xsdFile = systemId.substring(iSlash + 1);
            try {
                InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(SEARCH_PACKAGE + xsdFile);
                if (resourceAsStream == null) {
                    resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(SEARCH_PACKAGE + xsdFile);
                }
                if (resourceAsStream == null) {
                    return null;
                }
                InputSource source = new InputSource(resourceAsStream);
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }
}

