/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.ArrayList;
import liquibase.preconditions.AndPrecondition;
import liquibase.util.StringUtils;

public class Preconditions
extends AndPrecondition {
    private FailOption onFail = FailOption.HALT;
    private ErrorOption onError = ErrorOption.HALT;

    public FailOption getOnFail() {
        return this.onFail;
    }

    public void setOnFail(String onFail) {
        if (onFail != null) {
            for (FailOption option : FailOption.values()) {
                if (!option.key.equalsIgnoreCase(onFail)) continue;
                this.onFail = option;
                return;
            }
            ArrayList<String> possibleOptions = new ArrayList<String>();
            for (FailOption option : FailOption.values()) {
                possibleOptions.add(option.key);
            }
            throw new RuntimeException("Unknown onFail attribute value '" + onFail + "'.  Possible values: " + StringUtils.join(possibleOptions, ", "));
        }
        this.onFail = FailOption.HALT;
    }

    public ErrorOption getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        if (onError != null) {
            for (ErrorOption option : ErrorOption.values()) {
                if (!option.key.equalsIgnoreCase(onError)) continue;
                this.onError = option;
                return;
            }
            ArrayList<String> possibleOptions = new ArrayList<String>();
            for (ErrorOption option : ErrorOption.values()) {
                possibleOptions.add(option.key);
            }
            throw new RuntimeException("Unknown onError attribute value '" + onError + "'.  Possible values: " + StringUtils.join(possibleOptions, ", "));
        }
        this.onError = ErrorOption.HALT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorOption {
        HALT("HALT"),
        CONTINUE("CONTINUE"),
        MARK_RAN("MARK_RAN"),
        WARN("WARN");

        String key;

        private ErrorOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailOption {
        HALT("HALT"),
        CONTINUE("CONTINUE"),
        MARK_RAN("MARK_RAN"),
        WARN("WARN");

        String key;

        private FailOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

