/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.change.Change;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFactory {
    private static ChangeFactory instance;
    private Map<String, SortedSet<Class<? extends Change>>> registry = new ConcurrentHashMap<String, SortedSet<Class<? extends Change>>>();

    private ChangeFactory() {
        try {
            Class[] classes;
            for (Class clazz : classes = ServiceLocator.getInstance().findClasses(Change.class)) {
                this.register(clazz);
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static ChangeFactory getInstance() {
        if (instance == null) {
            instance = new ChangeFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new ChangeFactory();
    }

    public void register(Class<? extends Change> changeClass) {
        try {
            String name = changeClass.newInstance().getChangeMetaData().getName();
            if (this.registry.get(name) == null) {
                this.registry.put(name, new TreeSet<Class<? extends Change>>(new Comparator<Class<? extends Change>>(){

                    @Override
                    public int compare(Class<? extends Change> o1, Class<? extends Change> o2) {
                        try {
                            return -1 * new Integer(o1.newInstance().getChangeMetaData().getPriority()).compareTo(o2.newInstance().getChangeMetaData().getPriority());
                        }
                        catch (Exception e) {
                            throw new UnexpectedLiquibaseException(e);
                        }
                    }
                }));
            }
            this.registry.get(name).add(changeClass);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public void unregister(String name) {
        this.registry.remove(name);
    }

    public Map<String, SortedSet<Class<? extends Change>>> getRegistry() {
        return this.registry;
    }

    public Change create(String name) {
        SortedSet<Class<? extends Change>> classes = this.registry.get(name);
        if (classes == null) {
            return null;
        }
        try {
            return (Change)((Class)classes.iterator().next()).newInstance();
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

