/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.CharType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DateType;
import liquibase.database.structure.type.NVarcharType;
import liquibase.database.structure.type.NumberType;
import liquibase.database.structure.type.TimeType;
import liquibase.database.structure.type.UUIDType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;

public class MSSQLTypeConverter
extends AbstractTypeConverter {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue instanceof String) {
            if (((String)defaultValue).startsWith("('")) {
                defaultValue = ((String)defaultValue).replaceFirst("^\\('", "").replaceFirst("'\\)$", "");
            } else if (((String)defaultValue).startsWith("((")) {
                defaultValue = ((String)defaultValue).replaceFirst("^\\(\\(", "").replaceFirst("\\)\\)$", "");
            }
        }
        defaultValue = super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
        return defaultValue;
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        if (columnTypeString.endsWith(" identity")) {
            columnTypeString = columnTypeString.replaceFirst(" identity$", "");
            autoIncrement = true;
        }
        if (columnTypeString.equalsIgnoreCase("varbinary(2147483647)")) {
            columnTypeString = "varbinary(max)";
        }
        return super.getDataType(columnTypeString, autoIncrement);
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision) {
        DataType returnTypeName;
        if (columnTypeString.endsWith(" identity")) {
            columnTypeString = columnTypeString.replaceFirst(" identity$", "");
            autoIncrement = true;
        }
        if (columnTypeString.equalsIgnoreCase("varbinary") && (precision == null || Long.valueOf(precision) > 8000L)) {
            precision = "max";
        }
        if ((returnTypeName = super.getDataType(columnTypeString, autoIncrement, dataTypeName, precision)) instanceof CustomType) {
            boolean returnTypeChanged = false;
            if (columnTypeString.toUpperCase().startsWith("NVARCHAR")) {
                returnTypeName = new NVarcharType();
                returnTypeChanged = true;
            } else if (columnTypeString.toUpperCase().startsWith("NCHAR")) {
                returnTypeName = new CharType("NCHAR");
                returnTypeChanged = true;
            }
            if (returnTypeChanged) {
                this.addPrecisionToType(precision, returnTypeName);
            }
        }
        return returnTypeName;
    }

    public DateType getDateType() {
        return new DateType("SMALLDATETIME");
    }

    public TimeType getTimeType() {
        return new TimeType("DATETIME");
    }

    public BooleanType getBooleanType() {
        return new BooleanType.NumericBooleanType("BIT");
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType("MONEY");
    }

    public UUIDType getUUIDType() {
        return new UUIDType("UNIQUEIDENTIFIER");
    }

    public ClobType getClobType() {
        return new ClobType("NVARCHAR(MAX)");
    }

    public BlobType getBlobType() {
        return new BlobType("VARBINARY(MAX)");
    }

    public NumberType getNumberType() {
        return new NumberType("NUMERIC");
    }
}

