/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKeyInfo;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.jvm.JdbcDatabaseSnapshotGenerator;

public class MySQLDatabaseSnapshotGenerator
extends JdbcDatabaseSnapshotGenerator {
    private static Map<String, Map<String, List<String>>> schemaCache = new HashMap<String, Map<String, List<String>>>();

    public int getPriority(Database database) {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, DatabaseException {
        String columnTypeName = rs.getString("TYPE_NAME");
        String columnName = rs.getString("COLUMN_NAME");
        String tableName = rs.getString("TABLE_NAME");
        String schemaName = rs.getString("TABLE_CAT");
        Map<Object, Object> tableSchema = new HashMap();
        if (!schemaCache.containsKey(tableName)) {
            Statement selectStatement = ((JdbcConnection)database.getConnection()).getUnderlyingConnection().createStatement();
            ResultSet rsColumnType = selectStatement.executeQuery("DESC " + database.escapeTableName(schemaName, tableName));
            while (rsColumnType.next()) {
                ArrayList<String> colSchema = new ArrayList<String>();
                colSchema.add(rsColumnType.getString("Type"));
                colSchema.add(rsColumnType.getString("Default"));
                tableSchema.put(rsColumnType.getString("Field"), colSchema);
            }
            rsColumnType.close();
            schemaCache.put(tableName, tableSchema);
        }
        tableSchema = schemaCache.get(tableName);
        if (columnTypeName.toLowerCase().startsWith("enum") || columnTypeName.toLowerCase().startsWith("set")) {
            columnInfo.setTypeName((String)((List)tableSchema.get(columnName)).get(0));
            try {
                String tmpDefaultValue = (String)TypeConverterFactory.getInstance().findTypeConverter(database).convertDatabaseValueToObject(((List)tableSchema.get(columnName)).get(1), columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits(), database);
                if ("".equals(tmpDefaultValue)) {
                    columnInfo.setDefaultValue(null);
                }
                columnInfo.setDefaultValue(tmpDefaultValue);
            }
            catch (ParseException e) {
                throw new DatabaseException(e);
            }
        } else if (columnTypeName.toLowerCase().equals("text") || columnTypeName.toLowerCase().equals("blob")) {
            columnInfo.setTypeName(columnTypeName);
            columnInfo.setDefaultValue(null);
        } else if (columnTypeName.toLowerCase().equals("timestamp") && !"CURRENT_TIMESTAMP".equals(((List)tableSchema.get(columnName)).get(1))) {
            columnInfo.setTypeName(columnTypeName);
            columnInfo.setDefaultValue(((List)tableSchema.get(columnName)).get(1));
        } else {
            super.getColumnTypeAndDefValue(columnInfo, rs, database);
        }
    }

    protected String convertPrimaryKeyName(String pkName) throws SQLException {
        if (pkName.equals("PRIMARY")) {
            return null;
        }
        return pkName;
    }

    protected ForeignKeyInfo fillForeignKeyInfo(ResultSet rs) throws DatabaseException, SQLException {
        ForeignKeyInfo fkinfo = super.fillForeignKeyInfo(rs);
        fkinfo.setPkTableSchema(this.convertFromDatabaseName(rs.getString("PKTABLE_CAT")));
        fkinfo.setFkSchema(this.convertFromDatabaseName(rs.getString("FKTABLE_CAT")));
        return fkinfo;
    }
}

