package liquibase.database.core;

import java.sql.Connection;

import liquibase.database.DatabaseConnection;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.FloatType;
import liquibase.exception.DatabaseException;

public class DB2iDatabase extends DB2Database {

    @Override
    public int getPriority() {
        return super.getPriority()+5;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getDatabaseProductName().startsWith("DB2 UDB for AS/400");
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:as400")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        return null;
    }

    @Override
    public String getTypeName() {
        return "db2i";
    }
}
