/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectFromDatabaseChangeLogLockGenerator
extends AbstractSqlGenerator<SelectFromDatabaseChangeLogLockStatement> {
    @Override
    public ValidationErrors validate(SelectFromDatabaseChangeLogLockStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors errors = new ValidationErrors();
        errors.checkRequiredField("columnToSelect", statement.getColumnsToSelect());
        return errors;
    }

    @Override
    public Sql[] generateSql(SelectFromDatabaseChangeLogLockStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String liquibaseSchema = database.getLiquibaseSchemaName();
        String[] columns = statement.getColumnsToSelect();
        int numberOfColumns = columns.length;
        String[] escapedColumns = new String[numberOfColumns];
        for (int i = 0; i < numberOfColumns; ++i) {
            escapedColumns[i] = database.escapeColumnName(liquibaseSchema, database.getDatabaseChangeLogLockTableName(), columns[i]);
        }
        String sql = "SELECT " + StringUtils.join(escapedColumns, ",") + " FROM " + database.escapeTableName(liquibaseSchema, database.getDatabaseChangeLogLockTableName()) + " WHERE " + database.escapeColumnName(liquibaseSchema, database.getDatabaseChangeLogLockTableName(), "ID") + "=1";
        if (database instanceof OracleDatabase) {
            sql = sql + " FOR UPDATE";
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

