/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.SelectSequencesStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSequencesGeneratorInformix
extends AbstractSqlGenerator<SelectSequencesStatement> {
    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public boolean supports(SelectSequencesStatement statement, Database database) {
        return database instanceof InformixDatabase;
    }

    @Override
    public ValidationErrors validate(SelectSequencesStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    @Override
    public Sql[] generateSql(SelectSequencesStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sb = new StringBuilder("SELECT tabname FROM systables t, syssequences s WHERE s.tabid = t.tabid");
        String schemaName = statement.getSchemaName();
        if (schemaName != null) {
            sb.append(" AND t.owner = ").append("'").append(schemaName).append("'");
        }
        return new Sql[]{new UnparsedSql(sb.toString(), new DatabaseObject[0])};
    }
}

