/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.math.BigInteger;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeNote;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddAutoIncrementStatement;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.statement.core.CreateSequenceStatement;
import liquibase.statement.core.SetNullableStatement;

@DatabaseChange(name="addAutoIncrement", description="Converts an existing column to be an auto-increment (a.k.a 'identity') column", priority=1, appliesTo={"column"}, databaseNotes={@DatabaseChangeNote(database="sqlite", notes="If the column type is not INTEGER it is converted to INTEGER")})
public class AddAutoIncrementChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnDataType;
    private BigInteger startWith;
    private BigInteger incrementBy;

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @DatabaseChangeProperty(description="Current data type of the column to make auto-increment", exampleValue="int")
    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    @DatabaseChangeProperty(exampleValue="100")
    public BigInteger getStartWith() {
        return this.startWith;
    }

    public void setStartWith(BigInteger startWith) {
        this.startWith = startWith;
    }

    @DatabaseChangeProperty(exampleValue="1")
    public BigInteger getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(BigInteger incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        if (database instanceof PostgresDatabase) {
            String sequenceName = (this.getTableName() + "_" + this.getColumnName() + "_seq").toLowerCase();
            return new SqlStatement[]{new CreateSequenceStatement(this.catalogName, this.schemaName, sequenceName), new SetNullableStatement(this.catalogName, this.schemaName, this.getTableName(), this.getColumnName(), null, false), new AddDefaultValueStatement(this.catalogName, this.schemaName, this.getTableName(), this.getColumnName(), this.getColumnDataType(), new SequenceNextValueFunction(sequenceName))};
        }
        return new SqlStatement[]{new AddAutoIncrementStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName(), this.getColumnDataType(), this.getStartWith(), this.getIncrementBy())};
    }

    @Override
    public String getConfirmationMessage() {
        return "Auto-increment added to " + this.getTableName() + "." + this.getColumnName();
    }
}

