/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import liquibase.change.AbstractSQLChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.logging.LogFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

@DatabaseChange(name="sqlFile", description="The 'sqlFile' tag allows you to specify any sql statements and have it stored external in a file. It is useful for complex changes that are not supported through LiquiBase's automated refactoring tags such as stored procedures.\n\nThe sqlFile refactoring finds the file by searching in the following order:\n\nThe file is searched for in the classpath. This can be manually set and by default the liquibase startup script adds the current directory when run.\nThe file is searched for using the file attribute as a file name. This allows absolute paths to be used or relative paths to the working directory to be used.\nThe 'sqlFile' tag can also support multiline statements in the same file. Statements can either be split using a ; at the end of the last line of the SQL or a go on its own on the line between the statements can be used.Multiline SQL statements are also supported and only a ; or go statement will finish a statement, a new line is not enough. Files containing a single statement do not need to use a ; or go.\n\nThe sql file can also contain comments of either of the following formats:\n\nA multiline comment that starts with /* and ends with */.\nA single line comment starting with <space>--<space> and finishing at the end of the line", priority=1)
public class SQLFileChange
extends AbstractSQLChange {
    private String path;
    private String encoding = null;
    private Boolean relativeToChangelogFile;

    @DatabaseChangeProperty(description="The file path of the SQL file to load", requiredForDatabase={"all"}, exampleValue="my/path/file.sql")
    public String getPath() {
        return this.path;
    }

    public void setPath(String fileName) {
        this.path = fileName;
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @Override
    public void finishInitialization() throws SetupException {
        if (this.path == null) {
            throw new SetupException("<sqlfile> - No path specified");
        }
        LogFactory.getLogger().debug("SQLFile file:" + this.path);
        boolean loaded = this.loadFromClasspath(this.path);
        if (!loaded) {
            loaded = this.loadFromFileSystem(this.path);
        }
        if (!loaded) {
            throw new SetupException("<sqlfile path=" + this.path + "> - Could not find file");
        }
        LogFactory.getLogger().debug("SQLFile file contents is:" + this.getSql());
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtils.trimToNull(this.getPath()) == null) {
            validationErrors.addError("'path' is required");
        }
        return validationErrors;
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    private boolean loadFromFileSystem(String file) throws SetupException {
        if (this.relativeToChangelogFile != null && this.relativeToChangelogFile.booleanValue()) {
            String base = this.getChangeSet().getChangeLog() == null ? this.getChangeSet().getFilePath() : this.getChangeSet().getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (!base.contains("/")) {
                base = ".";
            }
            file = base.replaceFirst("/[^/]*$", "") + "/" + file;
        }
        InputStream fis = null;
        try {
            fis = this.getResourceAccessor().getResourceAsStream(file);
            if (fis == null) {
                throw new SetupException("<sqlfile path=" + file + "> -Unable to read file");
            }
            this.setSql(StreamUtil.getStreamContents(fis, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new SetupException("<sqlfile path=" + file + "> -Unable to read file", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromClasspath(String file) {
        if (this.relativeToChangelogFile != null && this.relativeToChangelogFile.booleanValue()) {
            String base = this.getChangeSet().getChangeLog() == null ? this.getChangeSet().getFilePath() : this.getChangeSet().getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (!base.contains("/")) {
                base = ".";
            }
            file = base.replaceFirst("/[^/]*$", "") + "/" + file;
        }
        InputStream in = null;
        try {
            ResourceAccessor fo = this.getResourceAccessor();
            if (fo == null) {
                boolean bl = false;
                return bl;
            }
            in = fo.getResourceAsStream(file);
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            this.setSql(StreamUtil.getStreamContents(in, this.encoding));
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public String getConfirmationMessage() {
        return "SQL in file " + this.path + " executed";
    }

    @Override
    public void setSql(String sql) {
        if (this.getChangeSet() != null && this.getChangeSet().getChangeLogParameters() != null) {
            sql = this.getChangeSet().getChangeLogParameters().expandExpressions(sql);
        }
        super.setSql(sql);
    }
}

