/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.DateParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SequenceCurrentValueFunction;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.CreateDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.GetNextChangeSetSequenceValueStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.statement.core.InitializeDatabaseChangeLogLockTableStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.RemoveChangeSetRanStatusStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import liquibase.util.ISODateFormat;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public abstract class AbstractJdbcDatabase
implements Database {
    private DatabaseConnection connection;
    protected String defaultCatalogName;
    protected String defaultSchemaName;
    protected String currentDateTimeFunction;
    protected String sequenceNextValueFunction;
    protected String sequenceCurrentValueFunction;
    protected String quotingStartCharacter = "\"";
    protected String quotingEndCharacter = "\"";
    protected List<DatabaseFunction> dateFunctions = new ArrayList<DatabaseFunction>();
    protected List<String> unmodifiableDataTypes = new ArrayList<String>();
    private List<RanChangeSet> ranChangeSetList;
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);
    private String databaseChangeLogTableName = System.getProperty("liquibase.databaseChangeLogTableName") == null ? "DatabaseChangeLog".toUpperCase() : System.getProperty("liquibase.databaseChangeLogTableName");
    private String databaseChangeLogLockTableName = System.getProperty("liquibase.databaseChangeLogLockTableName") == null ? "DatabaseChangeLogLock".toUpperCase() : System.getProperty("liquibase.databaseChangeLogLockTableName");
    private String liquibaseTablespaceName = System.getProperty("liquibase.tablespaceName");
    private String liquibaseSchemaName = System.getProperty("liquibase.schemaName");
    private String liquibaseCatalogName = System.getProperty("liquibase.catalogName");
    private Integer lastChangeSetSequenceValue;
    private Boolean previousAutoCommit;
    private boolean canCacheLiquibaseTableInfo = false;
    private boolean hasDatabaseChangeLogTable = false;
    private boolean hasDatabaseChangeLogLockTable = false;
    private boolean isDatabaseChangeLogLockTableInitialized = false;
    protected BigInteger defaultAutoIncrementStartWith = BigInteger.ONE;
    protected BigInteger defaultAutoIncrementBy = BigInteger.ONE;
    protected Boolean unquotedObjectsAreUppercased = null;
    protected ObjectQuotingStrategy quotingStrategy = ObjectQuotingStrategy.LEGACY;
    private Boolean caseSensitive;
    private boolean outputDefaultSchema = true;
    private boolean outputDefaultCatalog = true;

    protected void resetRanChangeSetList() {
        this.ranChangeSetList = null;
    }

    public String getName() {
        return this.toString();
    }

    @Override
    public boolean requiresPassword() {
        return true;
    }

    @Override
    public boolean requiresUsername() {
        return true;
    }

    public DatabaseObject[] getContainingObjects() {
        return null;
    }

    @Override
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(DatabaseConnection conn) {
        LogFactory.getLogger().debug("Connected to " + conn.getConnectionUserName() + "@" + conn.getURL());
        this.connection = conn;
        try {
            boolean autoCommit = conn.getAutoCommit();
            if (autoCommit == this.getAutoCommitMode()) {
                LogFactory.getLogger().debug("Not adjusting the auto commit mode; it is already " + autoCommit);
            } else {
                this.previousAutoCommit = autoCommit;
                LogFactory.getLogger().debug("Setting auto commit to " + this.getAutoCommitMode() + " from " + autoCommit);
                this.connection.setAutoCommit(this.getAutoCommitMode());
            }
        }
        catch (DatabaseException e) {
            LogFactory.getLogger().warning("Cannot set auto commit to " + this.getAutoCommitMode() + " on connection");
        }
    }

    @Override
    public boolean getAutoCommitMode() {
        return !this.supportsDDLInTransaction();
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        if (this.connection == null) {
            return this.getDefaultDatabaseProductName();
        }
        try {
            return this.connection.getDatabaseProductName();
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Cannot get database name");
        }
    }

    protected abstract String getDefaultDatabaseProductName();

    @Override
    public String getDatabaseProductVersion() throws DatabaseException {
        if (this.connection == null) {
            return null;
        }
        try {
            return this.connection.getDatabaseProductVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        if (this.connection == null) {
            return -1;
        }
        try {
            return this.connection.getDatabaseMajorVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        if (this.connection == null) {
            return -1;
        }
        try {
            return this.connection.getDatabaseMinorVersion();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public String getDefaultCatalogName() {
        if (this.defaultCatalogName == null) {
            if (this.defaultSchemaName != null && !this.supportsSchemas()) {
                return this.defaultSchemaName;
            }
            if (this.connection != null) {
                try {
                    this.defaultCatalogName = this.getConnectionCatalogName();
                }
                catch (DatabaseException e) {
                    LogFactory.getLogger().info("Error getting default catalog", e);
                }
            }
        }
        return this.defaultCatalogName;
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        return this.connection.getCatalog();
    }

    public CatalogAndSchema correctSchema(String catalog, String schema) {
        return this.correctSchema(new CatalogAndSchema(catalog, schema));
    }

    @Override
    public CatalogAndSchema correctSchema(CatalogAndSchema schema) {
        if (schema == null) {
            return new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName());
        }
        String catalogName = StringUtils.trimToNull(schema.getCatalogName());
        String schemaName = StringUtils.trimToNull(schema.getSchemaName());
        if (this.supportsCatalogs() && this.supportsSchemas()) {
            catalogName = catalogName == null ? this.getDefaultCatalogName() : this.correctObjectName(catalogName, Catalog.class);
            schemaName = schemaName == null ? this.getDefaultSchemaName() : this.correctObjectName(schemaName, Schema.class);
        } else {
            if (!this.supportsCatalogs() && !this.supportsSchemas()) {
                return new CatalogAndSchema(null, null);
            }
            if (this.supportsCatalogs()) {
                if (catalogName == null) {
                    catalogName = schemaName == null ? this.getDefaultCatalogName() : schemaName;
                }
                schemaName = catalogName;
            } else if (this.supportsSchemas()) {
                if (schemaName == null) {
                    schemaName = catalogName == null ? this.getDefaultSchemaName() : catalogName;
                }
                catalogName = schemaName;
            }
        }
        return new CatalogAndSchema(catalogName, schemaName);
    }

    @Override
    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (this.quotingStrategy == ObjectQuotingStrategy.QUOTE_ALL_OBJECTS || this.unquotedObjectsAreUppercased == null || objectName == null || objectName.startsWith(this.quotingStartCharacter) && objectName.endsWith(this.quotingEndCharacter)) {
            return objectName;
        }
        if (this.unquotedObjectsAreUppercased == Boolean.TRUE) {
            return objectName.toUpperCase();
        }
        return objectName.toLowerCase();
    }

    @Override
    public CatalogAndSchema getDefaultSchema() {
        return new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName());
    }

    @Override
    public String getDefaultSchemaName() {
        if (!this.supportsSchemas()) {
            return this.getDefaultCatalogName();
        }
        if (this.defaultSchemaName == null && this.connection != null) {
            this.defaultSchemaName = this.getConnectionSchemaName();
        }
        return this.defaultSchemaName;
    }

    protected String getConnectionSchemaName() {
        if (this.connection == null) {
            return null;
        }
        try {
            ResultSet resultSet = ((JdbcConnection)this.connection).prepareCall("call current_schema").executeQuery();
            resultSet.next();
            return resultSet.getString(1);
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Error getting default schema", e);
            return null;
        }
    }

    @Override
    public void setDefaultCatalogName(String defaultCatalogName) {
        this.defaultCatalogName = this.correctObjectName(defaultCatalogName, Catalog.class);
    }

    @Override
    public void setDefaultSchemaName(String schemaName) {
        this.defaultSchemaName = this.correctObjectName(schemaName, Schema.class);
    }

    protected Set<String> getSystemTables() {
        return new HashSet<String>();
    }

    protected Set<String> getSystemViews() {
        return new HashSet<String>();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public void setCurrentDateTimeFunction(String function) {
        if (function != null) {
            this.currentDateTimeFunction = function;
            this.dateFunctions.add(new DatabaseFunction(function));
        }
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate) || this.isTimeOnly(isoDate)) {
            return "'" + isoDate + "'";
        }
        if (this.isDateTime(isoDate)) {
            return "'" + isoDate.replace('T', ' ') + "'";
        }
        return "BAD_DATE_FORMAT:" + isoDate;
    }

    @Override
    public String getDateTimeLiteral(Timestamp date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(java.sql.Date date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getTimeLiteral(Time date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Date date) {
        if (date instanceof java.sql.Date) {
            return this.getDateLiteral((java.sql.Date)date);
        }
        if (date instanceof Time) {
            return this.getTimeLiteral((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.getDateTimeLiteral((Timestamp)date);
        }
        throw new RuntimeException("Unexpected type: " + date.getClass().getName());
    }

    @Override
    public Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf("T") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    protected boolean isDateOnly(String isoDate) {
        return isoDate.length() == "yyyy-MM-dd".length();
    }

    protected boolean isDateTime(String isoDate) {
        return isoDate.length() >= "yyyy-MM-ddThh:mm:ss".length();
    }

    protected boolean isTimeOnly(String isoDate) {
        return isoDate.length() == "hh:mm:ss".length();
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getAutoIncrementClause(BigInteger startWith, BigInteger incrementBy) {
        if (!this.supportsAutoIncrement()) {
            return "";
        }
        String autoIncrementClause = this.getAutoIncrementClause();
        boolean generateStartWith = this.generateAutoIncrementStartWith(startWith);
        boolean generateIncrementBy = this.generateAutoIncrementBy(incrementBy);
        if (generateStartWith || generateIncrementBy) {
            autoIncrementClause = autoIncrementClause + this.getAutoIncrementOpening();
            if (generateStartWith) {
                autoIncrementClause = autoIncrementClause + String.format(this.getAutoIncrementStartWithClause(), startWith == null ? this.defaultAutoIncrementStartWith : startWith);
            }
            if (generateIncrementBy) {
                if (generateStartWith) {
                    autoIncrementClause = autoIncrementClause + ", ";
                }
                autoIncrementClause = autoIncrementClause + String.format(this.getAutoIncrementByClause(), incrementBy == null ? this.defaultAutoIncrementBy : incrementBy);
            }
            autoIncrementClause = autoIncrementClause + this.getAutoIncrementClosing();
        }
        return autoIncrementClause;
    }

    protected String getAutoIncrementClause() {
        return "GENERATED BY DEFAULT AS IDENTITY";
    }

    protected boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return startWith != null && !startWith.equals(this.defaultAutoIncrementStartWith);
    }

    protected boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return incrementBy != null && !incrementBy.equals(this.defaultAutoIncrementBy);
    }

    protected String getAutoIncrementOpening() {
        return " (";
    }

    protected String getAutoIncrementClosing() {
        return ")";
    }

    protected String getAutoIncrementStartWithClause() {
        return "START WITH %d";
    }

    protected String getAutoIncrementByClause() {
        return "INCREMENT BY %d";
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" || ");
        }
        return returnString.toString().replaceFirst(" \\|\\| $", "");
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    @Override
    public String getLiquibaseTablespaceName() {
        return this.liquibaseTablespaceName;
    }

    @Override
    public void setDatabaseChangeLogTableName(String tableName) {
        this.databaseChangeLogTableName = tableName;
    }

    @Override
    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.databaseChangeLogLockTableName = tableName;
    }

    @Override
    public void setLiquibaseTablespaceName(String tablespace) {
        this.liquibaseTablespaceName = tablespace;
    }

    @Override
    public void checkDatabaseChangeLogTable(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, String ... contexts) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        Table changeLogTable = null;
        try {
            changeLogTable = SnapshotGeneratorFactory.getInstance().getDatabaseChangeLogTable(new SnapshotControl((Database)this, Table.class, Column.class), this);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        ArrayList<AbstractSqlStatement> statementsToExecute = new ArrayList<AbstractSqlStatement>();
        boolean changeLogCreateAttempted = false;
        if (changeLogTable != null) {
            String md5sum;
            List<Map> md5sumRS;
            boolean hasExecTypeColumn;
            boolean hasDescription = changeLogTable.getColumn("DESCRIPTION") != null;
            boolean bl = changeLogTable.getColumn("COMMENTS") != null;
            boolean hasTag = changeLogTable.getColumn("TAG") != null;
            boolean hasLiquibase = changeLogTable.getColumn("LIQUIBASE") != null;
            boolean liquibaseColumnNotRightSize = false;
            if (!this.connection.getDatabaseProductName().equals("SQLite")) {
                Integer columnSize = changeLogTable.getColumn("LIQUIBASE").getType().getColumnSize();
                liquibaseColumnNotRightSize = columnSize != null && columnSize != 20;
            }
            boolean hasOrderExecuted = changeLogTable.getColumn("ORDEREXECUTED") != null;
            boolean checksumNotRightSize = false;
            if (!this.connection.getDatabaseProductName().equals("SQLite")) {
                Integer columnSize = changeLogTable.getColumn("MD5SUM").getType().getColumnSize();
                checksumNotRightSize = columnSize != null && columnSize != 35;
            }
            boolean bl2 = hasExecTypeColumn = changeLogTable.getColumn("EXECTYPE") != null;
            if (!hasDescription) {
                executor.comment("Adding missing databasechangelog.description column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasTag) {
                executor.comment("Adding missing databasechangelog.tag column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!bl) {
                executor.comment("Adding missing databasechangelog.comments column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasLiquibase) {
                executor.comment("Adding missing databasechangelog.liquibase column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasOrderExecuted) {
                executor.comment("Adding missing databasechangelog.orderexecuted column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("ORDEREXECUTED", -1));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", false));
            }
            if (checksumNotRightSize) {
                executor.comment("Modifying size of databasechangelog.md5sum column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "MD5SUM", "VARCHAR(35)"));
            }
            if (liquibaseColumnNotRightSize) {
                executor.comment("Modifying size of databasechangelog.liquibase column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(20)"));
            }
            if (!hasExecTypeColumn) {
                executor.comment("Adding missing databasechangelog.exectype column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("EXECTYPE", "EXECUTED"));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", false));
            }
            if ((md5sumRS = ExecutorService.getInstance().getExecutor(this).queryForList(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByNotNullCheckSum(), "MD5SUM"))).size() > 0 && !(md5sum = md5sumRS.get(0).get("MD5SUM").toString()).startsWith(CheckSum.getCurrentVersion() + ":")) {
                executor.comment("DatabaseChangeLog checksums are an incompatible version.  Setting them to null so they will be updated on next database update");
                statementsToExecute.add(new RawSqlStatement("UPDATE " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM=null"));
            }
        } else if (!changeLogCreateAttempted) {
            executor.comment("Create Database Change Log Table");
            CreateDatabaseChangeLogTableStatement createTableStatement = new CreateDatabaseChangeLogTableStatement();
            if (!this.canCreateChangeLogTable()) {
                throw new DatabaseException("Cannot create " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " table for your database.\n\n" + "Please construct it manually using the following SQL as a base and re-run Liquibase:\n\n" + createTableStatement);
            }
            statementsToExecute.add(createTableStatement);
            LogFactory.getLogger().info("Creating database history table with name: " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()));
        }
        for (SqlStatement sqlStatement : statementsToExecute) {
            if (SqlGeneratorFactory.getInstance().supports(sqlStatement, this)) {
                executor.execute(sqlStatement);
                this.commit();
                continue;
            }
            LogFactory.getLogger().info("Cannot run " + sqlStatement.getClass().getSimpleName() + " on " + this.getShortName() + " when checking databasechangelog table");
        }
        if (updateExistingNullChecksums) {
            for (RanChangeSet ranChangeSet : this.getRanChangeSetList()) {
                ChangeSet changeSet;
                if (ranChangeSet.getLastCheckSum() != null || (changeSet = databaseChangeLog.getChangeSet(ranChangeSet)) == null || !new ContextChangeSetFilter(contexts).accepts(changeSet) || !new DbmsChangeSetFilter(this).accepts(changeSet)) continue;
                LogFactory.getLogger().debug("Updating null or out of date checksum on changeSet " + changeSet + " to correct value");
                executor.execute(new UpdateChangeSetChecksumStatement(changeSet));
            }
            this.commit();
            this.ranChangeSetList = null;
        }
    }

    protected boolean canCreateChangeLogTable() throws DatabaseException {
        return true;
    }

    @Override
    public void setCanCacheLiquibaseTableInfo(boolean canCacheLiquibaseTableInfo) {
        this.canCacheLiquibaseTableInfo = canCacheLiquibaseTableInfo;
        this.hasDatabaseChangeLogTable = false;
        this.hasDatabaseChangeLogLockTable = false;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() throws DatabaseException {
        if (this.hasDatabaseChangeLogTable) {
            return true;
        }
        boolean hasTable = false;
        try {
            hasTable = SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(this);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        if (this.canCacheLiquibaseTableInfo) {
            this.hasDatabaseChangeLogTable = hasTable;
        }
        return hasTable;
    }

    @Override
    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
        if (this.canCacheLiquibaseTableInfo && this.hasDatabaseChangeLogLockTable) {
            return true;
        }
        boolean hasTable = false;
        try {
            hasTable = SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogLockTable(this);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        if (this.canCacheLiquibaseTableInfo) {
            this.hasDatabaseChangeLogLockTable = hasTable;
        }
        return hasTable;
    }

    public boolean isDatabaseChangeLogLockTableInitialized(boolean tableJustCreated) throws DatabaseException {
        boolean initialized;
        if (this.canCacheLiquibaseTableInfo && this.isDatabaseChangeLogLockTableInitialized) {
            return true;
        }
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        try {
            initialized = executor.queryForInt(new RawSqlStatement("select count(*) from " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogLockTableName()))) > 0;
        }
        catch (LiquibaseException e) {
            if (executor.updatesDatabase()) {
                throw new UnexpectedLiquibaseException(e);
            }
            boolean bl = initialized = !tableJustCreated;
        }
        if (this.canCacheLiquibaseTableInfo) {
            this.isDatabaseChangeLogLockTableInitialized = initialized;
        }
        return initialized;
    }

    @Override
    public String getLiquibaseCatalogName() {
        return this.liquibaseCatalogName == null ? this.getDefaultCatalogName() : this.liquibaseCatalogName;
    }

    @Override
    public void setLiquibaseCatalogName(String catalogName) {
        this.liquibaseCatalogName = catalogName;
    }

    @Override
    public String getLiquibaseSchemaName() {
        return this.liquibaseSchemaName == null ? this.getDefaultSchemaName() : this.liquibaseSchemaName;
    }

    @Override
    public void setLiquibaseSchemaName(String schemaName) {
        this.liquibaseSchemaName = schemaName;
    }

    @Override
    public void checkDatabaseChangeLogLockTable() throws DatabaseException {
        boolean createdTable = false;
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        if (!this.hasDatabaseChangeLogLockTable()) {
            executor.comment("Create Database Lock Table");
            executor.execute(new CreateDatabaseChangeLogLockTableStatement());
            this.commit();
            LogFactory.getLogger().debug("Created database lock table with name: " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogLockTableName()));
            this.hasDatabaseChangeLogLockTable = true;
            createdTable = true;
        }
        if (!this.isDatabaseChangeLogLockTableInitialized(createdTable)) {
            executor.comment("Initialize Database Lock Table");
            executor.execute(new InitializeDatabaseChangeLogLockTableStatement());
            this.commit();
        }
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.caseSensitive == null && this.connection != null) {
            try {
                this.caseSensitive = ((JdbcConnection)this.connection).getUnderlyingConnection().getMetaData().supportsMixedCaseIdentifiers();
            }
            catch (SQLException e) {
                LogFactory.getLogger().warning("Cannot determine case sensitivity from JDBC driver", e);
            }
        }
        if (this.caseSensitive == null) {
            return false;
        }
        return this.caseSensitive;
    }

    @Override
    public boolean isReservedWord(String string) {
        return false;
    }

    protected boolean startsWithNumeric(String objectName) {
        return objectName.matches("^[0-9].*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabaseObjects(CatalogAndSchema schemaToDrop) throws LiquibaseException {
        ObjectQuotingStrategy currentStrategy = this.getObjectQuotingStrategy();
        this.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
        try {
            DatabaseSnapshot snapshot = null;
            try {
                snapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemaToDrop, (Database)this, new SnapshotControl(this));
            }
            catch (LiquibaseException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(new EmptyDatabaseSnapshot(this), snapshot, new CompareControl(snapshot.getSnapshotControl().getTypesToInclude()));
            List<ChangeSet> changeSets = new DiffToChangeLog(diffResult, new DiffOutputControl(true, true, false)).generateChangeSets();
            boolean reEnableFK = this.supportsForeignKeyDisable() && this.disableForeignKeyChecks();
            try {
                for (ChangeSet changeSet : changeSets) {
                    for (Change change : changeSet.getChanges()) {
                        SqlStatement[] sqlStatements;
                        for (SqlStatement statement : sqlStatements = change.generateStatements(this)) {
                            ExecutorService.getInstance().getExecutor(this).execute(statement);
                        }
                    }
                }
            }
            finally {
                if (reEnableFK) {
                    this.enableForeignKeyChecks();
                }
            }
            if (SnapshotGeneratorFactory.getInstance().has(new Table().setName(this.getDatabaseChangeLogTableName()).setSchema(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName()), this)) {
                ExecutorService.getInstance().getExecutor(this).execute(new DropTableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), false));
            }
            if (SnapshotGeneratorFactory.getInstance().has(new Table().setName(this.getDatabaseChangeLogLockTableName()).setSchema(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName()), this)) {
                ExecutorService.getInstance().getExecutor(this).execute(new DropTableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogLockTableName(), false));
            }
        }
        finally {
            this.setObjectQuotingStrategy(currentStrategy);
            this.commit();
        }
    }

    @Override
    public boolean supportsDropTableCascadeConstraints() {
        return this instanceof SQLiteDatabase || this instanceof SybaseDatabase || this instanceof SybaseASADatabase || this instanceof PostgresDatabase || this instanceof OracleDatabase;
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        if (example == null) {
            return false;
        }
        if (example.getSchema() != null && example.getSchema().getName() != null && example.getSchema().getName().equalsIgnoreCase("information_schema")) {
            return true;
        }
        if (example instanceof Table && this.getSystemTables().contains(example.getName())) {
            return true;
        }
        return example instanceof View && this.getSystemViews().contains(example.getName());
    }

    public boolean isSystemView(CatalogAndSchema schema, String viewName) {
        if ("information_schema".equalsIgnoreCase((schema = this.correctSchema(schema)).getSchemaName())) {
            return true;
        }
        return this.getSystemViews().contains(viewName);
    }

    @Override
    public boolean isLiquibaseObject(DatabaseObject object) {
        if (object instanceof Table) {
            Schema liquibaseSchema = new Schema(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName());
            if (DatabaseObjectComparatorFactory.getInstance().isSameObject(object, new Table().setName(this.getDatabaseChangeLogTableName()).setSchema(liquibaseSchema), this)) {
                return true;
            }
            return DatabaseObjectComparatorFactory.getInstance().isSameObject(object, new Table().setName(this.getDatabaseChangeLogLockTableName()).setSchema(liquibaseSchema), this);
        }
        if (object instanceof Column) {
            return this.isLiquibaseObject(((Column)object).getRelation());
        }
        if (object instanceof Index) {
            return this.isLiquibaseObject(((Index)object).getTable());
        }
        if (object instanceof PrimaryKey) {
            return this.isLiquibaseObject(((PrimaryKey)object).getTable());
        }
        return false;
    }

    @Override
    public void tag(String tagString) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        try {
            int totalRows = ExecutorService.getInstance().getExecutor(this).queryForInt(new SelectFromDatabaseChangeLogStatement("COUNT(*)"));
            if (totalRows == 0) {
                ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new Date().getTime()), "liquibase", false, false, "liquibase-internal", null, null, this.quotingStrategy, null);
                this.markChangeSetExecStatus(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
            }
            executor.execute(new TagDatabaseStatement(tagString));
            this.commit();
            this.getRanChangeSetList().get(this.getRanChangeSetList().size() - 1).setTag(tagString);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean doesTagExist(String tag) throws DatabaseException {
        int count = ExecutorService.getInstance().getExecutor(this).queryForInt(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByTag(tag), "COUNT(*)"));
        return count > 0;
    }

    public String toString() {
        if (this.getConnection() == null) {
            return this.getShortName() + " Database";
        }
        return this.getConnection().getConnectionUserName() + " @ " + this.getConnection().getURL() + (this.getDefaultSchemaName() == null ? "" : " (Default Schema: " + this.getDefaultSchemaName() + ")");
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = this.correctSchema(schema);
        String definition = (String)ExecutorService.getInstance().getExecutor(this).queryForObject(new GetViewDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), viewName), String.class);
        if (definition == null) {
            return null;
        }
        return CREATE_VIEW_AS_PATTERN.matcher(definition).replaceFirst("");
    }

    @Override
    public String escapeTableName(String catalogName, String schemaName, String tableName) {
        return this.escapeObjectName(catalogName, schemaName, tableName, Table.class);
    }

    @Override
    public String escapeObjectName(String catalogName, String schemaName, String objectName, Class<? extends DatabaseObject> objectType) {
        if (this.supportsSchemas()) {
            catalogName = StringUtils.trimToNull(catalogName);
            schemaName = StringUtils.trimToNull(schemaName);
            if (catalogName == null) {
                catalogName = this.getDefaultCatalogName();
            }
            if (schemaName == null) {
                schemaName = this.getDefaultSchemaName();
            }
            if (!this.supportsCatalogInObjectName(objectType)) {
                catalogName = null;
            }
            if (catalogName == null && schemaName == null) {
                return this.escapeObjectName(objectName, objectType);
            }
            if (catalogName == null || !this.supportsCatalogInObjectName(objectType)) {
                if (this.isDefaultSchema(catalogName, schemaName) && !this.getOutputDefaultSchema()) {
                    return this.escapeObjectName(objectName, objectType);
                }
                return this.escapeObjectName(schemaName, Schema.class) + "." + this.escapeObjectName(objectName, objectType);
            }
            if (this.isDefaultSchema(catalogName, schemaName) && !this.getOutputDefaultSchema() && !this.getOutputDefaultCatalog()) {
                return this.escapeObjectName(objectName, objectType);
            }
            if (this.isDefaultSchema(catalogName, schemaName) && !this.getOutputDefaultCatalog()) {
                return this.escapeObjectName(schemaName, Schema.class) + "." + this.escapeObjectName(objectName, objectType);
            }
            return this.escapeObjectName(catalogName, Catalog.class) + "." + this.escapeObjectName(schemaName, Schema.class) + "." + this.escapeObjectName(objectName, objectType);
        }
        if (this.supportsCatalogs()) {
            catalogName = StringUtils.trimToNull(catalogName);
            schemaName = StringUtils.trimToNull(schemaName);
            if (catalogName != null) {
                if (this.getOutputDefaultCatalog()) {
                    return this.escapeObjectName(catalogName, Catalog.class) + "." + this.escapeObjectName(objectName, objectType);
                }
                if (this.isDefaultCatalog(catalogName)) {
                    return this.escapeObjectName(objectName, objectType);
                }
                return this.escapeObjectName(catalogName, Catalog.class) + "." + this.escapeObjectName(objectName, objectType);
            }
            if (schemaName != null) {
                if (this.getOutputDefaultCatalog()) {
                    return this.escapeObjectName(schemaName, Catalog.class) + "." + this.escapeObjectName(objectName, objectType);
                }
                if (this.isDefaultCatalog(schemaName)) {
                    return this.escapeObjectName(objectName, objectType);
                }
                return this.escapeObjectName(schemaName, Catalog.class) + "." + this.escapeObjectName(objectName, objectType);
            }
            catalogName = this.getDefaultCatalogName();
            if (catalogName == null) {
                return this.escapeObjectName(objectName, objectType);
            }
            if (this.isDefaultCatalog(catalogName) && this.getOutputDefaultCatalog()) {
                return this.escapeObjectName(catalogName, Catalog.class) + "." + this.escapeObjectName(objectName, objectType);
            }
            return this.escapeObjectName(objectName, objectType);
        }
        return this.escapeObjectName(objectName, objectType);
    }

    @Override
    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName != null) {
            if (objectName.contains("-") || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
                return this.quotingStartCharacter + objectName + this.quotingEndCharacter;
            }
            if (this.quotingStrategy == ObjectQuotingStrategy.QUOTE_ALL_OBJECTS) {
                return this.quotingStartCharacter + objectName + this.quotingEndCharacter;
            }
        }
        return objectName;
    }

    @Override
    public String escapeIndexName(String catalogName, String schemaName, String indexName) {
        return this.escapeObjectName(catalogName, schemaName, indexName, Index.class);
    }

    @Override
    public String escapeSequenceName(String catalogName, String schemaName, String sequenceName) {
        return this.escapeObjectName(catalogName, schemaName, sequenceName, Sequence.class);
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        return this.escapeObjectName(constraintName, Index.class);
    }

    @Override
    public String escapeColumnName(String catalogName, String schemaName, String tableName, String columnName) {
        if (columnName.contains("(")) {
            return columnName;
        }
        return this.escapeObjectName(columnName, Column.class);
    }

    @Override
    public String escapeColumnNameList(String columnNames) {
        StringBuffer sb = new StringBuffer();
        for (String columnName : columnNames.split(",")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.escapeObjectName(columnName.trim(), Column.class));
        }
        return sb.toString();
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public boolean supportsCatalogs() {
        return true;
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return false;
    }

    @Override
    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return false;
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        return "PK_" + tableName.toUpperCase();
    }

    @Override
    public String escapeViewName(String catalogName, String schemaName, String viewName) {
        return this.escapeObjectName(catalogName, schemaName, viewName, View.class);
    }

    @Override
    public ChangeSet.RunStatus getRunStatus(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        RanChangeSet foundRan = this.getRanChangeSet(changeSet);
        if (foundRan == null) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        if (foundRan.getLastCheckSum() == null) {
            try {
                LogFactory.getLogger().info("Updating NULL md5sum for " + changeSet.toString());
                ExecutorService.getInstance().getExecutor(this).execute(new RawSqlStatement("UPDATE " + this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM='" + changeSet.generateCheckSum().toString() + "' WHERE ID='" + changeSet.getId() + "' AND AUTHOR='" + changeSet.getAuthor() + "' AND FILENAME='" + changeSet.getFilePath() + "'"));
                this.commit();
            }
            catch (DatabaseException e) {
                throw new DatabaseException(e);
            }
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (foundRan.getLastCheckSum().equals(changeSet.generateCheckSum())) {
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (changeSet.shouldRunOnChange()) {
            return ChangeSet.RunStatus.RUN_AGAIN;
        }
        return ChangeSet.RunStatus.INVALID_MD5SUM;
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return null;
        }
        RanChangeSet foundRan = null;
        for (RanChangeSet ranChange : this.getRanChangeSetList()) {
            if (!ranChange.isSameAs(changeSet)) continue;
            foundRan = ranChange;
            break;
        }
        return foundRan;
    }

    @Override
    public List<RanChangeSet> getRanChangeSetList() throws DatabaseException {
        if (this.ranChangeSetList != null) {
            return this.ranChangeSetList;
        }
        String databaseChangeLogTableName = this.escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName());
        this.ranChangeSetList = new ArrayList<RanChangeSet>();
        if (this.hasDatabaseChangeLogTable()) {
            LogFactory.getLogger().info("Reading from " + databaseChangeLogTableName);
            SelectFromDatabaseChangeLogStatement select = new SelectFromDatabaseChangeLogStatement("FILENAME", "AUTHOR", "ID", "MD5SUM", "DATEEXECUTED", "ORDEREXECUTED", "TAG", "EXECTYPE", "DESCRIPTION", "COMMENTS").setOrderBy("DATEEXECUTED ASC", "ORDEREXECUTED ASC");
            List<Map> results = ExecutorService.getInstance().getExecutor(this).queryForList(select);
            for (Map rs : results) {
                String fileName = rs.get("FILENAME").toString();
                String author = rs.get("AUTHOR").toString();
                String id = rs.get("ID").toString();
                String md5sum = rs.get("MD5SUM") == null ? null : rs.get("MD5SUM").toString();
                String description = rs.get("DESCRIPTION") == null ? null : rs.get("DESCRIPTION").toString();
                String comments = rs.get("COMMENTS") == null ? null : rs.get("COMMENTS").toString();
                Object tmpDateExecuted = rs.get("DATEEXECUTED");
                Date dateExecuted = null;
                if (tmpDateExecuted instanceof Date) {
                    dateExecuted = (Date)tmpDateExecuted;
                } else {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    try {
                        dateExecuted = df.parse((String)tmpDateExecuted);
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                String tag = rs.get("TAG") == null ? null : rs.get("TAG").toString();
                String execType = rs.get("EXECTYPE") == null ? null : rs.get("EXECTYPE").toString();
                try {
                    RanChangeSet ranChangeSet = new RanChangeSet(fileName, id, author, CheckSum.parse(md5sum), dateExecuted, tag, ChangeSet.ExecType.valueOf(execType), description, comments);
                    this.ranChangeSetList.add(ranChangeSet);
                }
                catch (IllegalArgumentException e) {
                    LogFactory.getLogger().severe("Unknown EXECTYPE from database: " + execType);
                    throw e;
                }
            }
        }
        return this.ranChangeSetList;
    }

    @Override
    public Date getRanDate(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        RanChangeSet ranChange = this.getRanChangeSet(changeSet);
        if (ranChange == null) {
            return null;
        }
        return ranChange.getDateExecuted();
    }

    @Override
    public void markChangeSetExecStatus(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this).execute(new MarkChangeSetRanStatement(changeSet, execType));
        this.commit();
        this.getRanChangeSetList().add(new RanChangeSet(changeSet, execType));
    }

    @Override
    public void removeRanStatus(ChangeSet changeSet) throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this).execute(new RemoveChangeSetRanStatusStatement(changeSet));
        this.commit();
        this.getRanChangeSetList().remove(new RanChangeSet(changeSet));
    }

    @Override
    public String escapeStringForDatabase(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("'", "''");
    }

    @Override
    public void commit() throws DatabaseException {
        try {
            this.getConnection().commit();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void rollback() throws DatabaseException {
        try {
            this.getConnection().rollback();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJdbcDatabase that = (AbstractJdbcDatabase)o;
        if (this.connection == null) {
            if (that.connection == null) {
                return this == that;
            }
            return false;
        }
        return this.connection.equals(that.connection);
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : super.hashCode();
    }

    @Override
    public void close() throws DatabaseException {
        DatabaseConnection connection = this.getConnection();
        if (connection != null) {
            if (this.previousAutoCommit != null) {
                try {
                    connection.setAutoCommit(this.previousAutoCommit);
                }
                catch (DatabaseException e) {
                    LogFactory.getLogger().warning("Failed to restore the auto commit to " + this.previousAutoCommit);
                    throw e;
                }
            }
            connection.close();
        }
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws DatabaseException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean b) throws DatabaseException {
        try {
            this.getConnection().setAutoCommit(b);
        }
        catch (DatabaseException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean isSafeToRunUpdate() throws DatabaseException {
        DatabaseConnection connection = this.getConnection();
        if (connection == null) {
            return true;
        }
        String url = connection.getURL();
        if (url == null) {
            return false;
        }
        return url.contains("localhost") || url.contains("127.0.0.1");
    }

    @Override
    public void executeStatements(Change change, DatabaseChangeLog changeLog, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        SqlStatement[] statements = change.generateStatements(this);
        this.execute(statements, sqlVisitors);
    }

    @Override
    public void execute(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        for (SqlStatement statement : statements) {
            if (statement.skipOnUnsupported() && !SqlGeneratorFactory.getInstance().supports(statement, this)) continue;
            LogFactory.getLogger().debug("Executing Statement: " + statement.getClass().getName());
            ExecutorService.getInstance().getExecutor(this).execute(statement, sqlVisitors);
        }
    }

    @Override
    public void saveStatements(Change change, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, StatementNotSupportedOnDatabaseException, LiquibaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = change.generateStatements(this)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, this)) {
                writer.append(sql.toSql()).append(sql.getEndDelimiter()).append(StreamUtil.getLineSeparator()).append(StreamUtil.getLineSeparator());
            }
        }
    }

    @Override
    public void executeRollbackStatements(Change change, List<SqlVisitor> sqlVisitors) throws LiquibaseException, RollbackImpossibleException {
        SqlStatement[] statements = change.generateRollbackStatements(this);
        ArrayList<SqlVisitor> rollbackVisitors = new ArrayList<SqlVisitor>();
        if (sqlVisitors != null) {
            for (SqlVisitor visitor : sqlVisitors) {
                if (!visitor.isApplyToRollback()) continue;
                rollbackVisitors.add(visitor);
            }
        }
        this.execute(statements, rollbackVisitors);
    }

    @Override
    public void saveRollbackStatement(Change change, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, RollbackImpossibleException, StatementNotSupportedOnDatabaseException, LiquibaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = change.generateRollbackStatements(this)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, this)) {
                writer.append(sql.toSql()).append(sql.getEndDelimiter()).append("\n\n");
            }
        }
    }

    @Override
    public int getNextChangeSetSequenceValue() throws LiquibaseException {
        if (this.lastChangeSetSequenceValue == null) {
            this.lastChangeSetSequenceValue = this.getConnection() == null ? Integer.valueOf(0) : Integer.valueOf(ExecutorService.getInstance().getExecutor(this).queryForInt(new GetNextChangeSetSequenceValueStatement()));
        }
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    @Override
    public List<DatabaseFunction> getDateFunctions() {
        return this.dateFunctions;
    }

    @Override
    public boolean isFunction(String string) {
        if (string.endsWith("()")) {
            return true;
        }
        for (DatabaseFunction function : this.getDateFunctions()) {
            if (!function.toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetInternalState() {
        this.ranChangeSetList = null;
        this.hasDatabaseChangeLogLockTable = false;
    }

    @Override
    public boolean supportsForeignKeyDisable() {
        return false;
    }

    @Override
    public boolean disableForeignKeyChecks() throws DatabaseException {
        throw new DatabaseException("ForeignKeyChecks Management not supported");
    }

    @Override
    public void enableForeignKeyChecks() throws DatabaseException {
        throw new DatabaseException("ForeignKeyChecks Management not supported");
    }

    @Override
    public boolean createsIndexesForForeignKeys() {
        return false;
    }

    @Override
    public int getDataTypeMaxParameters(String dataTypeName) {
        return 2;
    }

    public CatalogAndSchema getSchemaFromJdbcInfo(String rawCatalogName, String rawSchemaName) {
        return this.correctSchema(new CatalogAndSchema(rawCatalogName, rawSchemaName));
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return schema.getCatalogName();
    }

    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return schema.getSchemaName();
    }

    public final String getJdbcCatalogName(Schema schema) {
        if (schema == null) {
            return this.getJdbcCatalogName(this.getDefaultSchema());
        }
        return this.getJdbcCatalogName(new CatalogAndSchema(schema.getCatalogName(), schema.getName()));
    }

    public final String getJdbcSchemaName(Schema schema) {
        if (schema == null) {
            return this.getJdbcSchemaName(this.getDefaultSchema());
        }
        return this.getJdbcSchemaName(new CatalogAndSchema(schema.getCatalogName(), schema.getName()));
    }

    @Override
    public boolean dataTypeIsNotModifiable(String typeName) {
        return this.unmodifiableDataTypes.contains(typeName.toLowerCase());
    }

    @Override
    public void setObjectQuotingStrategy(ObjectQuotingStrategy quotingStrategy) {
        this.quotingStrategy = quotingStrategy;
    }

    @Override
    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.quotingStrategy;
    }

    @Override
    public String generateDatabaseFunctionValue(DatabaseFunction databaseFunction) {
        if (databaseFunction.getValue() == null) {
            return null;
        }
        if (this.isCurrentTimeFunction(databaseFunction.getValue().toLowerCase())) {
            return this.getCurrentDateTimeFunction();
        }
        if (databaseFunction instanceof SequenceNextValueFunction) {
            if (this.sequenceNextValueFunction == null) {
                throw new RuntimeException(String.format("next value function for a sequence is not configured for database %s", this.getDefaultDatabaseProductName()));
            }
            return String.format(this.sequenceNextValueFunction, this.escapeObjectName(databaseFunction.getValue(), Sequence.class));
        }
        if (databaseFunction instanceof SequenceCurrentValueFunction) {
            if (this.sequenceCurrentValueFunction == null) {
                throw new RuntimeException(String.format("current value function for a sequence is not configured for database %s", this.getDefaultDatabaseProductName()));
            }
            return String.format(this.sequenceCurrentValueFunction, this.escapeObjectName(databaseFunction.getValue(), Sequence.class));
        }
        return databaseFunction.getValue();
    }

    private boolean isCurrentTimeFunction(String functionValue) {
        return functionValue.startsWith("current_timestamp") || functionValue.startsWith("current_datetime") || this.getCurrentDateTimeFunction().equalsIgnoreCase(functionValue);
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    @Override
    public void setOutputDefaultSchema(boolean outputDefaultSchema) {
        this.outputDefaultSchema = outputDefaultSchema;
    }

    @Override
    public boolean isDefaultSchema(String catalog, String schema) {
        if (!this.supportsSchemas()) {
            return true;
        }
        if (!this.isDefaultCatalog(catalog)) {
            return false;
        }
        return schema == null || schema.equalsIgnoreCase(this.getDefaultSchemaName());
    }

    @Override
    public boolean isDefaultCatalog(String catalog) {
        if (!this.supportsCatalogs()) {
            return true;
        }
        return catalog == null || catalog.equalsIgnoreCase(this.getDefaultCatalogName());
    }

    @Override
    public boolean getOutputDefaultSchema() {
        return this.outputDefaultSchema;
    }

    @Override
    public boolean getOutputDefaultCatalog() {
        return this.outputDefaultCatalog;
    }

    @Override
    public void setOutputDefaultCatalog(boolean outputDefaultCatalog) {
        this.outputDefaultCatalog = outputDefaultCatalog;
    }
}

