/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;

public class CompareControl {
    private SchemaComparison[] schemaComparisons;
    private Set<Class<? extends DatabaseObject>> compareTypes = new HashSet<Class<? extends DatabaseObject>>();
    private Map<Class<? extends DatabaseObject>, Set<String>> suppressedFields = new HashMap<Class<? extends DatabaseObject>, Set<String>>();
    public static CompareControl STANDARD = new CompareControl();

    public CompareControl() {
        this(null);
    }

    public CompareControl(Set<Class<? extends DatabaseObject>> compareTypes) {
        this.schemaComparisons = new SchemaComparison[]{new SchemaComparison(new CatalogAndSchema(null, null), new CatalogAndSchema(null, null))};
        this.setTypes(compareTypes);
    }

    public CompareControl(SchemaComparison[] schemaComparison, Set<Class<? extends DatabaseObject>> compareTypes) {
        this.schemaComparisons = schemaComparison;
        this.setTypes(compareTypes);
    }

    public CompareControl(SchemaComparison[] schemaComparison, String compareTypes) {
        this.schemaComparisons = schemaComparison;
        this.setTypes(DatabaseObjectFactory.getInstance().parseTypes(compareTypes));
    }

    public CompareControl(String[] referenceVsComparisonSchemas, Set<Class<? extends DatabaseObject>> compareTypes) {
        String[] splitReferenceSchemas = referenceVsComparisonSchemas[0].split(",");
        String[] splitComparisonSchemas = referenceVsComparisonSchemas[1].split(",");
        this.schemaComparisons = new SchemaComparison[splitReferenceSchemas.length];
        for (int i = 0; i < splitReferenceSchemas.length; ++i) {
            String referenceCatalogName = null;
            String referenceSchemaName = splitReferenceSchemas[i];
            if (referenceSchemaName.contains(".")) {
                referenceCatalogName = referenceSchemaName.split(".", 2)[0];
                referenceSchemaName = referenceSchemaName.split(".", 2)[1];
            }
            String comparisonCatalogName = null;
            String comparisonSchemaName = splitComparisonSchemas[i];
            if (comparisonSchemaName.contains(".")) {
                comparisonCatalogName = comparisonSchemaName.split(".", 2)[0];
                comparisonSchemaName = comparisonSchemaName.split(".", 2)[1];
            }
            CatalogAndSchema referenceSchema = new CatalogAndSchema(referenceCatalogName, referenceSchemaName);
            CatalogAndSchema comparisonSchema = new CatalogAndSchema(comparisonCatalogName, comparisonSchemaName);
            this.schemaComparisons[i] = new SchemaComparison(referenceSchema, comparisonSchema);
            this.setTypes(compareTypes);
        }
    }

    protected void setTypes(Set<Class<? extends DatabaseObject>> types) {
        if (types == null || types.size() == 0) {
            types = DatabaseObjectFactory.getInstance().getStandardTypes();
        }
        this.compareTypes = types;
    }

    public Set<Class<? extends DatabaseObject>> getComparedTypes() {
        return this.compareTypes;
    }

    public void addSuppressedField(Class<? extends DatabaseObject> type, String field) {
        if (!this.suppressedFields.containsKey(type)) {
            this.suppressedFields.put(type, new HashSet());
        }
        this.suppressedFields.get(type).add(field);
    }

    public boolean isSuppressedField(Class<? extends DatabaseObject> type, String field) {
        if (!this.suppressedFields.containsKey(type)) {
            return false;
        }
        return this.suppressedFields.get(type).contains(field);
    }

    public SchemaComparison[] getSchemaComparisons() {
        return this.schemaComparisons;
    }

    public CatalogAndSchema[] getSchemas(DatabaseRole databaseRole) {
        CatalogAndSchema[] schemas = new CatalogAndSchema[this.schemaComparisons.length];
        for (int i = 0; i < this.schemaComparisons.length; ++i) {
            if (databaseRole.equals((Object)DatabaseRole.COMPARISON)) {
                schemas[i] = this.schemaComparisons[i].getComparisonSchema();
                continue;
            }
            if (databaseRole.equals((Object)DatabaseRole.REFERENCE)) {
                schemas[i] = this.schemaComparisons[i].getReferenceSchema();
                continue;
            }
            throw new UnexpectedLiquibaseException("Unknkown diff type: " + (Object)((Object)databaseRole));
        }
        return schemas;
    }

    public static class SchemaComparison {
        private CatalogAndSchema comparisonSchema;
        private CatalogAndSchema referenceSchema;

        public SchemaComparison(CatalogAndSchema reference, CatalogAndSchema comparison) {
            this.referenceSchema = reference;
            this.comparisonSchema = comparison;
        }

        public CatalogAndSchema getComparisonSchema() {
            return this.comparisonSchema;
        }

        public CatalogAndSchema getReferenceSchema() {
            return this.referenceSchema;
        }
    }

    public static enum DatabaseRole {
        REFERENCE,
        COMPARISON;

    }
}

