/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.executor.Executor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.GetNextChangeSetSequenceValueStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogLockStatement;
import liquibase.statement.core.UnlockDatabaseChangeLogStatement;
import liquibase.util.StreamUtil;

@LiquibaseService(skip=true)
public class LoggingExecutor
extends AbstractExecutor
implements Executor {
    private Writer output;
    private Executor delegatedReadExecutor;

    public LoggingExecutor(Executor delegatedExecutor, Writer output, Database database) {
        this.output = output;
        this.delegatedReadExecutor = delegatedExecutor;
        this.setDatabase(database);
    }

    @Override
    public void execute(SqlStatement sql) throws DatabaseException {
        this.outputStatement(sql);
    }

    @Override
    public int update(SqlStatement sql) throws DatabaseException {
        if (sql instanceof LockDatabaseChangeLogStatement) {
            return 1;
        }
        if (sql instanceof UnlockDatabaseChangeLogStatement) {
            return 1;
        }
        this.outputStatement(sql);
        return 0;
    }

    @Override
    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        this.outputStatement(sql, sqlVisitors);
    }

    @Override
    public int update(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        this.outputStatement(sql, sqlVisitors);
        return 0;
    }

    @Override
    public void comment(String message) throws DatabaseException {
        try {
            this.output.write(this.database.getLineComment());
            this.output.write(" ");
            this.output.write(message);
            this.output.write(StreamUtil.getLineSeparator());
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    private void outputStatement(SqlStatement sql) throws DatabaseException {
        this.outputStatement(sql, new ArrayList<SqlVisitor>());
    }

    private void outputStatement(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        try {
            if (SqlGeneratorFactory.getInstance().generateStatementsVolatile(sql, this.database)) {
                throw new DatabaseException(sql.getClass().getSimpleName() + " requires access to up to date database metadata which is not available in SQL output mode");
            }
            for (String statement : this.applyVisitors(sql, sqlVisitors)) {
                if (statement == null) continue;
                this.output.write(statement);
                if (this.database instanceof MSSQLDatabase || this.database instanceof SybaseDatabase || this.database instanceof SybaseASADatabase) {
                    this.output.write(StreamUtil.getLineSeparator());
                    this.output.write("GO");
                } else {
                    String endDelimiter = ";";
                    if (sql instanceof RawSqlStatement) {
                        endDelimiter = ((RawSqlStatement)sql).getEndDelimiter();
                    }
                    if (!statement.endsWith(endDelimiter)) {
                        this.output.write(endDelimiter);
                    }
                }
                this.output.write(StreamUtil.getLineSeparator());
                this.output.write(StreamUtil.getLineSeparator());
            }
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Object queryForObject(SqlStatement sql, Class requiredType) throws DatabaseException {
        if (sql instanceof SelectFromDatabaseChangeLogLockStatement) {
            return false;
        }
        return this.delegatedReadExecutor.queryForObject(sql, requiredType);
    }

    @Override
    public Object queryForObject(SqlStatement sql, Class requiredType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.delegatedReadExecutor.queryForObject(sql, requiredType, sqlVisitors);
    }

    @Override
    public long queryForLong(SqlStatement sql) throws DatabaseException {
        return this.delegatedReadExecutor.queryForLong(sql);
    }

    @Override
    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.delegatedReadExecutor.queryForLong(sql, sqlVisitors);
    }

    @Override
    public int queryForInt(SqlStatement sql) throws DatabaseException {
        try {
            return this.delegatedReadExecutor.queryForInt(sql);
        }
        catch (DatabaseException e) {
            if (sql instanceof GetNextChangeSetSequenceValueStatement) {
                return 0;
            }
            throw e;
        }
    }

    @Override
    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.delegatedReadExecutor.queryForInt(sql, sqlVisitors);
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        return this.delegatedReadExecutor.queryForList(sql, elementType);
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.delegatedReadExecutor.queryForList(sql, elementType, sqlVisitors);
    }

    @Override
    public List<Map> queryForList(SqlStatement sql) throws DatabaseException {
        return this.delegatedReadExecutor.queryForList(sql);
    }

    @Override
    public List<Map> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.delegatedReadExecutor.queryForList(sql, sqlVisitors);
    }

    @Override
    public boolean updatesDatabase() {
        return false;
    }
}

