/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class CompositeResourceAccessor
implements ResourceAccessor {
    List<ResourceAccessor> openers;

    public CompositeResourceAccessor(List<ResourceAccessor> openers) {
        this.openers = openers;
    }

    public CompositeResourceAccessor(ResourceAccessor ... openers) {
        this.openers = Arrays.asList(openers);
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        for (ResourceAccessor o : this.openers) {
            InputStream is = o.getResourceAsStream(file);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        for (ResourceAccessor o : this.openers) {
            Enumeration<URL> e = o.getResources(packageName);
            while (e.hasMoreElements()) {
                urls.add(e.nextElement());
            }
            if (urls.isEmpty()) continue;
            break;
        }
        return urls.elements();
    }

    @Override
    public ClassLoader toClassLoader() {
        ClassLoader[] loaders = new ClassLoader[this.openers.size()];
        int i = 0;
        for (ResourceAccessor fo : this.openers) {
            loaders[i++] = fo.toClassLoader();
        }
        return new CompositeClassLoader(loaders);
    }

    public String toString() {
        ArrayList<String> openerStrings = new ArrayList<String>();
        for (ResourceAccessor opener : this.openers) {
            openerStrings.add(opener.toString());
        }
        return this.getClass().getName() + "(" + StringUtils.join(openerStrings, ",") + ")";
    }

    private static class CompositeClassLoader
    extends ClassLoader {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        public CompositeClassLoader(ClassLoader ... classLoaders) {
            this.classLoaders.addAll(Arrays.asList(classLoaders));
        }

        public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Iterator<ClassLoader> i$ = this.classLoaders.iterator();
            while (i$.hasNext()) {
                ClassLoader classLoader1;
                ClassLoader classLoader = classLoader1 = i$.next();
                try {
                    Class<?> classe = classLoader.loadClass(name);
                    if (resolve) {
                        this.resolveClass(classe);
                    }
                    return classe;
                }
                catch (ClassNotFoundException notFound) {
                }
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                Class<?> classe = contextClassLoader.loadClass(name);
                if (resolve) {
                    this.resolveClass(classe);
                }
                return classe;
            }
            throw new ClassNotFoundException(name);
        }
    }
}

