/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class JdbcDatabaseSnapshot
extends DatabaseSnapshot {
    private CachingDatabaseMetaData cachingDatabaseMetaData;

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        super(examples, database, snapshotControl);
    }

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        super(examples, database);
    }

    public CachingDatabaseMetaData getMetaData() throws SQLException {
        if (this.cachingDatabaseMetaData == null) {
            DatabaseMetaData databaseMetaData = null;
            if (this.getDatabase().getConnection() != null) {
                databaseMetaData = ((JdbcConnection)this.getDatabase().getConnection()).getUnderlyingConnection().getMetaData();
            }
            this.cachingDatabaseMetaData = new CachingDatabaseMetaData(this.getDatabase(), databaseMetaData);
        }
        return this.cachingDatabaseMetaData;
    }

    public class CachingDatabaseMetaData {
        private DatabaseMetaData databaseMetaData;
        private Database database;

        public CachingDatabaseMetaData(Database database, DatabaseMetaData metaData) {
            this.databaseMetaData = metaData;
            this.database = database;
        }

        public DatabaseMetaData getDatabaseMetaData() {
            return this.databaseMetaData;
        }

        public List<CachedRow> getForeignKeys(final String catalogName, final String schemaName, final String tableName, final String fkName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getImportedKeys").get(new ResultSetCache.UnionResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("FKTABLE_CAT"), row.getString("FKTABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("FKTABLE_NAME"), row.getString("FK_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, fkName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    ArrayList<String> tables = new ArrayList<String>();
                    if (tableName == null) {
                        for (CachedRow row : CachingDatabaseMetaData.this.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, new String[]{"TABLE"})) {
                            tables.add(row.getString("TABLE_NAME"));
                        }
                    } else {
                        tables.add(tableName);
                    }
                    for (String foundTable : tables) {
                        returnList.addAll(this.extract(CachingDatabaseMetaData.this.databaseMetaData.getImportedKeys(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), foundTable)));
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    return null;
                }

                @Override
                boolean shouldBulkSelect(ResultSetCache resultSetCache) {
                    return false;
                }
            });
        }

        public List<CachedRow> getIndexInfo(final String catalogName, final String schemaName, final String tableName, final String indexName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getIndexInfo").get(new ResultSetCache.UnionResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("INDEX_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, indexName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        String sql = "SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class) + "'";
                        if (tableName != null) {
                            sql = sql + " AND TABLE_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class) + "'";
                        }
                        if (indexName != null) {
                            sql = sql + " AND INDEX_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(indexName, Index.class) + "'";
                        }
                        sql = sql + " ORDER BY INDEX_NAME, ORDINAL_POSITION";
                        returnList.addAll(this.extract(this.executeQuery(sql, CachingDatabaseMetaData.this.database)));
                    } else {
                        ArrayList<String> tables = new ArrayList<String>();
                        if (tableName == null) {
                            for (CachedRow row : CachingDatabaseMetaData.this.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, new String[]{"TABLE"})) {
                                tables.add(row.getString("TABLE_NAME"));
                            }
                        } else {
                            tables.add(tableName);
                        }
                        for (String tableName2 : tables) {
                            returnList.addAll(this.extract(CachingDatabaseMetaData.this.databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName2, false, true)));
                        }
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    return this.fastFetch();
                }

                @Override
                boolean shouldBulkSelect(ResultSetCache resultSetCache) {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return super.shouldBulkSelect(resultSetCache);
                    }
                    return false;
                }
            });
        }

        public List<CachedRow> getColumns(final String catalogName, final String schemaName, final String tableName, final String columnName) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getColumns").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("COLUMN_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, columnName);
                }

                @Override
                boolean shouldBulkSelect(ResultSetCache resultSetCache) {
                    HashSet<String> seenTables = resultSetCache.getInfo("seenTables", Set.class);
                    if (seenTables == null) {
                        seenTables = new HashSet<String>();
                        resultSetCache.putInfo("seenTables", seenTables);
                    }
                    seenTables.add(catalogName + ":" + schemaName + ":" + tableName);
                    return seenTables.size() > 2;
                }

                @Override
                public ResultSet fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName, columnName);
                }

                @Override
                public ResultSet bulkFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, null);
                }
            });
        }

        public List<CachedRow> getTables(final String catalogName, final String schemaName, final String table, final String[] types) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getTables." + StringUtils.join(types, ":")).get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public ResultSet fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return CachingDatabaseMetaData.this.databaseMetaData.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), CachingDatabaseMetaData.this.database.correctObjectName(table, Table.class), types);
                }

                @Override
                public ResultSet bulkFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return CachingDatabaseMetaData.this.databaseMetaData.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, types);
                }
            });
        }

        public List<CachedRow> getPrimaryKeys(final String catalogName, final String schemaName, final String table) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getPrimaryKeys").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public ResultSet fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return CachingDatabaseMetaData.this.databaseMetaData.getPrimaryKeys(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), table);
                }

                @Override
                public ResultSet bulkFetchQuery() throws SQLException {
                    return null;
                }

                @Override
                boolean shouldBulkSelect(ResultSetCache resultSetCache) {
                    return false;
                }
            });
        }

        public List<CachedRow> getUniqueConstraints(final String catalogName, final String schemaName, final String tableName) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getUniqueConstraints").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName);
                }

                @Override
                public ResultSet fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return this.executeQuery(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName), JdbcDatabaseSnapshot.this.getDatabase());
                }

                @Override
                public ResultSet bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = CachingDatabaseMetaData.this.database.correctSchema(new CatalogAndSchema(catalogName, schemaName));
                    return this.executeQuery(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null), JdbcDatabaseSnapshot.this.getDatabase());
                }

                private String createSql(String catalogName2, String schemaName2, String tableName2) throws SQLException {
                    String sql;
                    Database database = JdbcDatabaseSnapshot.this.getDatabase();
                    if (database instanceof MySQLDatabase || database instanceof HsqlDatabase) {
                        sql = "select CONSTRAINT_NAME from information_schema.table_constraints where constraint_schema='" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof PostgresDatabase) {
                        sql = "select CONSTRAINT_NAME from information_schema.table_constraints where constraint_catalog='" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and constraint_schema='" + database.correctObjectName(schemaName2, Schema.class) + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof MSSQLDatabase) {
                        sql = "select CONSTRAINT_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'Unique' and CONSTRAINT_SCHEMA='" + database.correctObjectName(schemaName2, Schema.class) + "'";
                        if (tableName2 != null) {
                            sql = sql + " and TABLE_NAME='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof OracleDatabase) {
                        sql = "select uc.constraint_name, uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name from all_constraints uc, all_cons_columns ucc, all_indexes ui where uc.constraint_type='U' and uc.index_name = ui.index_name and uc.constraint_name = ucc.constraint_name and uc.owner = '" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and ui.table_owner = '" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and ucc.owner = '" + database.correctObjectName(catalogName2, Catalog.class) + "'";
                        if (tableName2 != null) {
                            sql = sql + " and uc.table_name = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof DB2Database) {
                        sql = "select distinct k.constname as constraint_name from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.tabschema = '" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and t.type='U'";
                        if (tableName2 != null) {
                            sql = sql + " and t.tabname = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof FirebirdDatabase) {
                        sql = "SELECT RDB$INDICES.RDB$INDEX_NAME AS CONSTRAINT_NAME FROM RDB$INDICES LEFT JOIN RDB$RELATION_CONSTRAINTS ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDICES.RDB$INDEX_NAME WHERE RDB$INDICES.RDB$UNIQUE_FLAG IS NOT NULL AND RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE != 'PRIMARY KEY' AND NOT(RDB$INDICES.RDB$INDEX_NAME LIKE 'RDB$%')";
                        if (tableName2 != null) {
                            sql = sql + " AND RDB$INDICES.RDB$RELATION_NAME='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof DerbyDatabase) {
                        sql = "select c.constraintname as CONSTRAINT_NAME from sys.systables t, sys.sysconstraints c, sys.sysschemas s where s.schemaname='" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and t.tableid = c.tableid " + "and t.schemaid=s.schemaid " + "and c.type = 'U'";
                        if (tableName2 != null) {
                            sql = sql + " AND t.tablename = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else {
                        sql = "select CONSTRAINT_NAME, CONSTRAINT_TYPE from information_schema.constraints where constraint_schema='" + database.correctObjectName(schemaName2, Schema.class) + "' " + "and constraint_catalog='" + database.correctObjectName(catalogName2, Catalog.class) + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    }
                    return sql;
                }
            });
        }
    }
}

