/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;

public class SnapshotControl {
    private Set<Class<? extends DatabaseObject>> types;

    public SnapshotControl(Database database) {
        this.setTypes(DatabaseObjectFactory.getInstance().getStandardTypes(), database);
    }

    public SnapshotControl(Database database, Class<? extends DatabaseObject> ... types) {
        if (types == null || types.length == 0) {
            this.setTypes(DatabaseObjectFactory.getInstance().getStandardTypes(), database);
        } else {
            this.setTypes(new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(types)), database);
        }
    }

    public SnapshotControl(Database database, String types) {
        this.setTypes(DatabaseObjectFactory.getInstance().parseTypes(types), database);
    }

    private void setTypes(Set<Class<? extends DatabaseObject>> types, Database database) {
        this.types = new HashSet<Class<? extends DatabaseObject>>();
        for (Class<? extends DatabaseObject> type : types) {
            this.addType(type, database);
        }
    }

    public boolean addType(Class<? extends DatabaseObject> type, Database database) {
        boolean added = this.types.add(type);
        if (added) {
            for (Class<? extends DatabaseObject> container : SnapshotGeneratorFactory.getInstance().getContainerTypes(type, database)) {
                this.addType(container, database);
            }
        }
        return added;
    }

    public Set<Class<? extends DatabaseObject>> getTypesToInclude() {
        return this.types;
    }

    public boolean shouldInclude(Class<? extends DatabaseObject> type) {
        return this.types.contains(type);
    }
}

