/*
 * Decompiled with CFR 0.152.
 */
package liquibase.statement;

import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.statement.ExecutablePreparedStatementBase;

public class UpdateExecutablePreparedStatement
extends ExecutablePreparedStatementBase {
    public UpdateExecutablePreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns) {
        super(database, catalogName, schemaName, tableName, columns);
    }

    @Override
    protected String generateSql(List<ColumnConfig> cols) {
        StringBuilder sql = new StringBuilder("UPDATE ").append(this.database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName()));
        StringBuilder params = new StringBuilder(" SET ");
        for (ColumnConfig column : this.getColumns()) {
            params.append(this.database.escapeColumnName(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName()));
            params.append(" = ");
            params.append("?, ");
            cols.add(column);
        }
        params.deleteCharAt(params.lastIndexOf(" "));
        params.deleteCharAt(params.lastIndexOf(","));
        sql.append((CharSequence)params);
        return sql.toString();
    }
}

