/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.structure.DatabaseObject;

public class DatabaseObjectCollection {
    private Map<Class<? extends DatabaseObject>, Map<String, Set<DatabaseObject>>> cache = new HashMap<Class<? extends DatabaseObject>, Map<String, Set<DatabaseObject>>>();
    private Database database;

    public DatabaseObjectCollection(Database database) {
        this.database = database;
    }

    public void add(DatabaseObject databaseObject) {
        String[] hashes;
        if (databaseObject == null) {
            return;
        }
        Map<String, Set<DatabaseObject>> collectionMap = this.cache.get(databaseObject.getClass());
        if (collectionMap == null) {
            collectionMap = new HashMap<String, Set<DatabaseObject>>();
            this.cache.put(databaseObject.getClass(), collectionMap);
        }
        for (String hash : hashes = DatabaseObjectComparatorFactory.getInstance().hash(databaseObject, this.database)) {
            Set<DatabaseObject> collection = collectionMap.get(hash);
            if (collection == null) {
                collection = new HashSet<DatabaseObject>();
                collectionMap.put(hash, collection);
            }
            collection.add(databaseObject);
        }
    }

    public <DatabaseObjectType extends DatabaseObject> DatabaseObjectType get(DatabaseObjectType example) {
        Map<String, Set<DatabaseObject>> databaseObjectsByHash = this.cache.get(example.getClass());
        if (databaseObjectsByHash == null) {
            return null;
        }
        String[] hashes = DatabaseObjectComparatorFactory.getInstance().hash(example, this.database);
        TreeSet<Set<DatabaseObject>> objectSets = new TreeSet<Set<DatabaseObject>>(new Comparator<Set<DatabaseObject>>(){

            @Override
            public int compare(Set<DatabaseObject> o1, Set<DatabaseObject> o2) {
                int sizeComparison = Integer.valueOf(o1.size()).compareTo(o2.size());
                if (sizeComparison == 0) {
                    return o1.toString().compareTo(o2.toString());
                }
                return sizeComparison;
            }
        });
        for (String hash : hashes) {
            Set<DatabaseObject> databaseObjects = databaseObjectsByHash.get(hash);
            if (databaseObjects == null) continue;
            objectSets.add(databaseObjects);
        }
        for (Set set : objectSets) {
            for (DatabaseObject obj : set) {
                if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(obj, example, this.database)) continue;
                return (DatabaseObjectType)obj;
            }
        }
        return null;
    }

    public <DatabaseObjectType extends DatabaseObject> Set<DatabaseObjectType> get(Class<DatabaseObjectType> type) {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Map<String, Set<DatabaseObject>> allFound = this.cache.get(type);
        if (allFound != null) {
            for (Set<DatabaseObject> objects : allFound.values()) {
                returnSet.addAll(objects);
            }
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public boolean contains(DatabaseObject wantedObject) {
        return this.get(wantedObject) != null;
    }
}

