/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern commentPattern = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern dashPattern = Pattern.compile("\\-\\-.*$", 8);

    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.length() == 0) {
            return null;
        }
        return returnString;
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        String stripped;
        String string = stripped = stripComments ? StringUtils.stripComments(multiLineSQL) : multiLineSQL;
        if (splitStatements) {
            return StringUtils.splitSQL(stripped, endDelimiter);
        }
        return new String[]{stripped};
    }

    public static String[] splitSQL(String multiLineSQL, String endDelimiter) {
        if (endDelimiter == null) {
            endDelimiter = ";\\s*\n|;$|\n[gG][oO]\\s*\n|\n[Gg][oO]\\s*$";
        } else if (endDelimiter.equalsIgnoreCase("go")) {
            endDelimiter = "\n[gG][oO]\\s*\n|\n[Gg][oO]\\s*$";
        }
        String[] initialSplit = multiLineSQL.split(endDelimiter);
        ArrayList<String> strings = new ArrayList<String>();
        for (String anInitialSplit : initialSplit) {
            String singleLineSQL = anInitialSplit.trim();
            if (singleLineSQL.length() <= 0) continue;
            strings.add(singleLineSQL);
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String stripComments(String multiLineSQL) {
        String strippedSingleLines = Pattern.compile("\\s*\\-\\-.*\n").matcher(multiLineSQL).replaceAll("\n");
        strippedSingleLines = Pattern.compile("\\s*\\-\\-.*$").matcher(strippedSingleLines).replaceAll("\n");
        return Pattern.compile("/\\*.*?\\*/", 32).matcher(strippedSingleLines).replaceAll("").trim();
    }

    public static String join(String[] array, String delimiter) {
        return StringUtils.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<String> collection, String delimiter) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String val : collection) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static List<String> splitAndTrim(String s, String regex) {
        if (s == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String string : s.split(regex)) {
            returnList.add(string.trim());
        }
        return returnList;
    }

    public static String repeat(String string, int times) {
        String returnString = "";
        for (int i = 0; i < times; ++i) {
            returnString = returnString + string;
        }
        return returnString;
    }

    public static String join(Integer[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        int[] ints = new int[array.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = array[i];
        }
        return StringUtils.join(ints, delimiter);
    }

    public static String join(int[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int val : array) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static String lowerCaseFirst(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static String upperCaseFirst(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String standardizeLineEndings(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\r\n", "\n").replace("\r", "\n");
    }
}

