/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="datetime", aliases={"java.sql.Types.DATETIME", "java.util.Date", "smalldatetime", "datetime2"}, minParameters=0, maxParameters=1, priority=1)
public class DateTimeType
extends LiquibaseDataType {
    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof FirebirdDatabase || database instanceof H2Database || database instanceof HsqlDatabase || database instanceof OracleDatabase) {
            return new DatabaseDataType("TIMESTAMP");
        }
        if (database instanceof MSSQLDatabase && (this.getParameters().length > 0 && "16".equals(this.getParameters()[0]) || "SMALLDATETIME".equalsIgnoreCase(this.getRawDefinition()))) {
            return new DatabaseDataType("SMALLDATETIME");
        }
        if (database instanceof InformixDatabase) {
            if ((this.getAdditionalInformation() == null || this.getAdditionalInformation().length() == 0) && this.getParameters() != null && this.getParameters().length > 0) {
                String parameter = String.valueOf(this.getParameters()[0]);
                if ("4365".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO FRACTION(3)");
                }
                if ("3594".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO SECOND");
                }
                if ("3080".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO MINUTE");
                }
                if ("2052".equals(parameter)) {
                    return new DatabaseDataType("DATETIME YEAR TO DAY");
                }
            }
            if (this.getAdditionalInformation() != null && this.getAdditionalInformation().length() > 0) {
                return new DatabaseDataType(this.getRawDefinition());
            }
            return new DatabaseDataType("DATETIME YEAR TO FRACTION", 5);
        }
        if (database instanceof PostgresDatabase) {
            String rawDefinition = this.getRawDefinition().toLowerCase();
            if (rawDefinition.contains("tz") || rawDefinition.contains("with time zone")) {
                return new DatabaseDataType("TIMESTAMP WITH TIME ZONE");
            }
            return new DatabaseDataType("TIMESTAMP WITHOUT TIME ZONE");
        }
        if (database instanceof SQLiteDatabase) {
            return new DatabaseDataType("TEXT");
        }
        if (database instanceof MySQLDatabase) {
            boolean supportsParameters = true;
            try {
                supportsParameters = database.getDatabaseMajorVersion() >= 5 && database.getDatabaseMinorVersion() >= 6 && ((MySQLDatabase)database).getDatabasePatchVersion() >= 4;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (supportsParameters && this.getParameters().length > 0 && Integer.valueOf(this.getParameters()[0].toString()) <= 6) {
                return new DatabaseDataType(this.getName(), this.getParameters());
            }
            return new DatabaseDataType(this.getName());
        }
        return new DatabaseDataType(this.getName());
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (database.isFunction(value.toString())) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + ((String)value).replaceAll("'", "''") + "'";
        }
        return database.getDateTimeLiteral((Timestamp)value);
    }

    @Override
    public Object sqlToObject(String value, Database database) {
        if (this.zeroTime(value)) {
            return value;
        }
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
        }
        try {
            DateFormat dateTimeFormat = this.getDateTimeFormat(database);
            if (database instanceof OracleDatabase && value.matches("to_date\\('\\d+\\-\\d+\\-\\d+ \\d+:\\d+:\\d+', 'YYYY\\-MM\\-DD HH24:MI:SS'\\)")) {
                dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:s");
                value = value.replaceFirst(".*?'", "").replaceFirst("',.*", "");
            }
            return new Timestamp(dateTimeFormat.parse(value).getTime());
        }
        catch (ParseException e) {
            String[] genericFormats;
            for (String format : genericFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss"}) {
                try {
                    return new Timestamp(new SimpleDateFormat(format).parse(value).getTime());
                }
                catch (ParseException ignore) {
                }
            }
            return new DatabaseFunction(value);
        }
    }

    private boolean zeroTime(String stringVal) {
        return stringVal.replace("-", "").replace(":", "").replace(" ", "").replace("0", "").equals("");
    }

    protected DateFormat getDateTimeFormat(Database database) {
        if (database instanceof MySQLDatabase) {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        if (database instanceof MSSQLDatabase) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
        if (database instanceof DB2Database) {
            return new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }
}

