/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class JdbcDatabaseSnapshot
extends DatabaseSnapshot {
    private CachingDatabaseMetaData cachingDatabaseMetaData;

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database, SnapshotControl snapshotControl) throws DatabaseException, InvalidExampleException {
        super(examples, database, snapshotControl);
    }

    public JdbcDatabaseSnapshot(DatabaseObject[] examples, Database database) throws DatabaseException, InvalidExampleException {
        super(examples, database);
    }

    public CachingDatabaseMetaData getMetaData() throws SQLException {
        if (this.cachingDatabaseMetaData == null) {
            DatabaseMetaData databaseMetaData = null;
            if (this.getDatabase().getConnection() != null) {
                databaseMetaData = ((JdbcConnection)this.getDatabase().getConnection()).getUnderlyingConnection().getMetaData();
            }
            this.cachingDatabaseMetaData = new CachingDatabaseMetaData(this.getDatabase(), databaseMetaData);
        }
        return this.cachingDatabaseMetaData;
    }

    public class CachingDatabaseMetaData {
        private DatabaseMetaData databaseMetaData;
        private Database database;

        public CachingDatabaseMetaData(Database database, DatabaseMetaData metaData) {
            this.databaseMetaData = metaData;
            this.database = database;
        }

        public DatabaseMetaData getDatabaseMetaData() {
            return this.databaseMetaData;
        }

        public List<CachedRow> getForeignKeys(final String catalogName, final String schemaName, final String tableName, final String fkName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getImportedKeys").get(new ResultSetCache.UnionResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("FKTABLE_CAT"), row.getString("FKTABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("FKTABLE_NAME"), row.getString("FK_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, fkName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    ArrayList<String> tables = new ArrayList<String>();
                    String jdbcCatalogName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String jdbcSchemaName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    if (tableName == null) {
                        for (CachedRow row : CachingDatabaseMetaData.this.getTables(jdbcCatalogName, jdbcSchemaName, null)) {
                            tables.add(row.getString("TABLE_NAME"));
                        }
                    } else {
                        tables.add(tableName);
                    }
                    for (String foundTable : tables) {
                        if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                            throw new RuntimeException("Should have bulk selected");
                        }
                        returnList.addAll(this.extract(CachingDatabaseMetaData.this.databaseMetaData.getImportedKeys(jdbcCatalogName, jdbcSchemaName, foundTable)));
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                        String jdbcSchemaName = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                        String sql = "SELECT    NULL AS pktable_cat,    p.owner as pktable_schem,    p.table_name as pktable_name,    pc.column_name as pkcolumn_name,    NULL as fktable_cat,    f.owner as fktable_schem,    f.table_name as fktable_name,    fc.column_name as fkcolumn_name,    fc.position as key_seq,    NULL as update_rule,    decode (f.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,    f.constraint_name as fk_name,    p.constraint_name as pk_name,    decode(f.deferrable, 'DEFERRABLE', 5, 'NOT DEFERRABLE', 7, 'DEFERRED', 6) deferrability  FROM all_constraints p INNER JOIN all_cons_columns pc ON pc.owner = p.owner AND pc.constraint_name = p.constraint_name AND pc.table_name = p.table_name INNER JOIN all_constraints f ON p.owner = f.r_owner AND p.constraint_name = f.r_constraint_name INNER JOIN all_cons_columns fc ON fc.owner = f.owner AND fc.constraint_name = f.constraint_name AND fc.table_name = f.table_name AND fc.position = pc.position WHERE p.owner = '" + jdbcSchemaName + "' " + "AND p.constraint_type in ('P', 'U') " + "AND f.constraint_type = 'R' " + "ORDER BY fktable_schem, fktable_name, key_seq";
                        return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                    }
                    throw new RuntimeException("Cannot bulk select");
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return CachingDatabaseMetaData.this.database instanceof OracleDatabase;
                }
            });
        }

        public List<CachedRow> getIndexInfo(final String catalogName, final String schemaName, final String tableName, final String indexName) throws DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getIndexInfo").get(new ResultSetCache.UnionResultSetExtractor(this.database){
                public boolean bulkFetch;
                {
                    super(x0);
                    this.bulkFetch = false;
                }

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("INDEX_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, indexName);
                }

                @Override
                public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
                    ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        String sql = "SELECT c.INDEX_NAME, 3 AS TYPE, c.TABLE_NAME, c.COLUMN_NAME, c.COLUMN_POSITION AS ORDINAL_POSITION, e.COLUMN_EXPRESSION AS FILTER_CONDITION, case I.UNIQUENESS when 'UNIQUE' then 0 else 1 end as NON_UNIQUE FROM ALL_IND_COLUMNS c JOIN ALL_INDEXES i on i.index_name = c.index_name LEFT JOIN all_ind_expressions e on (e.column_position = c.column_position AND e.index_name = c.index_name) WHERE c.TABLE_OWNER='" + CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class) + "' " + "AND i.OWNER=c.TABLE_OWNER";
                        if (!this.bulkFetch && tableName != null) {
                            sql = sql + " AND c.TABLE_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class) + "'";
                        }
                        if (!this.bulkFetch && indexName != null) {
                            sql = sql + " AND c.INDEX_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(indexName, Index.class) + "'";
                        }
                        sql = sql + " ORDER BY c.INDEX_NAME, ORDINAL_POSITION";
                        returnList.addAll(this.executeAndExtract(sql, CachingDatabaseMetaData.this.database));
                    } else {
                        ArrayList<String> tables = new ArrayList<String>();
                        if (tableName == null) {
                            for (CachedRow row : CachingDatabaseMetaData.this.getTables(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null)) {
                                tables.add(row.getString("TABLE_NAME"));
                            }
                        } else {
                            tables.add(tableName);
                        }
                        for (String tableName2 : tables) {
                            ResultSet rs = CachingDatabaseMetaData.this.databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName2, false, true);
                            List<CachedRow> rows = this.extract(rs, CachingDatabaseMetaData.this.database instanceof InformixDatabase);
                            returnList.addAll(rows);
                        }
                    }
                    return returnList;
                }

                @Override
                public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
                    this.bulkFetch = true;
                    return this.fastFetch();
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return super.shouldBulkSelect(schemaKey, resultSetCache);
                    }
                    return false;
                }
            });
        }

        public List<CachedRow> getColumns(final String catalogName, final String schemaName, final String tableName, final String columnName) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getColumns").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"), row.getString("COLUMN_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName, columnName);
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    HashSet<String> seenTables = resultSetCache.getInfo("seenTables", Set.class);
                    if (seenTables == null) {
                        seenTables = new HashSet<String>();
                        resultSetCache.putInfo("seenTables", seenTables);
                    }
                    seenTables.add(catalogName + ":" + schemaName + ":" + tableName);
                    return seenTables.size() > 2;
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(false);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName, columnName));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.oracleQuery(true);
                    }
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    try {
                        return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getColumns(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null, null));
                    }
                    catch (SQLException e) {
                        if (this.shouldReturnEmptyColumns(e)) {
                            return new ArrayList<CachedRow>();
                        }
                        throw e;
                    }
                }

                protected boolean shouldReturnEmptyColumns(SQLException e) {
                    return e.getMessage().contains("references invalid table");
                }

                protected List<CachedRow> oracleQuery(boolean bulk) throws DatabaseException, SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    String sql = "select NULL AS TABLE_CAT, OWNER AS TABLE_SCHEM, 'NO' as IS_AUTOINCREMENT, cc.COMMENTS AS REMARKS,\nOWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE, DATA_TYPE_MOD, DATA_TYPE_OWNER, DECODE( CHAR_USED, 'C',CHAR_LENGTH, DATA_LENGTH ) as DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, COLUMN_ID, DEFAULT_LENGTH, DATA_DEFAULT, NUM_DISTINCT, LOW_VALUE, HIGH_VALUE, DENSITY, NUM_NULLS, NUM_BUCKETS, LAST_ANALYZED, SAMPLE_SIZE, CHARACTER_SET_NAME, CHAR_COL_DECL_LENGTH, GLOBAL_STATS, USER_STATS, AVG_COL_LEN, CHAR_LENGTH, CHAR_USED, V80_FMT_IMAGE, DATA_UPGRADED, HISTOGRAM, VIRTUAL_COLUMN\nFROM ALL_TAB_COLS c JOIN ALL_COL_COMMENTS cc USING ( OWNER, TABLE_NAME, COLUMN_NAME ) WHERE OWNER='" + ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema) + "' AND hidden_column='NO'";
                    if (!bulk) {
                        if (tableName != null) {
                            sql = sql + " AND TABLE_NAME='" + CachingDatabaseMetaData.this.database.escapeObjectName(tableName, Table.class) + "'";
                        }
                        if (columnName != null) {
                            sql = sql + " AND COLUMN_NAME='" + CachingDatabaseMetaData.this.database.escapeObjectName(columnName, Column.class) + "'";
                        }
                    }
                    sql = sql + " ORDER BY OWNER, TABLE_NAME, c.COLUMN_ID";
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getTables(final String catalogName, final String schemaName, final String table) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getTables").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, table);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, CachingDatabaseMetaData.this.database.correctObjectName(table, Table.class), new String[]{"TABLE"}));
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, null, new String[]{"TABLE"}));
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String tableName) throws DatabaseException, SQLException {
                    String ownerName = CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.TABLE_NAME as TABLE_NAME, a.TEMPORARY as TEMPORARY, a.DURATION as DURATION, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS from ALL_TABLES a join ALL_TAB_COMMENTS c on a.TABLE_NAME=c.table_name and a.owner=c.owner WHERE a.OWNER='" + ownerName + "'";
                    if (tableName != null) {
                        sql = sql + " AND a.TABLE_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(tableName, Table.class) + "'";
                    }
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getViews(final String catalogName, final String schemaName, final String view) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getViews").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, view);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, view);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, CachingDatabaseMetaData.this.database.correctObjectName(view, View.class), new String[]{"VIEW"}));
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (CachingDatabaseMetaData.this.database instanceof OracleDatabase) {
                        return this.queryOracle(catalogAndSchema, null);
                    }
                    String catalog = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema);
                    String schema = ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema);
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getTables(catalog, schema, null, new String[]{"VIEW"}));
                }

                private List<CachedRow> queryOracle(CatalogAndSchema catalogAndSchema, String viewName) throws DatabaseException, SQLException {
                    String ownerName = CachingDatabaseMetaData.this.database.correctObjectName(catalogAndSchema.getCatalogName(), Schema.class);
                    String sql = "SELECT null as TABLE_CAT, a.OWNER as TABLE_SCHEM, a.VIEW_NAME as TABLE_NAME, 'TABLE' as TABLE_TYPE, c.COMMENTS as REMARKS from ALL_VIEWS a join ALL_TAB_COMMENTS c on a.VIEW_NAME=c.table_name and a.owner=c.owner WHERE a.OWNER='" + ownerName + "'";
                    if (viewName != null) {
                        sql = sql + " AND a.VIEW_NAME='" + CachingDatabaseMetaData.this.database.correctObjectName(viewName, View.class) + "'";
                    }
                    sql = sql + " AND a.VIEW_NAME not in (select mv.name from all_registered_mviews mv where mv.owner='" + ownerName + "')";
                    return this.executeAndExtract(sql, CachingDatabaseMetaData.this.database);
                }
            });
        }

        public List<CachedRow> getPrimaryKeys(final String catalogName, final String schemaName, final String table) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getPrimaryKeys").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, table);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    if (table == null) {
                        try {
                            ArrayList<CachedRow> foundPks = new ArrayList<CachedRow>();
                            List<CachedRow> tables = CachingDatabaseMetaData.this.getTables(catalogName, schemaName, null);
                            for (CachedRow table2 : tables) {
                                List<CachedRow> pkInfo = this.extract(CachingDatabaseMetaData.this.databaseMetaData.getPrimaryKeys(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), table2.getString("TABLE_NAME")));
                                if (pkInfo == null) continue;
                                foundPks.addAll(pkInfo);
                            }
                            return foundPks;
                        }
                        catch (DatabaseException e) {
                            throw new SQLException(e);
                        }
                    }
                    return this.extract(CachingDatabaseMetaData.this.databaseMetaData.getPrimaryKeys(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), table));
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException {
                    return null;
                }

                @Override
                boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                    return false;
                }
            });
        }

        public List<CachedRow> getUniqueConstraints(final String catalogName, final String schemaName, final String tableName) throws SQLException, DatabaseException {
            return JdbcDatabaseSnapshot.this.getResultSetCache("getUniqueConstraints").get(new ResultSetCache.SingleResultSetExtractor(this.database){

                @Override
                public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                    return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), CachingDatabaseMetaData.this.database, row.getString("TABLE_NAME"));
                }

                @Override
                public ResultSetCache.RowData wantedKeyParameters() {
                    return new ResultSetCache.RowData(catalogName, schemaName, CachingDatabaseMetaData.this.database, tableName);
                }

                @Override
                public List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), tableName), JdbcDatabaseSnapshot.this.getDatabase());
                }

                @Override
                public List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException {
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize(CachingDatabaseMetaData.this.database);
                    return this.executeAndExtract(this.createSql(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), ((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), null), JdbcDatabaseSnapshot.this.getDatabase());
                }

                private String createSql(String catalogName2, String schemaName2, String tableName2) throws SQLException {
                    String sql;
                    CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName2, schemaName2).customize(CachingDatabaseMetaData.this.database);
                    String jdbcCatalogName = CachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcCatalogName(catalogAndSchema), Catalog.class);
                    String jdbcSchemaName = CachingDatabaseMetaData.this.database.correctObjectName(((AbstractJdbcDatabase)CachingDatabaseMetaData.this.database).getJdbcSchemaName(catalogAndSchema), Schema.class);
                    Database database = JdbcDatabaseSnapshot.this.getDatabase();
                    if (database instanceof MySQLDatabase || database instanceof HsqlDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints " + "where constraint_schema='" + jdbcCatalogName + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof PostgresDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from " + database.getSystemSchema() + ".table_constraints " + "where constraint_catalog='" + jdbcCatalogName + "' " + "and constraint_schema='" + jdbcSchemaName + "' " + "and constraint_type='UNIQUE'";
                        if (tableName2 != null) {
                            sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof MSSQLDatabase) {
                        sql = "select CONSTRAINT_NAME, TABLE_NAME from INFORMATION_SCHEMA.TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'Unique' and CONSTRAINT_SCHEMA='" + jdbcSchemaName + "'";
                        if (tableName2 != null) {
                            sql = sql + " and TABLE_NAME='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof OracleDatabase) {
                        sql = "select uc.constraint_name, uc.table_name,uc.status,uc.deferrable,uc.deferred,ui.tablespace_name from all_constraints uc, all_indexes ui where uc.constraint_type='U' and uc.index_name = ui.index_name and uc.owner = '" + jdbcSchemaName + "' " + "and ui.table_owner = '" + jdbcSchemaName + "' ";
                        if (tableName2 != null) {
                            sql = sql + " and uc.table_name = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof DB2Database) {
                        if (database.getDatabaseProductName().startsWith("DB2 UDB for AS/400")) {
                            sql = "select constraint_name as constraint_name, table_name as table_name from QSYS2.TABLE_CONSTRAINTS where table_schema='" + jdbcSchemaName + "' and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name = '" + database.correctObjectName(tableName2, Table.class) + "'";
                            }
                        } else {
                            sql = "select distinct k.constname as constraint_name, t.tabname as TABLE_NAME from syscat.keycoluse k, syscat.tabconst t where k.constname = t.constname and t.tabschema = '" + jdbcCatalogName + "' " + "and t.type='U'";
                            if (tableName2 != null) {
                                sql = sql + " and t.tabname = '" + database.correctObjectName(tableName2, Table.class) + "'";
                            }
                        }
                    } else if (database instanceof FirebirdDatabase) {
                        sql = "SELECT RDB$INDICES.RDB$INDEX_NAME AS CONSTRAINT_NAME, RDB$INDICES.RDB$RELATION_NAME AS TABLE_NAME FROM RDB$INDICES LEFT JOIN RDB$RELATION_CONSTRAINTS ON RDB$RELATION_CONSTRAINTS.RDB$INDEX_NAME = RDB$INDICES.RDB$INDEX_NAME WHERE RDB$INDICES.RDB$UNIQUE_FLAG IS NOT NULL AND RDB$RELATION_CONSTRAINTS.RDB$CONSTRAINT_TYPE != 'PRIMARY KEY' AND NOT(RDB$INDICES.RDB$INDEX_NAME LIKE 'RDB$%')";
                        if (tableName2 != null) {
                            sql = sql + " AND RDB$INDICES.RDB$RELATION_NAME='" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof DerbyDatabase) {
                        sql = "select c.constraintname as CONSTRAINT_NAME, tablename AS TABLE_NAME from sys.systables t, sys.sysconstraints c, sys.sysschemas s where s.schemaname='" + jdbcCatalogName + "' " + "and t.tableid = c.tableid " + "and t.schemaid=s.schemaid " + "and c.type = 'U'";
                        if (tableName2 != null) {
                            sql = sql + " AND t.tablename = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else if (database instanceof InformixDatabase) {
                        sql = "select sysindexes.idxname, sysindexes.idxtype, systables.tabname from sysindexes, systables where sysindexes.tabid = systables.tabid and sysindexes.idxtype ='U'";
                        if (tableName2 != null) {
                            sql = sql + " AND systables.tabname = '" + database.correctObjectName(tableName2, Table.class) + "'";
                        }
                    } else {
                        if (database instanceof SybaseDatabase) {
                            LogFactory.getLogger().warning("Finding unique constraints not currently supported for Sybase");
                            return null;
                        }
                        if (database instanceof SybaseASADatabase) {
                            sql = "select sysconstraint.constraint_name, sysconstraint.constraint_type, systable.table_name from sysconstraint, systable where sysconstraint.table_object_id = systable.object_id and sysconstraint.constraint_type = 'U'";
                            if (tableName2 != null) {
                                sql = sql + " and systable.table_name = '" + database.correctObjectName(tableName2, Table.class) + "'";
                            }
                        } else {
                            sql = "select CONSTRAINT_NAME, CONSTRAINT_TYPE, TABLE_NAME from " + database.getSystemSchema() + ".constraints " + "where constraint_schema='" + jdbcSchemaName + "' " + "and constraint_catalog='" + jdbcCatalogName + "' " + "and constraint_type='UNIQUE'";
                            if (tableName2 != null) {
                                sql = sql + " and table_name='" + database.correctObjectName(tableName2, Table.class) + "'";
                            }
                        }
                    }
                    return sql;
                }
            });
        }
    }
}

