/*
 * Decompiled with CFR 0.152.
 */
package org.litote.kmongo.util;

import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonReader;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.MongoOperator;
import org.litote.kmongo.id.IdGenerator;
import org.litote.kmongo.id.StringId;
import org.litote.kmongo.id.WrappedObjectId;
import org.litote.kmongo.service.ClassMappingType;
import org.litote.kmongo.util.CollectionNameFormatter;
import org.litote.kmongo.util.KMongoUtil;
import org.litote.kmongo.util.SimpleExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00042\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J/\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u0001H\u001a2\u0006\u0010\u001e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017J\u0018\u0010\"\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00012\b\b\u0002\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J(\u0010'\u001a\u00020#\"\b\b\u0000\u0010(*\u00020\u00012\u0006\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u0017H\u0002J\u0016\u0010+\u001a\u00020\u00012\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017J\u0012\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\u0001J\u0010\u00100\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u0001J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0001J\u0010\u00104\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u00105\u001a\u0002022\u0006\u0010!\u001a\u00020\u00012\b\b\u0002\u00106\u001a\u00020\u0012J\u000e\u00107\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004J&\u00107\u001a\u00020#\"\b\b\u0000\u0010(*\u00020\u00012\u0006\u0010&\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u0017J)\u00108\u001a\b\u0012\u0004\u0012\u0002020\n2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0004092\u0006\u0010\u001e\u001a\u00020\f\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u0002022\u0006\u0010!\u001a\u00020\u00012\b\b\u0002\u00106\u001a\u00020\u0012J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0001JG\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0>0\n\"\b\b\u0000\u0010(*\u00020\u00012\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0004092\u0006\u0010\u001e\u001a\u00020\f2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u0017\u00a2\u0006\u0002\u0010?J.\u0010=\u001a\b\u0012\u0004\u0012\u00020#0>\"\b\b\u0000\u0010(*\u00020\u00012\u0006\u0010@\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006A"}, d2={"Lorg/litote/kmongo/util/KMongoUtil;", "", "()V", "EMPTY_JSON", "", "QUOTE_REPLACE_MATCHER", "kotlin.jvm.PlatformType", "SPACE_REPLACE_PATTERN", "Ljava/util/regex/Pattern;", "UPDATE_OPERATORS", "", "internalDefaultRegistry", "Lorg/bson/codecs/configuration/CodecRegistry;", "getInternalDefaultRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "internalDefaultRegistry$delegate", "Lkotlin/Lazy;", "containsUpdateOperator", "", "map", "", "defaultCollectionName", "clazz", "Lkotlin/reflect/KClass;", "encodeValue", "", "TItem", "writer", "Lorg/bson/BsonDocumentWriter;", "value", "codecRegistry", "(Lorg/bson/BsonDocumentWriter;Ljava/lang/Object;Lorg/bson/codecs/configuration/CodecRegistry;)V", "extractId", "obj", "filterIdToBson", "Lorg/bson/BsonDocument;", "filterNullProperties", "formatJson", "json", "generateIfAbsentAndMayBeMoveId", "T", "document", "type", "generateNewIdforIdClass", "idClass", "getIdBsonValue", "Lorg/bson/BsonValue;", "idValue", "getIdValue", "idFilterQuery", "Lorg/bson/conversions/Bson;", "id", "isJsonArray", "setModifier", "updateOnlyNotNullProperties", "toBson", "toBsonList", "", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;)Ljava/util/List;", "toBsonModifier", "toExtendedJson", "toWriteModel", "Lcom/mongodb/client/model/WriteModel;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;Lkotlin/reflect/KClass;)Ljava/util/List;", "bson", "kmongo-shared"})
public final class KMongoUtil {
    @NotNull
    public static final String EMPTY_JSON = "{}";
    private static final Pattern SPACE_REPLACE_PATTERN;
    private static final String QUOTE_REPLACE_MATCHER;
    private static final List<String> UPDATE_OPERATORS;
    private static final Lazy internalDefaultRegistry$delegate;
    @NotNull
    public static final KMongoUtil INSTANCE;

    private final CodecRegistry getInternalDefaultRegistry() {
        Lazy lazy = internalDefaultRegistry$delegate;
        KMongoUtil kMongoUtil = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CodecRegistry)lazy.getValue();
    }

    @NotNull
    public final Object generateNewIdforIdClass(@NotNull KClass<? extends Object> idClass) {
        Object object;
        Intrinsics.checkNotNullParameter(idClass, (String)"idClass");
        if (Intrinsics.areEqual(idClass, (Object)Reflection.getOrCreateKotlinClass(ObjectId.class))) {
            object = ObjectId.get();
        } else if (Intrinsics.areEqual(idClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = ObjectId.get().toString();
        } else if (Intrinsics.areEqual(idClass, (Object)Reflection.getOrCreateKotlinClass(WrappedObjectId.class))) {
            ObjectId objectId = ObjectId.get();
            Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"ObjectId.get()");
            object = new WrappedObjectId(objectId);
        } else if (Intrinsics.areEqual(idClass, (Object)Reflection.getOrCreateKotlinClass(StringId.class))) {
            String string = ObjectId.get().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ObjectId.get().toString()");
            object = new StringId(string);
        } else if (KClasses.isSubclassOf(idClass, (KClass)Reflection.getOrCreateKotlinClass(Id.class))) {
            object = IdGenerator.Companion.getDefaultGenerator().generateNewId();
        } else {
            String string = "generation for id property type not supported : " + idClass;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"when {\n            idCla\u2026)\n            }\n        }");
        return object;
    }

    @NotNull
    public final BsonDocument toBson(@NotNull String json) {
        BsonDocument bsonDocument;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)json, (Object)EMPTY_JSON)) {
            bsonDocument = new BsonDocument();
        } else {
            BsonDocument bsonDocument2 = BsonDocument.parse((String)json);
            bsonDocument = bsonDocument2;
            Intrinsics.checkNotNullExpressionValue((Object)bsonDocument2, (String)"BsonDocument.parse(json)");
        }
        return bsonDocument;
    }

    @NotNull
    public final <T> BsonDocument toBson(@NotNull String json, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.generateIfAbsentAndMayBeMoveId(this.toBson(json), type);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final <T> BsonDocument generateIfAbsentAndMayBeMoveId(BsonDocument document, KClass<T> type) {
        KProperty1<?, ?> idProperty;
        if (!document.containsKey((Object)"_id") && (idProperty = ClassMappingType.INSTANCE.findIdProperty(type)) != null) {
            BsonValue idValue = (BsonValue)document.get((Object)idProperty.getName());
            if (idValue == null) {
                String toString = idProperty.getReturnType().toString();
                String string = Reflection.getOrCreateKotlinClass(ObjectId.class).getQualifiedName();
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.startsWith$default((String)toString, (String)string, (boolean)false, (int)2, null)) {
                    document.put("_id", (BsonValue)new BsonObjectId(ObjectId.get()));
                } else {
                    String string2 = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
                    Intrinsics.checkNotNull((Object)string2);
                    if (!StringsKt.startsWith$default((String)toString, (String)string2, (boolean)false, (int)2, null)) {
                        String string3 = "generation for id property type not supported : " + idProperty;
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string3.toString());
                    }
                    document.put("_id", (BsonValue)new BsonString(ObjectId.get().toString()));
                }
            } else {
                document.put("_id", idValue);
            }
            if (Intrinsics.areEqual((Object)idProperty.getName(), (Object)"_id") ^ true) {
                document.remove((Object)idProperty.getName());
            }
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bson> toBsonList(@NotNull String[] json, @NotNull CodecRegistry codecRegistry) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
        if (json.length == 1 && this.isJsonArray(json[0])) {
            void $this$mapTo$iv$iv;
            BsonArray bsonArray = new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            Intrinsics.checkNotNullExpressionValue((Object)bsonArray, (String)"BsonArrayCodec(codecRegi\u2026ontext.builder().build())");
            Iterable $this$map$iv = (Iterable)bsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                BsonDocument bsonDocument = (BsonDocument)v1;
                collection.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        } else {
            String[] $this$map$iv = json;
            boolean $i$f$map = false;
            String[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            String[] stringArray = $this$mapTo$iv$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                void it;
                String item$iv$iv;
                String string = item$iv$iv = stringArray[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                BsonDocument bsonDocument = INSTANCE.toBson((String)it);
                collection.add(bsonDocument);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final BsonDocument filterIdToBson(@NotNull Object obj, boolean filterNullProperties) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return ClassMappingType.INSTANCE.filterIdToBson(obj, filterNullProperties);
    }

    public static /* synthetic */ BsonDocument filterIdToBson$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kMongoUtil.filterIdToBson(object, bl);
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String string = SPACE_REPLACE_PATTERN.matcher(json).replaceAll(QUOTE_REPLACE_MATCHER);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SPACE_REPLACE_PATTERN.ma\u2026ll(QUOTE_REPLACE_MATCHER)");
        return string;
    }

    @NotNull
    public final String toExtendedJson(@NotNull Object obj) {
        String string;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof Bson) {
            String string2 = ((Bson)obj).toBsonDocument(Document.class, this.getInternalDefaultRegistry()).toJson();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"obj.toBsonDocument(\n    \u2026ry\n            ).toJson()");
        } else {
            string = ClassMappingType.INSTANCE.toExtendedJson(obj);
        }
        return string;
    }

    private final boolean isJsonArray(String json) {
        String string = json;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (char)'[', (boolean)false, (int)2, null);
    }

    @NotNull
    public final Bson idFilterQuery(@NotNull Object id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Bson bson = Filters.eq((String)"_id", (Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)bson, (String)"Filters.eq(\"_id\", id)");
        return bson;
    }

    private final boolean containsUpdateOperator(Map<?, ?> map) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = UPDATE_OPERATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Map<?, ?> map2 = map;
                    boolean bl3 = false;
                    Map<?, ?> map3 = map2;
                    boolean bl4 = false;
                    if (!map3.containsKey(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Bson toBsonModifier(@NotNull Object obj, boolean updateOnlyNotNullProperties) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Object object = obj;
        return object instanceof Bson ? (Bson)obj : (object instanceof String ? (Bson)this.toBson((String)obj) : this.setModifier(obj, updateOnlyNotNullProperties));
    }

    public static /* synthetic */ Bson toBsonModifier$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kMongoUtil.toBsonModifier(object, bl);
    }

    @NotNull
    public final Bson setModifier(@NotNull Object obj, boolean updateOnlyNotNullProperties) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj instanceof Map && this.containsUpdateOperator((Map)obj) ? (Bson)this.toBson(this.toExtendedJson(obj)) : (Bson)new SimpleExpression<BsonDocument>(String.valueOf((Object)MongoOperator.set), this.filterIdToBson(obj, updateOnlyNotNullProperties));
    }

    public static /* synthetic */ Bson setModifier$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kMongoUtil.setModifier(object, bl);
    }

    @NotNull
    public final Object extractId(@NotNull Object obj, @NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (obj instanceof Map) {
            Object object = (Map)obj;
            String string = "_id";
            boolean bl = false;
            Object v = object.get(string);
            if (v == null) {
                object = "_id is null";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            return v;
        }
        KProperty1<?, ?> idProperty = ClassMappingType.INSTANCE.findIdProperty(clazz);
        if (idProperty == null) {
            throw (Throwable)new IllegalArgumentException(obj + " has to contain _id field");
        }
        Object obj2 = ClassMappingType.INSTANCE.getIdValue(idProperty, obj);
        if (obj2 == null) {
            String string = "id is null";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return obj2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<WriteModel<BsonDocument>> toWriteModel(@NotNull String[] json, @NotNull CodecRegistry codecRegistry, @NotNull KClass<T> type) {
        List list;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        if (json.length == 1 && this.isJsonArray(json[0])) {
            void $this$mapTo$iv$iv;
            BsonArray bsonArray = new BsonArrayCodec(codecRegistry).decode((BsonReader)new JsonReader(json[0]), DecoderContext.builder().build());
            Intrinsics.checkNotNullExpressionValue((Object)bsonArray, (String)"BsonArrayCodec(codecRegi\u2026ontext.builder().build())");
            Iterable $this$map$iv = (Iterable)bsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.bson.BsonDocument");
                }
                WriteModel<BsonDocument> writeModel = INSTANCE.toWriteModel((BsonDocument)v1, type);
                collection.add(writeModel);
            }
            list = (List)destination$iv$iv;
        } else {
            String[] $this$map$iv = json;
            boolean $i$f$map = false;
            String[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            String[] stringArray = $this$mapTo$iv$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                void it;
                String item$iv$iv;
                String string = item$iv$iv = stringArray[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                WriteModel<BsonDocument> writeModel = INSTANCE.toWriteModel(INSTANCE.toBson((String)it), type);
                collection.add(writeModel);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final <T> WriteModel<BsonDocument> toWriteModel(BsonDocument bson, KClass<T> type) {
        if (bson.containsKey((Object)"insertOne")) {
            BsonDocument bsonDocument = bson.getDocument((Object)"insertOne");
            Intrinsics.checkNotNullExpressionValue((Object)bsonDocument, (String)"bson.getDocument(\"insertOne\")");
            return (WriteModel)new InsertOneModel((Object)this.generateIfAbsentAndMayBeMoveId(bsonDocument, type));
        }
        if (bson.containsKey((Object)"updateOne")) {
            BsonDocument updateOne = bson.getDocument((Object)"updateOne");
            Bson bson2 = (Bson)updateOne.getDocument((Object)"filter");
            Bson bson3 = (Bson)updateOne.getDocument((Object)"update");
            UpdateOptions updateOptions = new UpdateOptions();
            BsonBoolean bsonBoolean = updateOne.getBoolean((Object)"upsert", BsonBoolean.FALSE);
            Intrinsics.checkNotNullExpressionValue((Object)bsonBoolean, (String)"updateOne.getBoolean(\"upsert\", BsonBoolean.FALSE)");
            return (WriteModel)new UpdateOneModel(bson2, bson3, updateOptions.upsert(bsonBoolean.getValue()));
        }
        if (bson.containsKey((Object)"updateMany")) {
            BsonDocument updateMany = bson.getDocument((Object)"updateMany");
            Bson bson4 = (Bson)updateMany.getDocument((Object)"filter");
            Bson bson5 = (Bson)updateMany.getDocument((Object)"update");
            UpdateOptions updateOptions = new UpdateOptions();
            BsonBoolean bsonBoolean = updateMany.getBoolean((Object)"upsert", BsonBoolean.FALSE);
            Intrinsics.checkNotNullExpressionValue((Object)bsonBoolean, (String)"updateMany.getBoolean(\"upsert\", BsonBoolean.FALSE)");
            return (WriteModel)new UpdateManyModel(bson4, bson5, updateOptions.upsert(bsonBoolean.getValue()));
        }
        if (bson.containsKey((Object)"replaceOne")) {
            BsonDocument replaceOne = bson.getDocument((Object)"replaceOne");
            Bson bson6 = (Bson)replaceOne.getDocument((Object)"filter");
            BsonDocument bsonDocument = replaceOne.getDocument((Object)"replacement");
            ReplaceOptions replaceOptions = new ReplaceOptions();
            BsonBoolean bsonBoolean = replaceOne.getBoolean((Object)"upsert", BsonBoolean.FALSE);
            Intrinsics.checkNotNullExpressionValue((Object)bsonBoolean, (String)"replaceOne.getBoolean(\"upsert\", BsonBoolean.FALSE)");
            return (WriteModel)new ReplaceOneModel(bson6, (Object)bsonDocument, replaceOptions.upsert(bsonBoolean.getValue()));
        }
        if (bson.containsKey((Object)"deleteOne")) {
            BsonDocument deleteOne = bson.getDocument((Object)"deleteOne");
            return (WriteModel)new DeleteOneModel((Bson)deleteOne.getDocument((Object)"filter"));
        }
        if (bson.containsKey((Object)"deleteMany")) {
            BsonDocument deleteMany = bson.getDocument((Object)"deleteMany");
            return (WriteModel)new DeleteManyModel((Bson)deleteMany.getDocument((Object)"filter"));
        }
        throw (Throwable)new IllegalArgumentException("unknown write model : " + bson);
    }

    @NotNull
    public final String defaultCollectionName(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (String)CollectionNameFormatter.INSTANCE.getDefaultCollectionNameBuilder().invoke(clazz);
    }

    @Nullable
    public final Object getIdValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof Map) {
            Map map = (Map)value;
            String string = "_id";
            boolean bl = false;
            return map.get(string);
        }
        KProperty1<?, ?> idProperty = ClassMappingType.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(value.getClass()));
        return idProperty == null ? null : ClassMappingType.INSTANCE.getIdValue(idProperty, value);
    }

    public final <TItem> void encodeValue(@NotNull BsonDocumentWriter writer, @Nullable TItem value, @NotNull CodecRegistry codecRegistry) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)codecRegistry, (String)"codecRegistry");
        TItem TItem = value;
        if (TItem == null) {
            writer.writeNull();
        } else if (TItem instanceof Bson) {
            Codec codec = codecRegistry.get(BsonDocument.class);
            if (codec == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bson.codecs.Encoder<kotlin.Any>");
            }
            ((Encoder)codec).encode((BsonWriter)writer, (Object)((Bson)value).toBsonDocument(BsonDocument.class, codecRegistry), EncoderContext.builder().build());
        } else {
            Class<?> clazz = value.getClass();
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<TItem>");
            }
            Codec codec = codecRegistry.get(clazz);
            if (codec == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.bson.codecs.Encoder<TItem>");
            }
            ((Encoder)codec).encode((BsonWriter)writer, value, EncoderContext.builder().build());
        }
    }

    @Nullable
    public final BsonValue getIdBsonValue(@Nullable Object idValue) {
        Object object = idValue;
        return object == null ? null : (object instanceof ObjectId ? (BsonValue)new BsonObjectId((ObjectId)idValue) : (object instanceof String ? (BsonValue)new BsonString((String)idValue) : (object instanceof Double ? (BsonValue)new BsonDouble(((Number)idValue).doubleValue()) : (object instanceof Integer ? (BsonValue)new BsonInt32(((Number)idValue).intValue()) : (object instanceof Long ? (BsonValue)new BsonInt64(((Number)idValue).longValue()) : (BsonValue)this.toBson(this.toExtendedJson(idValue)))))));
    }

    private KMongoUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        KMongoUtil kMongoUtil;
        INSTANCE = kMongoUtil = new KMongoUtil();
        SPACE_REPLACE_PATTERN = Pattern.compile("\\$\\s+");
        QUOTE_REPLACE_MATCHER = Matcher.quoteReplacement("$");
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new MongoOperator[]{MongoOperator.inc, MongoOperator.mul, MongoOperator.rename, MongoOperator.setOnInsert, MongoOperator.set, MongoOperator.unset, MongoOperator.min, MongoOperator.max, MongoOperator.currentDate, MongoOperator.addToSet, MongoOperator.pop, MongoOperator.pull, MongoOperator.push, MongoOperator.pullAll, MongoOperator.bit});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MongoOperator mongoOperator = (MongoOperator)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.toString();
            collection.add(string);
        }
        UPDATE_OPERATORS = (List)destination$iv$iv;
        internalDefaultRegistry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)internalDefaultRegistry.2.INSTANCE);
    }
}

