/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.security;

import com.google.common.base.Joiner;
import org.opengis.feature.simple.SimpleFeature;

public class SecurityUtils {
    public static final String FEATURE_VISIBILITY = "geomesa.feature.visibility";

    public static SimpleFeature setFeatureVisibility(SimpleFeature feature, String visibility2) {
        String value2 = null;
        if (visibility2 != null) {
            value2 = visibility2.intern();
        }
        feature.getUserData().put(FEATURE_VISIBILITY, value2);
        return feature;
    }

    public static SimpleFeature setFeatureVisibilities(SimpleFeature feature, String ... visibilities) {
        return SecurityUtils.setFeatureVisibility(feature, Joiner.on((String)"&").join((Object[])visibilities));
    }

    public static String getVisibility(SimpleFeature feature) {
        return (String)feature.getUserData().get(FEATURE_VISIBILITY);
    }

    public static void copyVisibility(SimpleFeature source, SimpleFeature dest) {
        SecurityUtils.setFeatureVisibility(dest, SecurityUtils.getVisibility(source));
    }
}

