/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetprocessor;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.AjaxBehaviorListener;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.util.CollectionUtils;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxProcessor
implements WidgetProcessor<UIComponent, UIMetawidget> {
    @Override
    public UIComponent processWidget(UIComponent component, String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if (component instanceof UIStub && component.getChildCount() == 0) {
            return component;
        }
        if (!(component instanceof ClientBehaviorHolder)) {
            return component;
        }
        String ajaxEvent = attributes.get("faces-ajax-event");
        if (ajaxEvent != null) {
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)component;
            if ("".equals(ajaxEvent)) {
                ajaxEvent = clientBehaviorHolder.getDefaultEventName();
            } else {
                Collection eventNames = clientBehaviorHolder.getEventNames();
                if (eventNames == null || !eventNames.contains(ajaxEvent)) {
                    throw WidgetProcessorException.newException("'" + ajaxEvent + "' not a valid event for " + component.getClass() + ". Must be one of " + CollectionUtils.toString(eventNames));
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            AjaxBehavior ajaxBehaviour = (AjaxBehavior)context.getApplication().createBehavior("javax.faces.behavior.Ajax");
            clientBehaviorHolder.addClientBehavior(ajaxEvent, (ClientBehavior)ajaxBehaviour);
            ajaxBehaviour.setExecute(CollectionUtils.newArrayList(metawidget.getClientId()));
            ajaxBehaviour.setRender(ajaxBehaviour.getExecute());
            String ajaxListener = attributes.get("faces-ajax-action");
            if (ajaxListener != null) {
                ajaxBehaviour.addAjaxBehaviorListener((AjaxBehaviorListener)new AjaxBehaviorListenerImpl(ajaxListener));
            }
        }
        return component;
    }

    static class AjaxBehaviorListenerImpl
    implements AjaxBehaviorListener,
    Serializable {
        MethodExpression mListenerMethod;

        public AjaxBehaviorListenerImpl() {
        }

        public AjaxBehaviorListenerImpl(String listenerExpression) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application application = context.getApplication();
            this.mListenerMethod = application.getExpressionFactory().createMethodExpression(context.getELContext(), listenerExpression, Object.class, new Class[]{AjaxBehaviorEvent.class});
        }

        public void processAjaxBehavior(AjaxBehaviorEvent event) {
            this.mListenerMethod.invoke(FacesContext.getCurrentInstance().getELContext(), new Object[]{event});
        }
    }
}

