/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.groovy;

import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.reflection.CachedField;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.groovy.GroovyPropertyStyleConfig;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPropertyStyle
extends BasePropertyStyle {
    public GroovyPropertyStyle() {
        this(new GroovyPropertyStyleConfig());
    }

    public GroovyPropertyStyle(GroovyPropertyStyleConfig config) {
        super(config);
    }

    @Override
    protected Map<String, Property> inspectProperties(String type) {
        TreeMap<String, Property> propertiesToReturn = CollectionUtils.newTreeMap(StringUtils.CASE_INSENSITIVE_COMPARATOR);
        Class<?> clazz = ClassUtils.niceForName(type);
        if (clazz == null) {
            return propertiesToReturn;
        }
        List properties = GroovySystem.getMetaClassRegistry().getMetaClass(clazz).getProperties();
        for (MetaProperty property : properties) {
            Class<?> declaringClass;
            if (!(property instanceof MetaBeanProperty)) continue;
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)property;
            String propertyName = metaBeanProperty.getName();
            Class propertyType = metaBeanProperty.getType();
            if (!Modifier.isPublic(metaBeanProperty.getModifiers()) || this.isExcluded(declaringClass = metaBeanProperty.getGetter() != null ? ClassUtils.niceForName(metaBeanProperty.getGetter().getDeclaringClass().getName()) : (metaBeanProperty.getSetter() != null ? ClassUtils.niceForName(metaBeanProperty.getSetter().getDeclaringClass().getName()) : clazz), propertyName, propertyType)) continue;
            propertiesToReturn.put(propertyName, new GroovyProperty((MetaBeanProperty)property, clazz));
        }
        return propertiesToReturn;
    }

    @Override
    protected boolean isExcludedBaseType(Class<?> classToExclude) {
        if (classToExclude == null) {
            return false;
        }
        String className = classToExclude.getName();
        if (className.startsWith("org.groovy.")) {
            return true;
        }
        return super.isExcludedBaseType(classToExclude);
    }

    @Override
    protected boolean isExcludedName(String name) {
        if ("metaClass".equals(name)) {
            return true;
        }
        return super.isExcludedName(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyProperty
    extends BaseProperty {
        private MetaBeanProperty mProperty;
        private Field mField;
        private Method mGetterMethod;
        private Method mSetterMethod;

        public GroovyProperty(MetaBeanProperty property, Class<?> javaClass) {
            super(property.getName(), property.getType().getName());
            this.mProperty = property;
            try {
                MetaMethod setterMethod;
                MetaMethod getterMethod;
                CachedField field = this.mProperty.getField();
                if (field != null) {
                    this.mField = field.field;
                }
                if ((getterMethod = this.mProperty.getGetter()) != null) {
                    this.mGetterMethod = javaClass.getMethod(getterMethod.getName(), new Class[0]);
                }
                if ((setterMethod = this.mProperty.getSetter()) != null) {
                    this.mSetterMethod = javaClass.getMethod(setterMethod.getName(), setterMethod.getNativeParameterTypes());
                }
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isReadable() {
            return this.mProperty.getGetter() != null;
        }

        @Override
        public Object read(Object obj) {
            try {
                return this.mProperty.getProperty(obj);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mProperty.getSetter() != null;
        }

        @Override
        public void write(Object obj, Object value) {
            try {
                this.mProperty.setProperty(obj, value);
            }
            catch (Exception e) {
                throw InspectorException.newException(e);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotation) {
            if (this.mField != null) {
                return this.mField.getAnnotation(annotation);
            }
            if (this.mGetterMethod != null) {
                return this.mGetterMethod.getAnnotation(annotation);
            }
            if (this.mSetterMethod != null) {
                return this.mSetterMethod.getAnnotation(annotation);
            }
            throw InspectorException.newException("Don't know how to getAnnotation from " + this.getName());
        }

        @Override
        public String getGenericType() {
            if (this.mField != null) {
                return ClassUtils.getGenericTypeAsString(this.mField.getGenericType());
            }
            if (this.mGetterMethod != null) {
                return ClassUtils.getGenericTypeAsString(this.mGetterMethod.getGenericReturnType());
            }
            if (this.mSetterMethod != null) {
                return ClassUtils.getGenericTypeAsString(this.mSetterMethod.getGenericParameterTypes()[0]);
            }
            throw InspectorException.newException("Don't know how to getGenericType from " + this.getName());
        }
    }
}

