/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.statically.html.widgetbuilder;

import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.metawidget.statically.StaticXmlMetawidget;
import org.metawidget.statically.StaticXmlStub;
import org.metawidget.statically.StaticXmlWidget;
import org.metawidget.statically.html.StaticHtmlMetawidget;
import org.metawidget.statically.html.widgetbuilder.HtmlInput;
import org.metawidget.statically.html.widgetbuilder.HtmlOption;
import org.metawidget.statically.html.widgetbuilder.HtmlSelect;
import org.metawidget.statically.html.widgetbuilder.HtmlTable;
import org.metawidget.statically.html.widgetbuilder.HtmlTableBody;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHead;
import org.metawidget.statically.html.widgetbuilder.HtmlTableHeader;
import org.metawidget.statically.html.widgetbuilder.HtmlTableRow;
import org.metawidget.statically.html.widgetbuilder.HtmlTextarea;
import org.metawidget.statically.html.widgetbuilder.HtmlWidgetBuilderConfig;
import org.metawidget.statically.html.widgetprocessor.IdProcessor;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<StaticXmlWidget, StaticHtmlMetawidget> {
    private final int mMaximumColumnsInDataTable;

    public HtmlWidgetBuilder() {
        this(new HtmlWidgetBuilderConfig());
    }

    public HtmlWidgetBuilder(HtmlWidgetBuilderConfig config) {
        this.mMaximumColumnsInDataTable = config.getMaximumColumnsInDataTable();
    }

    @Override
    public StaticXmlWidget buildWidget(String elementName, Map<String, String> attributes, StaticHtmlMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return new StaticXmlStub();
        }
        if ("action".equals(elementName)) {
            return new StaticXmlStub();
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, String.class);
        if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
            return this.createHtmlCheckbox();
        }
        String lookup = attributes.get("lookup");
        if (lookup != null && !"".equals(lookup)) {
            HtmlSelect select = new HtmlSelect();
            this.addSelectItems(select, CollectionUtils.fromString(lookup), CollectionUtils.fromString(attributes.get("lookup-labels")), attributes);
            return select;
        }
        if (clazz != null) {
            String minimumValue = attributes.get("minimum-value");
            String maximumValue = attributes.get("maximum-value");
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return this.createHtmlCheckbox();
                }
                if (Character.TYPE.equals(clazz)) {
                    attributes.put("maximum-length", "1");
                    return this.createHtmlInputText(attributes);
                }
                HtmlInput inputNumber = this.createHtmlInputNumber();
                if (!"".equals(minimumValue)) {
                    inputNumber.putAttribute("min", minimumValue);
                }
                if (!"".equals(maximumValue)) {
                    inputNumber.putAttribute("max", maximumValue);
                }
                return inputNumber;
            }
            if (String.class.equals(clazz)) {
                if ("true".equals(attributes.get("large"))) {
                    return this.createHtmlTextareaTag(attributes);
                }
                if ("true".equals(attributes.get("masked"))) {
                    HtmlInput secret = this.createHtmlInputText(attributes);
                    secret.putAttribute("type", "secret");
                    return secret;
                }
                if ("true".equals(attributes.get("validation-email"))) {
                    HtmlInput email = this.createHtmlInputText(attributes);
                    email.putAttribute("type", "email");
                    return email;
                }
                HtmlInput text = this.createHtmlInputText(attributes);
                text.putAttribute("pattern", attributes.get("validation-pattern"));
                return text;
            }
            if (Character.class.equals(clazz)) {
                attributes.put("maximum-length", "1");
                return this.createHtmlInputText(attributes);
            }
            if (Date.class.equals(clazz)) {
                return this.createHtmlInputDate();
            }
            if (Number.class.isAssignableFrom(clazz)) {
                HtmlInput inputNumber = this.createHtmlInputNumber();
                if (minimumValue != null) {
                    inputNumber.putAttribute("min", minimumValue);
                }
                if (maximumValue != null) {
                    inputNumber.putAttribute("max", maximumValue);
                }
                return inputNumber;
            }
            if (Color.class.equals(clazz)) {
                return this.createHtmlInputColor();
            }
            if (Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return this.createDataTableComponent(elementName, attributes, metawidget);
            }
        }
        if ("true".equals(attributes.get("dont-expand"))) {
            return this.createHtmlInputText(attributes);
        }
        return null;
    }

    protected StaticXmlWidget createDataTableComponent(String elementName, Map<String, String> attributes, StaticHtmlMetawidget metawidget) {
        HtmlTable table = new HtmlTable();
        HtmlTableHead tableHead = new HtmlTableHead();
        table.getChildren().add(tableHead);
        tableHead.getChildren().add(new HtmlTableRow());
        HtmlTableBody body = new HtmlTableBody();
        table.getChildren().add(body);
        String componentType = WidgetBuilderUtils.getComponentType(attributes);
        String inspectedType = null;
        if (componentType != null) {
            inspectedType = metawidget.inspect(null, componentType, null);
        }
        if (inspectedType == null) {
            HashMap<String, String> columnAttributes = CollectionUtils.newHashMap();
            columnAttributes.put("name", attributes.get("name"));
            this.addColumnHeader(table, columnAttributes, metawidget);
        } else {
            IdProcessor processor = metawidget.getWidgetProcessor(IdProcessor.class);
            if (processor != null) {
                processor.processWidget(table, elementName, attributes, metawidget);
            }
            Element root = XmlUtils.documentFromString(inspectedType).getDocumentElement();
            NodeList elements = root.getFirstChild().getChildNodes();
            this.addColumnComponents(table, elements, metawidget);
        }
        return table;
    }

    protected void addColumnComponents(HtmlTable table, NodeList elements, StaticXmlMetawidget metawidget) {
        boolean onlyRequired = true;
        HtmlTableRow headerRow = (HtmlTableRow)table.getChildren().get(0).getChildren().get(0);
        while (true) {
            for (int i = 0; i < elements.getLength(); ++i) {
                Element element;
                Node node = elements.item(i);
                if (!(node instanceof Element) || "action".equals((element = (Element)node).getNodeName()) || "true".equals(element.getAttribute("hidden")) || onlyRequired && !"true".equals(element.getAttribute("required"))) continue;
                this.addColumnHeader(table, XmlUtils.getAttributesAsMap(element), metawidget);
                if (headerRow.getChildren().size() == this.mMaximumColumnsInDataTable) break;
            }
            if (!headerRow.getChildren().isEmpty() || !onlyRequired) break;
            onlyRequired = false;
        }
    }

    protected void addColumnHeader(HtmlTable table, Map<String, String> attributes, StaticXmlMetawidget metawidget) {
        HtmlTableHeader header = new HtmlTableHeader();
        String id = attributes.get("name");
        String tableId = table.getAttribute("id");
        if (tableId != null) {
            id = tableId + '-' + id;
        }
        header.putAttribute("id", id);
        header.setTextContent(metawidget.getLabelString(attributes));
        table.getChildren().get(0).getChildren().get(0).getChildren().add(header);
    }

    protected void addSelectItems(HtmlSelect select, String valueExpression, Map<String, String> attributes) {
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        this.addSelectItem(select, valueExpression, null);
    }

    protected void addSelectItems(HtmlSelect select, List<String> values, List<String> labels, Map<String, String> attributes) {
        if (values == null) {
            return;
        }
        if (WidgetBuilderUtils.needsEmptyLookupItem(attributes)) {
            this.addSelectItem(select, "", null);
        }
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            String value = values.get(i);
            String label = null;
            if (labels != null && !labels.isEmpty()) {
                label = labels.get(i);
            }
            this.addSelectItem(select, value, label);
        }
    }

    private HtmlInput createHtmlInputText(Map<String, String> attributes) {
        HtmlInput input = new HtmlInput();
        input.putAttribute("type", "text");
        if (!"".equals(attributes.get("maximum-length"))) {
            input.putAttribute("maxlength", attributes.get("maximum-length"));
        }
        return input;
    }

    private StaticXmlWidget createHtmlCheckbox() {
        HtmlInput checkbox = new HtmlInput();
        checkbox.putAttribute("type", "checkbox");
        return checkbox;
    }

    private HtmlInput createHtmlInputDate() {
        HtmlInput input = new HtmlInput();
        input.putAttribute("type", "date");
        return input;
    }

    private HtmlInput createHtmlInputNumber() {
        HtmlInput input = new HtmlInput();
        input.putAttribute("type", "number");
        return input;
    }

    private HtmlInput createHtmlInputColor() {
        HtmlInput input = new HtmlInput();
        input.putAttribute("type", "color");
        return input;
    }

    private StaticXmlWidget createHtmlTextareaTag(Map<String, String> attributes) {
        String rows;
        HtmlTextarea textarea = new HtmlTextarea();
        String cols = attributes.get("cols");
        if (cols != null) {
            textarea.putAttribute("cols", cols);
        }
        if ((rows = attributes.get("rows")) != null) {
            textarea.putAttribute("rows", rows);
        }
        return textarea;
    }

    private void addSelectItem(HtmlSelect select, String value, String label) {
        HtmlOption selectItem = new HtmlOption();
        selectItem.putAttribute("value", value);
        if (label != null) {
            selectItem.setTextContent(label);
        }
        select.getChildren().add(selectItem);
    }
}

