/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.JWKSetCacheService;
import org.mitre.jwt.signer.service.impl.SymmetricKeyJWTValidatorCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.TargetLinkURIChecker;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.AuthRequestOptionsService;
import org.mitre.openid.connect.client.service.AuthRequestUrlBuilder;
import org.mitre.openid.connect.client.service.ClientConfigurationService;
import org.mitre.openid.connect.client.service.IssuerService;
import org.mitre.openid.connect.client.service.ServerConfigurationService;
import org.mitre.openid.connect.client.service.impl.StaticAuthRequestOptionsService;
import org.mitre.openid.connect.config.ServerConfiguration;
import org.mitre.openid.connect.model.PendingOIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class OIDCAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    protected static final String REDIRECT_URI_SESION_VARIABLE = "redirect_uri";
    protected static final String STATE_SESSION_VARIABLE = "state";
    protected static final String NONCE_SESSION_VARIABLE = "nonce";
    protected static final String ISSUER_SESSION_VARIABLE = "issuer";
    protected static final String TARGET_SESSION_VARIABLE = "target";
    protected static final int HTTP_SOCKET_TIMEOUT = 30000;
    protected static final String FILTER_PROCESSES_URL = "/openid_connect_login";
    private int timeSkewAllowance = 300;
    @Autowired(required=false)
    private JWKSetCacheService validationServices;
    @Autowired(required=false)
    private SymmetricKeyJWTValidatorCacheService symmetricCacheService;
    @Autowired
    private JWTSigningAndValidationService authenticationSignerService;
    private IssuerService issuerService;
    private ServerConfigurationService servers;
    private ClientConfigurationService clients;
    private AuthRequestOptionsService authOptions = new StaticAuthRequestOptionsService();
    private AuthRequestUrlBuilder authRequestBuilder;
    private TargetLinkURIAuthenticationSuccessHandler targetSuccessHandler = new TargetLinkURIAuthenticationSuccessHandler();
    private TargetLinkURIChecker deepLinkFilter;
    protected int httpSocketTimeout = 30000;

    public OIDCAuthenticationFilter() {
        super(FILTER_PROCESSES_URL);
        this.targetSuccessHandler.passthrough = super.getSuccessHandler();
        super.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.targetSuccessHandler);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.validationServices == null) {
            this.validationServices = new JWKSetCacheService();
        }
        if (this.symmetricCacheService == null) {
            this.symmetricCacheService = new SymmetricKeyJWTValidatorCacheService();
        }
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        if (!Strings.isNullOrEmpty((String)request.getParameter("error"))) {
            this.handleError(request, response);
            return null;
        }
        if (!Strings.isNullOrEmpty((String)request.getParameter("code"))) {
            Authentication auth = this.handleAuthorizationCodeResponse(request, response);
            return auth;
        }
        this.handleAuthorizationRequest(request, response);
        return null;
    }

    protected void handleAuthorizationRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession();
        IssuerServiceResponse issResp = this.issuerService.getIssuer(request);
        if (issResp == null) {
            this.logger.error((Object)"Null issuer response returned from service.");
            throw new AuthenticationServiceException("No issuer found.");
        }
        if (issResp.shouldRedirect()) {
            response.sendRedirect(issResp.getRedirectUrl());
        } else {
            String issuer = issResp.getIssuer();
            if (!Strings.isNullOrEmpty((String)issResp.getTargetLinkUri())) {
                session.setAttribute(TARGET_SESSION_VARIABLE, (Object)issResp.getTargetLinkUri());
            }
            if (Strings.isNullOrEmpty((String)issuer)) {
                this.logger.error((Object)("No issuer found: " + issuer));
                throw new AuthenticationServiceException("No issuer found: " + issuer);
            }
            ServerConfiguration serverConfig = this.servers.getServerConfiguration(issuer);
            if (serverConfig == null) {
                this.logger.error((Object)("No server configuration found for issuer: " + issuer));
                throw new AuthenticationServiceException("No server configuration found for issuer: " + issuer);
            }
            session.setAttribute(ISSUER_SESSION_VARIABLE, (Object)serverConfig.getIssuer());
            RegisteredClient clientConfig = this.clients.getClientConfiguration(serverConfig);
            if (clientConfig == null) {
                this.logger.error((Object)("No client configuration found for issuer: " + issuer));
                throw new AuthenticationServiceException("No client configuration found for issuer: " + issuer);
            }
            String redirectUri = null;
            redirectUri = clientConfig.getRegisteredRedirectUri() != null && clientConfig.getRegisteredRedirectUri().size() == 1 ? (String)Iterables.getOnlyElement((Iterable)clientConfig.getRegisteredRedirectUri()) : request.getRequestURL().toString();
            session.setAttribute(REDIRECT_URI_SESION_VARIABLE, (Object)redirectUri);
            String nonce = OIDCAuthenticationFilter.createNonce(session);
            String state = OIDCAuthenticationFilter.createState(session);
            Map<String, String> options = this.authOptions.getOptions(serverConfig, clientConfig, request);
            String authRequest = this.authRequestBuilder.buildAuthRequestUrl(serverConfig, clientConfig, redirectUri, nonce, state, options, issResp.getLoginHint());
            this.logger.debug((Object)("Auth Request:  " + authRequest));
            response.sendRedirect(authRequest);
        }
    }

    protected Authentication handleAuthorizationCodeResponse(HttpServletRequest request, HttpServletResponse response) {
        RestTemplate restTemplate;
        String state;
        String authorizationCode = request.getParameter("code");
        HttpSession session = request.getSession();
        String storedState = OIDCAuthenticationFilter.getStoredState(session);
        if (!Strings.isNullOrEmpty((String)storedState) && !storedState.equals(state = request.getParameter(STATE_SESSION_VARIABLE))) {
            throw new AuthenticationServiceException("State parameter mismatch on return. Expected " + storedState + " got " + state);
        }
        String issuer = OIDCAuthenticationFilter.getStoredSessionString(session, ISSUER_SESSION_VARIABLE);
        ServerConfiguration serverConfig = this.servers.getServerConfiguration(issuer);
        final RegisteredClient clientConfig = this.clients.getClientConfiguration(serverConfig);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"authorization_code");
        form.add((Object)"code", (Object)authorizationCode);
        form.setAll(this.authOptions.getTokenOptions(serverConfig, clientConfig, request));
        String redirectUri = OIDCAuthenticationFilter.getStoredSessionString(session, REDIRECT_URI_SESION_VARIABLE);
        if (redirectUri != null) {
            form.add((Object)REDIRECT_URI_SESION_VARIABLE, (Object)redirectUri);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(this.httpSocketTimeout).build()).build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        if (ClientDetailsEntity.AuthMethod.SECRET_BASIC.equals((Object)clientConfig.getTokenEndpointAuthMethod())) {
            restTemplate = new RestTemplate((ClientHttpRequestFactory)factory){

                protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
                    ClientHttpRequest httpRequest = super.createRequest(url, method);
                    httpRequest.getHeaders().add("Authorization", String.format("Basic %s", Base64.encode((String)String.format("%s:%s", UriUtils.encodePathSegment((String)clientConfig.getClientId(), (String)"UTF-8"), UriUtils.encodePathSegment((String)clientConfig.getClientSecret(), (String)"UTF-8")))));
                    return httpRequest;
                }
            };
        } else {
            restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
            if (ClientDetailsEntity.AuthMethod.SECRET_JWT.equals((Object)clientConfig.getTokenEndpointAuthMethod()) || ClientDetailsEntity.AuthMethod.PRIVATE_KEY.equals((Object)clientConfig.getTokenEndpointAuthMethod())) {
                JWTSigningAndValidationService signer = null;
                JWSAlgorithm alg = clientConfig.getTokenEndpointAuthSigningAlg();
                if (ClientDetailsEntity.AuthMethod.SECRET_JWT.equals((Object)clientConfig.getTokenEndpointAuthMethod()) && (alg.equals((Object)JWSAlgorithm.HS256) || alg.equals((Object)JWSAlgorithm.HS384) || alg.equals((Object)JWSAlgorithm.HS512))) {
                    signer = this.symmetricCacheService.getSymmetricValidtor(clientConfig.getClient());
                } else if (ClientDetailsEntity.AuthMethod.PRIVATE_KEY.equals((Object)clientConfig.getTokenEndpointAuthMethod())) {
                    signer = this.authenticationSignerService;
                    if (alg == null) {
                        alg = this.authenticationSignerService.getDefaultSigningAlgorithm();
                    }
                }
                if (signer == null) {
                    throw new AuthenticationServiceException("Couldn't find required signer service for use with private key auth.");
                }
                JWTClaimsSet claimsSet = new JWTClaimsSet();
                claimsSet.setIssuer(clientConfig.getClientId());
                claimsSet.setSubject(clientConfig.getClientId());
                claimsSet.setAudience((List)Lists.newArrayList((Object[])new String[]{serverConfig.getTokenEndpointUri()}));
                Date exp = new Date(System.currentTimeMillis() + 60000L);
                claimsSet.setExpirationTime(exp);
                Date now = new Date(System.currentTimeMillis());
                claimsSet.setIssueTime(now);
                claimsSet.setNotBeforeTime(now);
                SignedJWT jwt = new SignedJWT(new JWSHeader(alg), (ReadOnlyJWTClaimsSet)claimsSet);
                signer.signJwt(jwt, alg);
                form.add((Object)"client_assertion_type", (Object)"urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
                form.add((Object)"client_assertion", (Object)jwt.serialize());
            } else {
                form.add((Object)"client_id", (Object)clientConfig.getClientId());
                form.add((Object)"client_secret", (Object)clientConfig.getClientSecret());
            }
        }
        this.logger.debug((Object)("tokenEndpointURI = " + serverConfig.getTokenEndpointUri()));
        this.logger.debug((Object)("form = " + form));
        String jsonString = null;
        try {
            jsonString = (String)restTemplate.postForObject(serverConfig.getTokenEndpointUri(), (Object)form, String.class, new Object[0]);
        }
        catch (RestClientException e) {
            this.logger.error((Object)("Token Endpoint error response:  " + e.getMessage()));
            throw new AuthenticationServiceException("Unable to obtain Access Token: " + e.getMessage());
        }
        this.logger.debug((Object)("from TokenEndpoint jsonString = " + jsonString));
        JsonElement jsonRoot = new JsonParser().parse(jsonString);
        if (!jsonRoot.isJsonObject()) {
            throw new AuthenticationServiceException("Token Endpoint did not return a JSON object: " + jsonRoot);
        }
        JsonObject tokenResponse = jsonRoot.getAsJsonObject();
        if (tokenResponse.get("error") != null) {
            String error = tokenResponse.get("error").getAsString();
            this.logger.error((Object)("Token Endpoint returned: " + error));
            throw new AuthenticationServiceException("Unable to obtain Access Token.  Token Endpoint returned: " + error);
        }
        String accessTokenValue = null;
        String idTokenValue = null;
        String refreshTokenValue = null;
        if (!tokenResponse.has("access_token")) {
            throw new AuthenticationServiceException("Token Endpoint did not return an access_token: " + jsonString);
        }
        accessTokenValue = tokenResponse.get("access_token").getAsString();
        if (!tokenResponse.has("id_token")) {
            this.logger.error((Object)"Token Endpoint did not return an id_token");
            throw new AuthenticationServiceException("Token Endpoint did not return an id_token");
        }
        idTokenValue = tokenResponse.get("id_token").getAsString();
        if (tokenResponse.has("refresh_token")) {
            refreshTokenValue = tokenResponse.get("refresh_token").getAsString();
        }
        try {
            JWT idToken = JWTParser.parse((String)idTokenValue);
            ReadOnlyJWTClaimsSet idClaims = idToken.getJWTClaimsSet();
            JWTSigningAndValidationService jwtValidator = null;
            Algorithm tokenAlg = idToken.getHeader().getAlgorithm();
            JWSAlgorithm clientAlg = clientConfig.getIdTokenSignedResponseAlg();
            if (clientAlg != null && !clientAlg.equals((Object)tokenAlg)) {
                throw new AuthenticationServiceException("Token algorithm " + tokenAlg + " does not match expected algorithm " + clientAlg);
            }
            if (idToken instanceof PlainJWT) {
                if (clientAlg == null) {
                    throw new AuthenticationServiceException("Unsigned ID tokens can only be used if explicitly configured in client.");
                }
                if (tokenAlg != null && !tokenAlg.equals((Object)Algorithm.NONE)) {
                    throw new AuthenticationServiceException("Unsigned token received, expected signature with " + tokenAlg);
                }
            } else if (idToken instanceof SignedJWT) {
                SignedJWT signedIdToken = (SignedJWT)idToken;
                jwtValidator = tokenAlg.equals((Object)JWSAlgorithm.HS256) || tokenAlg.equals((Object)JWSAlgorithm.HS384) || tokenAlg.equals((Object)JWSAlgorithm.HS512) ? this.symmetricCacheService.getSymmetricValidtor(clientConfig.getClient()) : this.validationServices.getValidator(serverConfig.getJwksUri());
                if (jwtValidator != null) {
                    if (!jwtValidator.validateSignature(signedIdToken)) {
                        throw new AuthenticationServiceException("Signature validation failed");
                    }
                } else {
                    this.logger.error((Object)"No validation service found. Skipping signature validation");
                    throw new AuthenticationServiceException("Unable to find an appropriate signature validator for ID Token.");
                }
            }
            if (idClaims.getIssuer() == null) {
                throw new AuthenticationServiceException("Id Token Issuer is null");
            }
            if (!idClaims.getIssuer().equals(serverConfig.getIssuer())) {
                throw new AuthenticationServiceException("Issuers do not match, expected " + serverConfig.getIssuer() + " got " + idClaims.getIssuer());
            }
            if (idClaims.getExpirationTime() == null) {
                throw new AuthenticationServiceException("Id Token does not have required expiration claim");
            }
            Date now = new Date(System.currentTimeMillis() - (long)(this.timeSkewAllowance * 1000));
            if (now.after(idClaims.getExpirationTime())) {
                throw new AuthenticationServiceException("Id Token is expired: " + idClaims.getExpirationTime());
            }
            if (idClaims.getNotBeforeTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(idClaims.getNotBeforeTime())) {
                throw new AuthenticationServiceException("Id Token not valid untill: " + idClaims.getNotBeforeTime());
            }
            if (idClaims.getIssueTime() == null) {
                throw new AuthenticationServiceException("Id Token does not have required issued-at claim");
            }
            now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000));
            if (now.before(idClaims.getIssueTime())) {
                throw new AuthenticationServiceException("Id Token was issued in the future: " + idClaims.getIssueTime());
            }
            if (idClaims.getAudience() == null) {
                throw new AuthenticationServiceException("Id token audience is null");
            }
            if (!idClaims.getAudience().contains(clientConfig.getClientId())) {
                throw new AuthenticationServiceException("Audience does not match, expected " + clientConfig.getClientId() + " got " + idClaims.getAudience());
            }
            String nonce = idClaims.getStringClaim(NONCE_SESSION_VARIABLE);
            if (Strings.isNullOrEmpty((String)nonce)) {
                this.logger.error((Object)"ID token did not contain a nonce claim.");
                throw new AuthenticationServiceException("ID token did not contain a nonce claim.");
            }
            String storedNonce = OIDCAuthenticationFilter.getStoredNonce(session);
            if (!nonce.equals(storedNonce)) {
                this.logger.error((Object)("Possible replay attack detected! The comparison of the nonce in the returned ID Token to the session nonce failed. Expected " + storedNonce + " got " + nonce + "."));
                throw new AuthenticationServiceException("Possible replay attack detected! The comparison of the nonce in the returned ID Token to the session nonce failed. Expected " + storedNonce + " got " + nonce + ".");
            }
            PendingOIDCAuthenticationToken token = new PendingOIDCAuthenticationToken(idClaims.getSubject(), idClaims.getIssuer(), serverConfig, idToken, accessTokenValue, refreshTokenValue);
            Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)token);
            return authentication;
        }
        catch (ParseException e) {
            throw new AuthenticationServiceException("Couldn't parse idToken: ", (Throwable)e);
        }
    }

    protected void handleError(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String error = request.getParameter("error");
        String errorDescription = request.getParameter("error_description");
        String errorURI = request.getParameter("error_uri");
        throw new AuthenticationServiceException("Error from Authorization Endpoint: " + error + " " + errorDescription + " " + errorURI);
    }

    private static String getStoredSessionString(HttpSession session, String key) {
        Object o = session.getAttribute(key);
        if (o != null && o instanceof String) {
            return o.toString();
        }
        return null;
    }

    protected static String createNonce(HttpSession session) {
        String nonce = new BigInteger(50, new SecureRandom()).toString(16);
        session.setAttribute(NONCE_SESSION_VARIABLE, (Object)nonce);
        return nonce;
    }

    protected static String getStoredNonce(HttpSession session) {
        return OIDCAuthenticationFilter.getStoredSessionString(session, NONCE_SESSION_VARIABLE);
    }

    protected static String createState(HttpSession session) {
        String state = new BigInteger(50, new SecureRandom()).toString(16);
        session.setAttribute(STATE_SESSION_VARIABLE, (Object)state);
        return state;
    }

    protected static String getStoredState(HttpSession session) {
        return OIDCAuthenticationFilter.getStoredSessionString(session, STATE_SESSION_VARIABLE);
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler successHandler) {
        this.targetSuccessHandler.passthrough = successHandler;
        super.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.targetSuccessHandler);
    }

    public int getTimeSkewAllowance() {
        return this.timeSkewAllowance;
    }

    public void setTimeSkewAllowance(int timeSkewAllowance) {
        this.timeSkewAllowance = timeSkewAllowance;
    }

    public JWKSetCacheService getValidationServices() {
        return this.validationServices;
    }

    public void setValidationServices(JWKSetCacheService validationServices) {
        this.validationServices = validationServices;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.servers;
    }

    public void setServerConfigurationService(ServerConfigurationService servers) {
        this.servers = servers;
    }

    public ClientConfigurationService getClientConfigurationService() {
        return this.clients;
    }

    public void setClientConfigurationService(ClientConfigurationService clients) {
        this.clients = clients;
    }

    public IssuerService getIssuerService() {
        return this.issuerService;
    }

    public void setIssuerService(IssuerService issuerService) {
        this.issuerService = issuerService;
    }

    public AuthRequestUrlBuilder getAuthRequestUrlBuilder() {
        return this.authRequestBuilder;
    }

    public void setAuthRequestUrlBuilder(AuthRequestUrlBuilder authRequestBuilder) {
        this.authRequestBuilder = authRequestBuilder;
    }

    public AuthRequestOptionsService getAuthRequestOptionsService() {
        return this.authOptions;
    }

    public void setAuthRequestOptionsService(AuthRequestOptionsService authOptions) {
        this.authOptions = authOptions;
    }

    public SymmetricKeyJWTValidatorCacheService getSymmetricCacheService() {
        return this.symmetricCacheService;
    }

    public void setSymmetricCacheService(SymmetricKeyJWTValidatorCacheService symmetricCacheService) {
        this.symmetricCacheService = symmetricCacheService;
    }

    public TargetLinkURIAuthenticationSuccessHandler getTargetLinkURIAuthenticationSuccessHandler() {
        return this.targetSuccessHandler;
    }

    public void setTargetLinkURIAuthenticationSuccessHandler(TargetLinkURIAuthenticationSuccessHandler targetSuccessHandler) {
        this.targetSuccessHandler = targetSuccessHandler;
    }

    public TargetLinkURIChecker targetLinkURIChecker() {
        return this.deepLinkFilter;
    }

    public void setTargetLinkURIChecker(TargetLinkURIChecker deepLinkFilter) {
        this.deepLinkFilter = deepLinkFilter;
    }

    protected class TargetLinkURIAuthenticationSuccessHandler
    implements AuthenticationSuccessHandler {
        private AuthenticationSuccessHandler passthrough;

        protected TargetLinkURIAuthenticationSuccessHandler() {
        }

        public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
            HttpSession session = request.getSession();
            String target = OIDCAuthenticationFilter.getStoredSessionString(session, OIDCAuthenticationFilter.TARGET_SESSION_VARIABLE);
            if (!Strings.isNullOrEmpty((String)target)) {
                session.removeAttribute(OIDCAuthenticationFilter.TARGET_SESSION_VARIABLE);
                target = OIDCAuthenticationFilter.this.deepLinkFilter.filter(target);
                response.sendRedirect(target);
            } else {
                this.passthrough.onAuthenticationSuccess(request, response, authentication);
            }
        }
    }
}

