/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import java.util.Map;
import java.util.Set;
import org.mitre.openid.connect.client.service.ServerConfigurationService;
import org.mitre.openid.connect.client.service.impl.DynamicServerConfigurationService;
import org.mitre.openid.connect.client.service.impl.StaticServerConfigurationService;
import org.mitre.openid.connect.config.ServerConfiguration;

public class HybridServerConfigurationService
implements ServerConfigurationService {
    private StaticServerConfigurationService staticServerService = new StaticServerConfigurationService();
    private DynamicServerConfigurationService dynamicServerService = new DynamicServerConfigurationService();

    @Override
    public ServerConfiguration getServerConfiguration(String issuer) {
        ServerConfiguration server = this.staticServerService.getServerConfiguration(issuer);
        if (server != null) {
            return server;
        }
        return this.dynamicServerService.getServerConfiguration(issuer);
    }

    public Map<String, ServerConfiguration> getServers() {
        return this.staticServerService.getServers();
    }

    public void setServers(Map<String, ServerConfiguration> servers) {
        this.staticServerService.setServers(servers);
    }

    public Set<String> getWhitelist() {
        return this.dynamicServerService.getWhitelist();
    }

    public void setWhitelist(Set<String> whitelist) {
        this.dynamicServerService.setWhitelist(whitelist);
    }

    public Set<String> getBlacklist() {
        return this.dynamicServerService.getBlacklist();
    }

    public void setBlacklist(Set<String> blacklist) {
        this.dynamicServerService.setBlacklist(blacklist);
    }
}

