/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.mitre.discovery.util.WebfingerURLNormalizer;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.IssuerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;

public class WebfingerIssuerService
implements IssuerService {
    private static final Logger logger = LoggerFactory.getLogger(WebfingerIssuerService.class);
    private LoadingCache<UriComponents, String> issuers;
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();
    private String parameterName = "identifier";
    private String loginPageUrl;
    private boolean forceHttps = true;

    public WebfingerIssuerService() {
        this.issuers = CacheBuilder.newBuilder().build((CacheLoader)new WebfingerIssuerFetcher());
    }

    @Override
    public IssuerServiceResponse getIssuer(HttpServletRequest request) {
        String identifier = request.getParameter(this.parameterName);
        if (!Strings.isNullOrEmpty((String)identifier)) {
            try {
                String issuer = (String)this.issuers.get((Object)WebfingerURLNormalizer.normalizeResource((String)identifier));
                if (!this.whitelist.isEmpty() && !this.whitelist.contains(issuer)) {
                    throw new AuthenticationServiceException("Whitelist was nonempty, issuer was not in whitelist: " + issuer);
                }
                if (this.blacklist.contains(issuer)) {
                    throw new AuthenticationServiceException("Issuer was in blacklist: " + issuer);
                }
                return new IssuerServiceResponse(issuer, identifier, null);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                logger.warn("Issue fetching issuer for user input: " + identifier + ": " + e.getMessage());
                return null;
            }
        }
        logger.warn("No user input given, directing to login page: " + this.loginPageUrl);
        return new IssuerServiceResponse(this.loginPageUrl);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getLoginPageUrl() {
        return this.loginPageUrl;
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Set<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    public boolean isForceHttps() {
        return this.forceHttps;
    }

    public void setForceHttps(boolean forceHttps) {
        this.forceHttps = forceHttps;
    }

    private class WebfingerIssuerFetcher
    extends CacheLoader<UriComponents, String> {
        private HttpClient httpClient = HttpClientBuilder.create().useSystemProperties().build();
        private HttpComponentsClientHttpRequestFactory httpFactory = new HttpComponentsClientHttpRequestFactory(this.httpClient);
        private JsonParser parser = new JsonParser();

        private WebfingerIssuerFetcher() {
        }

        public String load(UriComponents key) throws Exception {
            RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)this.httpFactory);
            String scheme = key.getScheme();
            if (!Strings.isNullOrEmpty((String)scheme) && scheme.equals("http")) {
                if (WebfingerIssuerService.this.forceHttps) {
                    throw new IllegalArgumentException("Scheme must start with htps");
                }
                logger.warn("Webfinger endpoint MUST use the https URI scheme, overriding by configuration");
                scheme = "http://";
            } else {
                scheme = "https://";
            }
            URIBuilder builder = new URIBuilder(scheme + key.getHost() + (key.getPort() >= 0 ? ":" + key.getPort() : "") + Strings.nullToEmpty((String)key.getPath()) + "/.well-known/webfinger" + (Strings.isNullOrEmpty((String)key.getQuery()) ? "" : "?" + key.getQuery()));
            builder.addParameter("resource", key.toString());
            builder.addParameter("rel", "http://openid.net/specs/connect/1.0/issuer");
            try {
                logger.info("Loading: " + builder.toString());
                String webfingerResponse = (String)restTemplate.getForObject(builder.build(), String.class);
                JsonElement json = this.parser.parse(webfingerResponse);
                if (json != null && json.isJsonObject()) {
                    JsonArray links = json.getAsJsonObject().get("links").getAsJsonArray();
                    for (JsonElement link : links) {
                        JsonObject linkObj;
                        if (!link.isJsonObject() || !(linkObj = link.getAsJsonObject()).has("href") || !linkObj.has("rel") || !linkObj.get("rel").getAsString().equals("http://openid.net/specs/connect/1.0/issuer")) continue;
                        return linkObj.get("href").getAsString();
                    }
                }
            }
            catch (JsonParseException | RestClientException e) {
                logger.warn("Failure in fetching webfinger input", (Object)e.getMessage());
            }
            if (key.getScheme().equals("http") || key.getScheme().equals("https")) {
                logger.warn("Returning normalized input string as issuer, hoping for the best: " + key.toString());
                return key.toString();
            }
            logger.warn("Couldn't find issuer: " + key.toString());
            throw new IllegalArgumentException();
        }
    }
}

