/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import java.util.Map;
import java.util.Set;
import org.mitre.oauth2.model.RegisteredClient;
import org.mitre.openid.connect.client.service.ClientConfigurationService;
import org.mitre.openid.connect.client.service.RegisteredClientService;
import org.mitre.openid.connect.client.service.impl.DynamicRegistrationClientConfigurationService;
import org.mitre.openid.connect.client.service.impl.StaticClientConfigurationService;
import org.mitre.openid.connect.config.ServerConfiguration;

public class HybridClientConfigurationService
implements ClientConfigurationService {
    private StaticClientConfigurationService staticClientService = new StaticClientConfigurationService();
    private DynamicRegistrationClientConfigurationService dynamicClientService = new DynamicRegistrationClientConfigurationService();

    @Override
    public RegisteredClient getClientConfiguration(ServerConfiguration issuer) {
        RegisteredClient client = this.staticClientService.getClientConfiguration(issuer);
        if (client != null) {
            return client;
        }
        return this.dynamicClientService.getClientConfiguration(issuer);
    }

    public Map<String, RegisteredClient> getClients() {
        return this.staticClientService.getClients();
    }

    public void setClients(Map<String, RegisteredClient> clients) {
        this.staticClientService.setClients(clients);
    }

    public RegisteredClient getTemplate() {
        return this.dynamicClientService.getTemplate();
    }

    public void setTemplate(RegisteredClient template) {
        this.dynamicClientService.setTemplate(template);
    }

    public RegisteredClientService getRegisteredClientService() {
        return this.dynamicClientService.getRegisteredClientService();
    }

    public void setRegisteredClientService(RegisteredClientService registeredClientService) {
        this.dynamicClientService.setRegisteredClientService(registeredClientService);
    }

    public Set<String> getWhitelist() {
        return this.dynamicClientService.getWhitelist();
    }

    public void setWhitelist(Set<String> whitelist) {
        this.dynamicClientService.setWhitelist(whitelist);
    }

    public Set<String> getBlacklist() {
        return this.dynamicClientService.getBlacklist();
    }

    public void setBlacklist(Set<String> blacklist) {
        this.dynamicClientService.setBlacklist(blacklist);
    }
}

