/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.base.Strings;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.IssuerService;
import org.springframework.security.authentication.AuthenticationServiceException;

public class ThirdPartyIssuerService
implements IssuerService {
    private String accountChooserUrl;
    private Set<String> whitelist = new HashSet<String>();
    private Set<String> blacklist = new HashSet<String>();

    @Override
    public IssuerServiceResponse getIssuer(HttpServletRequest request) {
        String iss = request.getParameter("iss");
        if (!Strings.isNullOrEmpty((String)iss)) {
            if (!this.whitelist.isEmpty() && !this.whitelist.contains(iss)) {
                throw new AuthenticationServiceException("Whitelist was nonempty, issuer was not in whitelist: " + iss);
            }
            if (this.blacklist.contains(iss)) {
                throw new AuthenticationServiceException("Issuer was in blacklist: " + iss);
            }
            return new IssuerServiceResponse(iss, request.getParameter("login_hint"), request.getParameter("target_link_uri"));
        }
        try {
            String redirectUri = request.getRequestURL().toString();
            URIBuilder builder = new URIBuilder(this.accountChooserUrl);
            builder.addParameter("redirect_uri", redirectUri);
            return new IssuerServiceResponse(builder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new AuthenticationServiceException("Account Chooser URL is not valid", (Throwable)e);
        }
    }

    public String getAccountChooserUrl() {
        return this.accountChooserUrl;
    }

    public void setAccountChooserUrl(String accountChooserUrl) {
        this.accountChooserUrl = accountChooserUrl;
    }

    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(Set<String> whitelist) {
        this.whitelist = whitelist;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (Strings.isNullOrEmpty((String)this.accountChooserUrl)) {
            throw new IllegalArgumentException("Account Chooser URL cannot be null or empty");
        }
    }
}

