/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.dictionary;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdiameter.client.impl.DictionarySingleton;
import org.jdiameter.common.impl.validation.AvpRepresentationImpl;
import org.jdiameter.common.impl.validation.DictionaryImpl;
import org.mobicents.diameter.dictionary.AvpRepresentation;

public class AvpDictionary {
    private static transient Logger logger = Logger.getLogger(AvpDictionary.class);
    public static final AvpDictionary INSTANCE = new AvpDictionary();
    private DictionaryImpl stackDictionary;
    private HashMap<AvpRepresentation, AvpRepresentation> avpMap = new HashMap();
    private Map<String, AvpRepresentation> nameToCodeMap = new HashMap<String, AvpRepresentation>();

    private AvpDictionary() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDictionary(String filename) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            this.parseDictionary(fis);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close FileInputStream", (Throwable)e);
                }
                fis = null;
            }
        }
    }

    public void parseDictionary(InputStream is) throws Exception {
        this.stackDictionary = (DictionaryImpl)DictionarySingleton.getDictionary((InputStream)is);
        this.avpMap.clear();
        this.nameToCodeMap.clear();
        for (org.jdiameter.api.validation.AvpRepresentation value : this.stackDictionary.getAvpMap().values()) {
            AvpRepresentation avp = new AvpRepresentation((AvpRepresentationImpl)value);
            this.avpMap.put(avp, avp);
            this.nameToCodeMap.put(avp.getName(), avp);
        }
    }

    public AvpRepresentation getAvp(int code) {
        return this.getAvp(code, 0L);
    }

    public AvpRepresentation getAvp(int code, long vendorId) {
        AvpRepresentation avp = this.avpMap.get(this.getMapKey(code, vendorId));
        if (avp == null) {
            logger.warn((Object)("AVP with code " + code + " and Vendor-Id " + vendorId + " not present in dictionary!"));
        }
        return avp;
    }

    public AvpRepresentation getAvp(String avpName) {
        AvpRepresentation avpKey = this.nameToCodeMap.get(avpName);
        return avpKey != null ? this.avpMap.get(avpKey) : null;
    }

    private AvpRepresentation getMapKey(int code, long vendorId) {
        return new AvpRepresentation(code, vendorId);
    }
}

