/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack.management;

import java.io.Serializable;
import org.jdiameter.api.ApplicationId;

public class ApplicationIdJMX
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long vendorId = null;
    private Long authApplicationId = null;
    private Long acctApplicationId = null;

    private ApplicationIdJMX(Long vendorId, Long authApplicationId, Long acctApplicationId) {
        this.vendorId = vendorId;
        this.authApplicationId = authApplicationId;
        this.acctApplicationId = acctApplicationId;
    }

    public static ApplicationIdJMX createAcctApplicationId(long vendorId, long applicationId) {
        return new ApplicationIdJMX(vendorId, null, applicationId);
    }

    public static ApplicationIdJMX createAuthApplicationId(long vendorId, long applicationId) {
        return new ApplicationIdJMX(vendorId, applicationId, null);
    }

    public static ApplicationIdJMX createAcctApplicationId(long applicationId) {
        return ApplicationIdJMX.createAcctApplicationId(0L, applicationId);
    }

    public static ApplicationIdJMX createAuthApplicationId(long applicationId) {
        return ApplicationIdJMX.createAuthApplicationId(0L, applicationId);
    }

    public Long getAcctApplicationId() {
        return this.acctApplicationId;
    }

    public Long getAuthApplicationId() {
        return this.authApplicationId;
    }

    public Long getVendorId() {
        return this.vendorId;
    }

    public ApplicationId asApplicationId() {
        return this.authApplicationId != null ? ApplicationId.createByAuthAppId((long)this.vendorId, (long)this.authApplicationId) : ApplicationId.createByAccAppId((long)this.vendorId, (long)this.acctApplicationId);
    }

    public static ApplicationIdJMX fromApplicationId(ApplicationId appId) {
        if (appId.getAuthAppId() != 0L) {
            return new ApplicationIdJMX(appId.getVendorId(), appId.getAuthAppId(), null);
        }
        return new ApplicationIdJMX(appId.getVendorId(), null, appId.getAcctAppId());
    }

    public String toString() {
        return "ApplicationID[vendor=" + this.vendorId + "; Auth=" + this.authApplicationId + "; Acct=" + this.acctApplicationId + "]";
    }
}

