/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack.management;

import java.util.HashMap;
import java.util.Map;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.PeerTable;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.jdiameter.server.impl.MutablePeerTableImpl;
import org.mobicents.diameter.stack.management.ApplicationIdJMX;
import org.mobicents.diameter.stack.management.DiameterConfiguration;
import org.mobicents.diameter.stack.management.Network;
import org.mobicents.diameter.stack.management.NetworkPeer;
import org.mobicents.diameter.stack.management.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkImpl
implements Network {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(NetworkImpl.class);
    private Map<String, NetworkPeer> peers = new HashMap<String, NetworkPeer>();
    private Map<String, Realm> realms = new HashMap<String, Realm>();

    @Override
    public Map<String, NetworkPeer> getPeers() {
        return this.peers;
    }

    @Override
    public NetworkPeer getPeer(String name) {
        return this.peers.get(name);
    }

    @Override
    public void addPeer(NetworkPeer peer) {
        this.peers.put(peer.getName(), peer);
    }

    @Override
    public void addPeerRuntime(NetworkPeer peer, String realm) {
        try {
            org.jdiameter.server.impl.NetworkImpl n = (org.jdiameter.server.impl.NetworkImpl)DiameterConfiguration.stack.unwrap(org.jdiameter.api.Network.class);
            n.addPeer(peer.getName(), realm, peer.getAttemptConnect().booleanValue());
        }
        catch (InternalException e) {
            logger.error("Failed to unwrap class.", (Throwable)e);
        }
    }

    @Override
    public void removePeer(String name) {
        try {
            MutablePeerTableImpl mpt = (MutablePeerTableImpl)DiameterConfiguration.stack.unwrap(PeerTable.class);
            mpt.removePeer(name);
        }
        catch (InternalException e) {
            logger.error("Failed to unwrap class.", (Throwable)e);
        }
    }

    @Override
    public Map<String, Realm> getRealms() {
        return this.realms;
    }

    @Override
    public Realm getRealm(String name) {
        return this.realms.get(name);
    }

    @Override
    public void addRealm(Realm realm) {
        this.realms.put(realm.getName(), realm);
    }

    @Override
    public void addRealmRuntime(Realm realm) {
        try {
            org.jdiameter.server.impl.NetworkImpl n = (org.jdiameter.server.impl.NetworkImpl)DiameterConfiguration.stack.unwrap(org.jdiameter.api.Network.class);
            for (ApplicationIdJMX appId : realm.getApplicationIds()) {
                IAgentConfiguration agentConfiguration = null;
                if (realm instanceof IRealm) {
                    agentConfiguration = ((IRealm)realm).getAgentConfiguration();
                }
                n.addRealm(realm.getName(), appId.asApplicationId(), LocalAction.valueOf((String)realm.getLocalAction()), agentConfiguration, realm.getDynamic().booleanValue(), realm.getExpTime().longValue());
            }
        }
        catch (InternalException e) {
            logger.error("Failed to unwrap class.", (Throwable)e);
        }
    }

    @Override
    public void removeRealm(String name) {
        try {
            org.jdiameter.server.impl.NetworkImpl n = (org.jdiameter.server.impl.NetworkImpl)DiameterConfiguration.stack.unwrap(org.jdiameter.api.Network.class);
            n.remRealm(name);
        }
        catch (InternalException e) {
            logger.error("Failed to unwrap class.", (Throwable)e);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("  ## PEERS ##\r\n");
        for (NetworkPeer peer : this.peers.values()) {
            buf.append(peer.toString());
        }
        buf.append("  ## REALMS ##\r\n");
        for (Realm realm : this.realms.values()) {
            buf.append(realm.toString());
        }
        return buf.toString();
    }
}

