/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.diameter.stack.management;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Network;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.jdiameter.server.impl.NetworkImpl;
import org.mobicents.diameter.stack.management.ApplicationIdJMX;
import org.mobicents.diameter.stack.management.DiameterConfiguration;
import org.mobicents.diameter.stack.management.Realm;

public class RealmImpl
implements Realm {
    private static final long serialVersionUID = 1L;
    private Collection<ApplicationIdJMX> applicationIds;
    private String name;
    private Collection<String> peers;
    private String localAction;
    private Boolean dynamic;
    private Long expTime;
    private IAgentConfiguration agentConfiguration;
    private String originalName;

    public RealmImpl(Collection<ApplicationIdJMX> applicationIds, String name, Collection<String> peers, String localAction, IAgentConfiguration agentConfiguration, Boolean dynamic, Long expTime) {
        this.applicationIds = applicationIds;
        this.name = name;
        this.peers = peers;
        this.localAction = localAction;
        this.dynamic = dynamic;
        this.expTime = expTime;
    }

    @Override
    public Collection<ApplicationIdJMX> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public void addApplicationId(ApplicationIdJMX applicationId) {
        this.applicationIds.add(applicationId);
    }

    @Override
    public void removeApplicationId(ApplicationIdJMX applicationId) {
        this.applicationIds.remove(applicationId);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!this.name.equals(name)) {
            this.originalName = this.name;
            this.name = name;
        }
    }

    @Override
    public Collection<String> getPeers() {
        return this.peers;
    }

    @Override
    public void setPeers(Collection<String> peers) {
        this.peers = peers;
    }

    @Override
    public void addPeer(String peer) {
        this.peers.add(peer);
    }

    @Override
    public void removePeer(String peer) {
        this.peers.remove(peer);
    }

    @Override
    public String getLocalAction() {
        return this.localAction;
    }

    @Override
    public void setLocalAction(String localAction) {
        this.localAction = localAction;
    }

    @Override
    public Boolean getDynamic() {
        return this.dynamic;
    }

    @Override
    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public Long getExpTime() {
        return this.expTime;
    }

    @Override
    public void setExpTime(Long expTime) {
        this.expTime = expTime;
    }

    public String toString() {
        String dotsString = " .............................................................";
        StringBuffer toStringBuffer = new StringBuffer();
        try {
            Class<?> cls = Class.forName(this.getClass().getName());
            Field[] fieldlist = cls.getDeclaredFields();
            for (int i = 0; i < fieldlist.length; ++i) {
                Field fld = fieldlist[i];
                if (Modifier.isStatic(fld.getModifiers())) continue;
                toStringBuffer.append(fld.getName());
                int dots = 60 - fld.getName().length();
                toStringBuffer.append(dotsString, 0, dots);
                toStringBuffer.append(" ").append(fld.get(this)).append("\r\n");
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return toStringBuffer.toString();
    }

    public void updateRealm() {
        try {
            NetworkImpl n = (NetworkImpl)DiameterConfiguration.stack.unwrap(Network.class);
            for (ApplicationIdJMX appId : this.applicationIds) {
                org.jdiameter.api.Realm r = n.addRealm(this.name, appId.asApplicationId(), LocalAction.valueOf((String)this.localAction), this.agentConfiguration, this.dynamic.booleanValue(), this.expTime.longValue());
                for (String host : this.peers) {
                    ((IRealm)r).addPeerName(host);
                }
            }
            if (this.originalName != null) {
                n.remRealm(this.originalName);
                this.originalName = null;
            }
        }
        catch (InternalException internalException) {
            // empty catch block
        }
    }
}

