/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.chars;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.SIPHeaderNamesCache;
import gov.nist.javax.sip.parser.chars.AcceptEncodingParser;
import gov.nist.javax.sip.parser.chars.AcceptLanguageParser;
import gov.nist.javax.sip.parser.chars.AcceptParser;
import gov.nist.javax.sip.parser.chars.AlertInfoParser;
import gov.nist.javax.sip.parser.chars.AllowEventsParser;
import gov.nist.javax.sip.parser.chars.AllowParser;
import gov.nist.javax.sip.parser.chars.AuthenticationInfoParser;
import gov.nist.javax.sip.parser.chars.AuthorizationParser;
import gov.nist.javax.sip.parser.chars.CSeqParser;
import gov.nist.javax.sip.parser.chars.CallIDParser;
import gov.nist.javax.sip.parser.chars.CallInfoParser;
import gov.nist.javax.sip.parser.chars.ContactParser;
import gov.nist.javax.sip.parser.chars.ContentDispositionParser;
import gov.nist.javax.sip.parser.chars.ContentEncodingParser;
import gov.nist.javax.sip.parser.chars.ContentLanguageParser;
import gov.nist.javax.sip.parser.chars.ContentLengthParser;
import gov.nist.javax.sip.parser.chars.ContentTypeParser;
import gov.nist.javax.sip.parser.chars.DateParser;
import gov.nist.javax.sip.parser.chars.ErrorInfoParser;
import gov.nist.javax.sip.parser.chars.EventParser;
import gov.nist.javax.sip.parser.chars.ExpiresParser;
import gov.nist.javax.sip.parser.chars.FromParser;
import gov.nist.javax.sip.parser.chars.HeaderParser;
import gov.nist.javax.sip.parser.chars.InReplyToParser;
import gov.nist.javax.sip.parser.chars.Lexer;
import gov.nist.javax.sip.parser.chars.MaxForwardsParser;
import gov.nist.javax.sip.parser.chars.MimeVersionParser;
import gov.nist.javax.sip.parser.chars.MinExpiresParser;
import gov.nist.javax.sip.parser.chars.OrganizationParser;
import gov.nist.javax.sip.parser.chars.PriorityParser;
import gov.nist.javax.sip.parser.chars.ProxyAuthenticateParser;
import gov.nist.javax.sip.parser.chars.ProxyAuthorizationParser;
import gov.nist.javax.sip.parser.chars.ProxyRequireParser;
import gov.nist.javax.sip.parser.chars.RAckParser;
import gov.nist.javax.sip.parser.chars.RSeqParser;
import gov.nist.javax.sip.parser.chars.ReasonParser;
import gov.nist.javax.sip.parser.chars.RecordRouteParser;
import gov.nist.javax.sip.parser.chars.ReferToParser;
import gov.nist.javax.sip.parser.chars.ReplyToParser;
import gov.nist.javax.sip.parser.chars.RequireParser;
import gov.nist.javax.sip.parser.chars.RetryAfterParser;
import gov.nist.javax.sip.parser.chars.RouteParser;
import gov.nist.javax.sip.parser.chars.SIPETagParser;
import gov.nist.javax.sip.parser.chars.SIPIfMatchParser;
import gov.nist.javax.sip.parser.chars.ServerParser;
import gov.nist.javax.sip.parser.chars.SubjectParser;
import gov.nist.javax.sip.parser.chars.SubscriptionStateParser;
import gov.nist.javax.sip.parser.chars.SupportedParser;
import gov.nist.javax.sip.parser.chars.TimeStampParser;
import gov.nist.javax.sip.parser.chars.ToParser;
import gov.nist.javax.sip.parser.chars.UnsupportedParser;
import gov.nist.javax.sip.parser.chars.UserAgentParser;
import gov.nist.javax.sip.parser.chars.ViaParser;
import gov.nist.javax.sip.parser.chars.WWWAuthenticateParser;
import gov.nist.javax.sip.parser.chars.WarningParser;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParserFactory {
    private static Map<String, Class<? extends HeaderParser>> parserTable = new ConcurrentHashMap<String, Class<? extends HeaderParser>>(90);
    private static Class[] constructorArgs;
    private static ConcurrentHashMap<Class, Constructor> parserConstructorCache;

    public static HeaderParser createParser(char[] line) throws ParseException {
        String headerName = Lexer.getHeaderName(line);
        String headerValue = Lexer.getHeaderValue(line);
        if (headerName == null || headerValue == null) {
            throw new ParseException("The header name or value is null", 0);
        }
        Class<? extends HeaderParser> parserClass = parserTable.get(SIPHeaderNamesCache.toLowerCase((String)headerName));
        if (parserClass != null) {
            try {
                Constructor<? extends HeaderParser> cons = parserConstructorCache.get(parserClass);
                if (cons == null) {
                    cons = parserClass.getConstructor(constructorArgs);
                    parserConstructorCache.putIfAbsent(parserClass, cons);
                }
                Object[] args = new Object[]{line};
                HeaderParser retval = cons.newInstance(args);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException((Exception)ex);
                return null;
            }
        }
        return new HeaderParser(line);
    }

    static {
        parserConstructorCache = new ConcurrentHashMap();
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = char[].class;
        parserTable.put("Reply-To".toLowerCase(), ReplyToParser.class);
        parserTable.put("In-Reply-To".toLowerCase(), InReplyToParser.class);
        parserTable.put("Accept-Encoding".toLowerCase(), AcceptEncodingParser.class);
        parserTable.put("Accept-Language".toLowerCase(), AcceptLanguageParser.class);
        parserTable.put("t", ToParser.class);
        parserTable.put("To".toLowerCase(), ToParser.class);
        parserTable.put("From".toLowerCase(), FromParser.class);
        parserTable.put("f", FromParser.class);
        parserTable.put("CSeq".toLowerCase(), CSeqParser.class);
        parserTable.put("Via".toLowerCase(), ViaParser.class);
        parserTable.put("v", ViaParser.class);
        parserTable.put("Contact".toLowerCase(), ContactParser.class);
        parserTable.put("m", ContactParser.class);
        parserTable.put("Content-Type".toLowerCase(), ContentTypeParser.class);
        parserTable.put("c", ContentTypeParser.class);
        parserTable.put("Content-Length".toLowerCase(), ContentLengthParser.class);
        parserTable.put("l", ContentLengthParser.class);
        parserTable.put("Authorization".toLowerCase(), AuthorizationParser.class);
        parserTable.put("WWW-Authenticate".toLowerCase(), WWWAuthenticateParser.class);
        parserTable.put("Call-ID".toLowerCase(), CallIDParser.class);
        parserTable.put("i", CallIDParser.class);
        parserTable.put("Route".toLowerCase(), RouteParser.class);
        parserTable.put("Record-Route".toLowerCase(), RecordRouteParser.class);
        parserTable.put("Date".toLowerCase(), DateParser.class);
        parserTable.put("Proxy-Authorization".toLowerCase(), ProxyAuthorizationParser.class);
        parserTable.put("Proxy-Authenticate".toLowerCase(), ProxyAuthenticateParser.class);
        parserTable.put("Retry-After".toLowerCase(), RetryAfterParser.class);
        parserTable.put("Require".toLowerCase(), RequireParser.class);
        parserTable.put("Proxy-Require".toLowerCase(), ProxyRequireParser.class);
        parserTable.put("Timestamp".toLowerCase(), TimeStampParser.class);
        parserTable.put("Unsupported".toLowerCase(), UnsupportedParser.class);
        parserTable.put("User-Agent".toLowerCase(), UserAgentParser.class);
        parserTable.put("Supported".toLowerCase(), SupportedParser.class);
        parserTable.put("k", SupportedParser.class);
        parserTable.put("Server".toLowerCase(), ServerParser.class);
        parserTable.put("Subject".toLowerCase(), SubjectParser.class);
        parserTable.put("s", SubjectParser.class);
        parserTable.put("Subscription-State".toLowerCase(), SubscriptionStateParser.class);
        parserTable.put("Max-Forwards".toLowerCase(), MaxForwardsParser.class);
        parserTable.put("MIME-Version".toLowerCase(), MimeVersionParser.class);
        parserTable.put("Min-Expires".toLowerCase(), MinExpiresParser.class);
        parserTable.put("Organization".toLowerCase(), OrganizationParser.class);
        parserTable.put("Priority".toLowerCase(), PriorityParser.class);
        parserTable.put("RAck".toLowerCase(), RAckParser.class);
        parserTable.put("RSeq".toLowerCase(), RSeqParser.class);
        parserTable.put("Reason".toLowerCase(), ReasonParser.class);
        parserTable.put("Warning".toLowerCase(), WarningParser.class);
        parserTable.put("Expires".toLowerCase(), ExpiresParser.class);
        parserTable.put("Event".toLowerCase(), EventParser.class);
        parserTable.put("o", EventParser.class);
        parserTable.put("Error-Info".toLowerCase(), ErrorInfoParser.class);
        parserTable.put("Content-Language".toLowerCase(), ContentLanguageParser.class);
        parserTable.put("Content-Encoding".toLowerCase(), ContentEncodingParser.class);
        parserTable.put("e", ContentEncodingParser.class);
        parserTable.put("Content-Disposition".toLowerCase(), ContentDispositionParser.class);
        parserTable.put("Call-Info".toLowerCase(), CallInfoParser.class);
        parserTable.put("Authentication-Info".toLowerCase(), AuthenticationInfoParser.class);
        parserTable.put("Allow".toLowerCase(), AllowParser.class);
        parserTable.put("Allow-Events".toLowerCase(), AllowEventsParser.class);
        parserTable.put("u", AllowEventsParser.class);
        parserTable.put("Alert-Info".toLowerCase(), AlertInfoParser.class);
        parserTable.put("Accept".toLowerCase(), AcceptParser.class);
        parserTable.put("Refer-To".toLowerCase(), ReferToParser.class);
        parserTable.put("r", ReferToParser.class);
        parserTable.put("SIP-ETag".toLowerCase(), SIPETagParser.class);
        parserTable.put("SIP-If-Match".toLowerCase(), SIPIfMatchParser.class);
    }
}

