/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.congestion;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import org.mobicents.commons.congestion.CPUProcessCongestionMonitor;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.commons.congestion.MemoryCongestionMonitor;
import org.mobicents.ext.javax.sip.SipStackExtension;
import org.mobicents.ext.javax.sip.congestion.DialogCongestionMonitor;
import org.mobicents.ext.javax.sip.congestion.ServerTransactionCongestionMonitor;

public class CongestionControlTimerTask
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(CongestionControlTimerTask.class);
    private MemoryCongestionMonitor memoryCongestionMonitor;
    private CPUProcessCongestionMonitor cpuProcessCongestionMonitor;
    private ServerTransactionCongestionMonitor maxServerTransactionsCongestionMonitor;
    private DialogCongestionMonitor dialogCongestionMonitor;

    public CongestionControlTimerTask(CongestionListener congestionListener, SipStackExtension sipStack) {
        String memoryThresholdString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.MEMORY_THRESHOLD", "85");
        String backToNormalMemoryThresholdString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.BACK_TO_NORMAL_MEMORY_THRESHOLD", "80");
        String cpuThresholdString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.CPU_PROCESS_THRESHOLD", "85");
        String backToNormalCPUThresholdString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.BACK_TO_NORMAL_CPU_PROCESS_THRESHOLD", "80");
        String serverTransactionsString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.SERVER_TRANSACTIONS_THRESHOLD", "15000");
        String backToNormalServerTransactionsString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.BACK_TO_NORMAL_SERVER_TRANSACTIONS_THRESHOLD", "10000");
        String dialogsString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.DIALOGS_THRESHOLD", "200000");
        String backToNormalDialogsString = sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.BACK_TO_NORMAL_DIALOGS_THRESHOLD", "180000");
        int memoryThreshold = new Integer(memoryThresholdString);
        int backToNormalMemoryThreshold = new Integer(backToNormalMemoryThresholdString);
        double cpuProcessThreshold = new Double(cpuThresholdString);
        double backToNormalCPUProcessThreshold = new Double(backToNormalCPUThresholdString);
        long maxServerTransactions = new Long(serverTransactionsString);
        long backToNormalMaxServerTransactions = new Long(backToNormalServerTransactionsString);
        long maxDialogs = new Long(dialogsString);
        long backToNormalDialogs = new Long(backToNormalDialogsString);
        if (memoryThreshold > 0) {
            this.memoryCongestionMonitor = new MemoryCongestionMonitor();
            this.memoryCongestionMonitor.setMemoryThreshold(memoryThreshold);
            this.memoryCongestionMonitor.setBackToNormalMemoryThreshold(backToNormalMemoryThreshold);
            this.memoryCongestionMonitor.addCongestionListener(congestionListener);
        }
        if (cpuProcessThreshold > 0.0) {
            this.cpuProcessCongestionMonitor = new CPUProcessCongestionMonitor();
            this.cpuProcessCongestionMonitor.setCPUThreshold(cpuProcessThreshold);
            this.cpuProcessCongestionMonitor.setBackToNormalCPUThreshold(backToNormalCPUProcessThreshold);
            this.cpuProcessCongestionMonitor.addCongestionListener(congestionListener);
        }
        if (maxServerTransactions > 0L) {
            this.maxServerTransactionsCongestionMonitor = new ServerTransactionCongestionMonitor(sipStack);
            this.maxServerTransactionsCongestionMonitor.setServerTransactionsThreshold(maxServerTransactions);
            this.maxServerTransactionsCongestionMonitor.setBackToNormalServerTransactionsThreshold(backToNormalMaxServerTransactions);
            this.maxServerTransactionsCongestionMonitor.addCongestionListener(congestionListener);
        }
        if (maxDialogs > 0L) {
            this.dialogCongestionMonitor = new DialogCongestionMonitor(sipStack);
            this.dialogCongestionMonitor.setDialogsThreshold(maxDialogs);
            this.dialogCongestionMonitor.setBackToNormalDialogsThreshold(backToNormalDialogs);
            this.dialogCongestionMonitor.addCongestionListener(congestionListener);
        }
    }

    public void run() {
        if (logger.isLoggingEnabled(64)) {
            logger.logTrace("JAIN SIP Ext Congestion Control Timer Task now running");
        }
        if (this.memoryCongestionMonitor != null) {
            this.memoryCongestionMonitor.monitor();
        }
        if (this.cpuProcessCongestionMonitor != null) {
            this.cpuProcessCongestionMonitor.monitor();
        }
        if (this.maxServerTransactionsCongestionMonitor != null) {
            this.maxServerTransactionsCongestionMonitor.monitor();
        }
        if (this.dialogCongestionMonitor != null) {
            this.dialogCongestionMonitor.monitor();
        }
    }
}

