/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.timers;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class MockSipTimer
implements SipTimer {
    private static StackLogger logger = CommonLogger.getLogger(MockSipTimer.class);
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected SipStackImpl sipStackImpl;

    public boolean schedule(SIPStackTimerTask task, long delay) {
        return true;
    }

    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        return true;
    }

    public boolean cancel(SIPStackTimerTask task) {
        return true;
    }

    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.started.set(true);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    public void stop() {
        this.started.set(false);
        logger.logStackTrace(32);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

