/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessage;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageCancelFailed;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageFactory;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageParameterless;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageRequestedInfoError;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageTaskRefused;
import org.mobicents.protocols.ss7.cap.api.errors.CancelProblem;
import org.mobicents.protocols.ss7.cap.api.errors.RequestedInfoErrorParameter;
import org.mobicents.protocols.ss7.cap.api.errors.TaskRefusedParameter;
import org.mobicents.protocols.ss7.cap.api.errors.UnavailableNetworkResource;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageCancelFailedImpl;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageParameterlessImpl;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageRequestedInfoErrorImpl;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageSystemFailureImpl;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageTaskRefusedImpl;

public class CAPErrorMessageFactoryImpl
implements CAPErrorMessageFactory {
    public CAPErrorMessage createMessageFromErrorCode(Long errorCode) {
        int ec = (int)errorCode.longValue();
        switch (ec) {
            case 1: {
                CAPErrorMessageCancelFailedImpl emCancelFailed = new CAPErrorMessageCancelFailedImpl();
                return emCancelFailed;
            }
            case 10: {
                CAPErrorMessageRequestedInfoErrorImpl emRequestedInfoError = new CAPErrorMessageRequestedInfoErrorImpl();
                return emRequestedInfoError;
            }
            case 11: {
                CAPErrorMessageSystemFailureImpl emSystemFailure = new CAPErrorMessageSystemFailureImpl();
                return emSystemFailure;
            }
            case 12: {
                CAPErrorMessageTaskRefusedImpl emTaskRefused = new CAPErrorMessageTaskRefusedImpl();
                return emTaskRefused;
            }
        }
        return new CAPErrorMessageParameterlessImpl(errorCode);
    }

    public CAPErrorMessageParameterless createCAPErrorMessageParameterless(Long errorCode) {
        return new CAPErrorMessageParameterlessImpl(errorCode);
    }

    public CAPErrorMessageCancelFailed createCAPErrorMessageCancelFailed(CancelProblem cancelProblem) {
        return new CAPErrorMessageCancelFailedImpl(cancelProblem);
    }

    public CAPErrorMessageRequestedInfoError createCAPErrorMessageRequestedInfoError(RequestedInfoErrorParameter requestedInfoErrorParameter) {
        return new CAPErrorMessageRequestedInfoErrorImpl(requestedInfoErrorParameter);
    }

    public CAPErrorMessageSystemFailure createCAPErrorMessageSystemFailure(UnavailableNetworkResource unavailableNetworkResource) {
        return new CAPErrorMessageSystemFailureImpl(unavailableNetworkResource);
    }

    public CAPErrorMessageTaskRefused createCAPErrorMessageTaskRefused(TaskRefusedParameter taskRefusedParameter) {
        return new CAPErrorMessageTaskRefusedImpl(taskRefusedParameter);
    }
}

